/*
 * Decompiled with CFR 0.152.
 */
package net.TechDude.CraftingQuest;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CraftingQuest
extends JavaPlugin
implements Listener {
    public String prefix = ChatColor.DARK_AQUA + "[" + ChatColor.AQUA + "Crafting Quest" + ChatColor.DARK_AQUA + "]";

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.initPlayerConfig(p);
        }
    }

    public void onDisable() {
        this.reloadConfig();
        this.saveConfig();
    }

    public void initPlayerConfig(Player p) {
        FileConfiguration config = this.getConfig();
        if (config.get("Data." + p.getUniqueId().toString()) == null || !config.getConfigurationSection("Data").contains(p.getUniqueId().toString())) {
            for (Material m : Material.values()) {
                config.set("Data." + p.getUniqueId().toString() + "." + m.name(), (Object)false);
            }
            this.saveConfig();
        }
    }

    @EventHandler
    public void onItemPickup(PlayerPickupItemEvent e) {
        if (!this.getConfig().getBoolean("Data." + e.getPlayer().getUniqueId().toString() + "." + e.getItem().getItemStack().getType().name())) {
            this.getConfig().set("Data." + e.getPlayer().getUniqueId().toString() + "." + e.getItem().getItemStack().getType().name(), (Object)true);
            e.getPlayer().sendMessage(this.prefix + ChatColor.GREEN + "You have now learnt the item " + e.getItem().getItemStack().getType().name() + "!");
            this.saveConfig();
        }
    }

    @EventHandler
    public void onPlayerCraft(CraftItemEvent e) {
        Player p = (Player)e.getWhoClicked();
        boolean iscorrect = true;
        for (int i = 1; i < 10; ++i) {
            if (e.getInventory().getContents()[i].getType() == Material.AIR || this.getConfig().getBoolean("Data." + p.getUniqueId().toString() + "." + e.getInventory().getContents()[i].getType().name())) continue;
            iscorrect = false;
        }
        if (!(iscorrect || p.hasPermission("CraftingQuest.Bypass") && p.isOp())) {
            p.sendMessage(this.prefix + ChatColor.RED + "You have not learnt all of the items required to craft this item! Please craft/find all of the other items!");
            e.setCancelled(true);
        }
        if (iscorrect && !this.getConfig().getBoolean("Data." + p.getUniqueId().toString() + "." + e.getRecipe().getResult().getType().name())) {
            this.getConfig().set("Data." + p.getUniqueId().toString() + "." + e.getRecipe().getResult().getType().name(), (Object)true);
            p.sendMessage(this.prefix + ChatColor.GREEN + "You have now learnt the item " + e.getRecipe().getResult().getType().name() + "!");
            this.saveConfig();
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.initPlayerConfig(e.getPlayer());
    }
}

