/*
 * Decompiled with CFR 0.152.
 */
package lv.bln.NettoHikari.SwiftMOTD.listeners;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import lv.bln.NettoHikari.SwiftMOTD.SwiftMOTD;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.FileConfiguration;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class ServerListener
implements Listener {
    private SwiftMOTD plugin;
    private Random randomizer = new Random();
    private List<String> genericMotds;
    private List<String> dynamicMotds;
    private HashMap<String, String> knownIPs = new HashMap();

    public ServerListener(SwiftMOTD instance) {
        this.plugin = instance;
        this.reloadConfiguration();
    }

    public void reloadConfiguration() {
        FileConfiguration fc = this.plugin.getConfig();
        this.genericMotds = fc.getStringList("motds.generic");
        this.dynamicMotds = fc.getStringList("motds.dynamic");
        int b = 0;
        while (b < this.genericMotds.size()) {
            this.genericMotds.set(b, this.plugin.translateCodes(this.genericMotds.get(b)));
            b = (byte)(b + 1);
        }
        b = 0;
        while (b < this.dynamicMotds.size()) {
            this.dynamicMotds.set(b, this.plugin.translateCodes(this.dynamicMotds.get(b)));
            b = (byte)(b + 1);
        }
    }

    @EventHandler
    public void onPostLogin(PostLoginEvent e) {
        ProxiedPlayer p = e.getPlayer();
        this.knownIPs.put(this.plugin.clearifyIP(p.getAddress().toString()), p.getName());
    }

    @EventHandler
    public void onProxyPing(ProxyPingEvent e) {
        ServerPing sp = e.getResponse();
        String ip = this.plugin.clearifyIP(e.getConnection().getAddress().toString());
        if (!this.knownIPs.containsKey(ip)) {
            sp.setDescription(this.genericMotds.get(this.randomizer.nextInt(this.genericMotds.size())).replaceAll("%newline", "\n").replaceAll("%currentplayers", String.valueOf(sp.getPlayers().getOnline())).replaceAll("%maxplayers", String.valueOf(sp.getPlayers().getMax())));
        } else {
            sp.setDescription(this.dynamicMotds.get(this.randomizer.nextInt(this.dynamicMotds.size())).replaceAll("%player", this.knownIPs.get(ip)).replaceAll("%newline", "\n").replaceAll("%currentplayers", String.valueOf(sp.getPlayers().getOnline())).replaceAll("%maxplayers", String.valueOf(sp.getPlayers().getMax())));
        }
        e.setResponse(sp);
    }
}

