/*
 * Decompiled with CFR 0.152.
 */
package net.craftminecraft.bungee.bungeeyaml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;

public class Metrics {
    private static final int REVISION = 6;
    private static final String BASE_URL = "http://mcstats.org";
    private static final String REPORT_URL = "/report/%s";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final int PING_INTERVAL = 10;
    private final Plugin plugin;
    private final Set<Graph> graphs = Collections.synchronizedSet(new HashSet());
    private final Graph defaultGraph = new Graph("Default");
    private final Properties properties = new Properties();
    private final File configurationFile;
    private String guid;
    private final boolean debug;
    private final Object optOutLock = new Object();
    private Thread thread = null;

    public Metrics(Plugin plugin) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null");
        }
        this.plugin = plugin;
        this.configurationFile = this.getConfigFile();
        if (!this.configurationFile.exists()) {
            File parent;
            if ((this.configurationFile.getPath().contains("/") || this.configurationFile.getPath().contains("\\")) && !(parent = new File(this.configurationFile.getParent())).exists()) {
                parent.mkdir();
            }
            this.configurationFile.createNewFile();
            this.properties.put("opt-out", "false");
            this.properties.put("debug", "false");
            this.properties.store(new FileOutputStream(this.configurationFile), BASE_URL);
        } else {
            this.properties.load(new FileInputStream(this.configurationFile));
        }
        this.guid = ProxyServer.getInstance().getConfigurationAdapter().getString("stats", UUID.randomUUID().toString());
        this.debug = Boolean.parseBoolean(this.properties.getProperty("debug"));
    }

    public Graph createGraph(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Graph name cannot be null");
        }
        Graph graph = new Graph(name);
        this.graphs.add(graph);
        return graph;
    }

    public void addGraph(Graph graph) {
        if (graph == null) {
            throw new IllegalArgumentException("Graph cannot be null");
        }
        this.graphs.add(graph);
    }

    public void addCustomData(Plotter plotter) {
        if (plotter == null) {
            throw new IllegalArgumentException("Plotter cannot be null");
        }
        this.defaultGraph.addPlotter(plotter);
        this.graphs.add(this.defaultGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object object = this.optOutLock;
        synchronized (object) {
            block6: {
                block5: {
                    if (!this.isOptOut()) break block5;
                    return false;
                }
                if (this.thread == null) break block6;
                return true;
            }
            this.thread = new Thread(new Runnable(){
                private boolean firstPost = true;
                private long nextPost = 0L;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (Metrics.this.thread != null) {
                        block11: {
                            if (this.nextPost == 0L || System.currentTimeMillis() > this.nextPost) {
                                try {
                                    Object object = Metrics.this.optOutLock;
                                    synchronized (object) {
                                        if (Metrics.this.isOptOut() && Metrics.this.thread != null) {
                                            Thread temp = Metrics.this.thread;
                                            Metrics.this.thread = null;
                                            for (Graph graph : Metrics.this.graphs) {
                                                graph.onOptOut();
                                            }
                                            temp.interrupt();
                                            return;
                                        }
                                    }
                                    Metrics.this.postPlugin(!this.firstPost);
                                    this.firstPost = false;
                                    this.nextPost = System.currentTimeMillis() + 600000L;
                                }
                                catch (IOException e) {
                                    if (!Metrics.this.debug) break block11;
                                    System.out.println("[Metrics] " + e.getMessage());
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }, "MCStats / Plugin Metrics");
            this.thread.start();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOptOut() {
        Object object = this.optOutLock;
        synchronized (object) {
            try {
                this.properties.load(new FileInputStream(this.configurationFile));
            }
            catch (IOException ex) {
                if (this.debug) {
                    ProxyServer.getInstance().getLogger().log(Level.INFO, "[Metrics] " + ex.getMessage());
                }
                return true;
            }
            this.guid = ProxyServer.getInstance().getConfigurationAdapter().getString("stats", UUID.randomUUID().toString());
            return this.guid.equals("null") || Boolean.parseBoolean(this.properties.getProperty("opt-out"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (this.isOptOut()) {
                this.properties.setProperty("opt-out", "false");
                this.properties.store(new FileOutputStream(this.configurationFile), BASE_URL);
            }
            if (this.thread == null) {
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        Object object = this.optOutLock;
        synchronized (object) {
            if (!this.isOptOut()) {
                this.properties.setProperty("opt-out", "true");
                this.properties.store(new FileOutputStream(this.configurationFile), BASE_URL);
            }
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
    }

    public File getConfigFile() {
        return new File(new File("plugins", "PluginMetrics"), "config.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(boolean isPing) throws IOException {
        PluginDescription description = this.plugin.getDescription();
        String pluginName = description.getName();
        boolean onlineMode = ProxyServer.getInstance().getConfigurationAdapter().getBoolean("online_mode", true);
        String pluginVersion = description.getVersion();
        String serverVersion = String.valueOf(ProxyServer.getInstance().getVersion()) + " (MC: " + ProxyServer.getInstance().getGameVersion() + ")";
        int playersOnline = ProxyServer.getInstance().getPlayers().size();
        StringBuilder data = new StringBuilder();
        data.append(Metrics.encode("guid")).append('=').append(Metrics.encode(this.guid));
        Metrics.encodeDataPair(data, "version", pluginVersion);
        Metrics.encodeDataPair(data, "server", serverVersion);
        Metrics.encodeDataPair(data, "players", Integer.toString(playersOnline));
        Metrics.encodeDataPair(data, "revision", String.valueOf(6));
        String osname = System.getProperty("os.name");
        String osarch = System.getProperty("os.arch");
        String osversion = System.getProperty("os.version");
        String java_version = System.getProperty("java.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        if (osarch.equals("amd64")) {
            osarch = "x86_64";
        }
        Metrics.encodeDataPair(data, "osname", osname);
        Metrics.encodeDataPair(data, "osarch", osarch);
        Metrics.encodeDataPair(data, "osversion", osversion);
        Metrics.encodeDataPair(data, "cores", Integer.toString(coreCount));
        Metrics.encodeDataPair(data, "online-mode", Boolean.toString(onlineMode));
        Metrics.encodeDataPair(data, "java_version", java_version);
        if (isPing) {
            Metrics.encodeDataPair(data, "ping", "true");
        }
        Set<Graph> set = this.graphs;
        synchronized (set) {
            for (Graph graph : this.graphs) {
                for (Plotter plotter : graph.getPlotters()) {
                    String key = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, graph.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String value = Integer.toString(plotter.getValue());
                    Metrics.encodeDataPair(data, key, value);
                }
            }
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, Metrics.encode(pluginName)));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(data.toString());
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        writer.close();
        reader.close();
        if (response == null || response.startsWith("ERR")) {
            throw new IOException(response);
        }
        if (response.contains("OK This is your first update this hour")) {
            Set<Graph> set2 = this.graphs;
            synchronized (set2) {
                for (Graph graph : this.graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void encodeDataPair(StringBuilder buffer, String key, String value) throws UnsupportedEncodingException {
        buffer.append('&').append(Metrics.encode(key)).append('=').append(Metrics.encode(value));
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static class Graph {
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.name.equals(this.name);
        }

        protected void onOptOut() {
        }
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public abstract int getValue();

        public String getColumnName() {
            return this.name;
        }

        public void reset() {
        }

        public int hashCode() {
            return this.getColumnName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.name.equals(this.name) && plotter.getValue() == this.getValue();
        }
    }
}

