/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.Utilities.PageInventorys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.Tom.Gridiron.Utilities.ItemBuilder;
import me.Tom.Gridiron.Utilities.PageInventorys.ControlButton;
import me.Tom.Gridiron.Utilities.PageInventorys.ItemButton;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class PageGUI
implements InventoryHolder {
    private String name;
    private String title;
    private List<ItemButton> itemButtons = new ArrayList<ItemButton>();
    private Map<Integer, ControlButton> controlButtons = new HashMap<Integer, ControlButton>();
    private List<Inventory> pages;
    private List<List<ItemButton>> pageButtons;
    private Map<UUID, Integer> users = new HashMap<UUID, Integer>();

    public String getName() {
        return this.name;
    }

    private String colorise(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public PageGUI(String title) {
        this.title = title;
        this.name = ChatColor.stripColor((String)title);
        this.pages = new ArrayList<Inventory>();
        this.pageButtons = new ArrayList<List<ItemButton>>();
    }

    public void addItemButtons(List<ItemButton> itemButtons) {
        this.itemButtons = itemButtons;
    }

    public List<ItemButton> getItemButtons(Player p) {
        return this.pageButtons.get(this.users.get(p.getUniqueId()));
    }

    public ControlButton getControlButton(int slot) {
        return this.controlButtons.get(slot);
    }

    private Inventory blankPage() {
        Inventory inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (String)this.colorise(this.title));
        ControlButton prevButton = new ControlButton(new ItemBuilder(Material.SKULL_ITEM).durability(3).name("&bPrevious Page").skull("MHF_ArrowUp").getItem());
        prevButton.setListener(e -> this.decreasePage((Player)e.getWhoClicked()));
        this.controlButtons.put(45, prevButton);
        ControlButton nextButton = new ControlButton(new ItemBuilder(Material.SKULL_ITEM).durability(3).name("&bNext Page").skull("MHF_ArrowDown").getItem());
        nextButton.setListener(e -> this.increasePage((Player)e.getWhoClicked()));
        this.controlButtons.put(53, nextButton);
        for (int button : this.controlButtons.keySet()) {
            inv.setItem(button, this.controlButtons.get(button).getButton());
        }
        return inv;
    }

    private void increasePage(Player p) {
        UUID uuid = p.getUniqueId();
        if (this.users.get(uuid) != this.pages.size() - 1) {
            this.users.put(uuid, this.users.get(uuid) + 1);
            p.openInventory(this.pages.get(this.users.get(uuid)));
        }
    }

    private void decreasePage(Player p) {
        UUID uuid = p.getUniqueId();
        if (this.users.get(uuid) == 0) {
            p.closeInventory();
        } else {
            this.users.put(uuid, this.users.get(uuid) - 1);
            p.openInventory(this.pages.get(this.users.get(uuid)));
        }
    }

    public void firstPage(Player p) {
        this.users.put(p.getUniqueId(), 0);
        p.openInventory(this.pages.get(0));
    }

    public PageGUI build() {
        Inventory page = this.blankPage();
        ArrayList<ItemButton> buttons = new ArrayList<ItemButton>();
        for (int i = 0; i < this.itemButtons.size(); ++i) {
            if (page.firstEmpty() == 46) {
                this.pages.add(page);
                this.pageButtons.add(buttons);
                page = this.blankPage();
                buttons = new ArrayList();
                buttons.add(this.itemButtons.get(i));
                page.addItem(new ItemStack[]{this.itemButtons.get(i).getButton()});
                continue;
            }
            buttons.add(this.itemButtons.get(i));
            page.addItem(new ItemStack[]{this.itemButtons.get(i).getButton()});
        }
        this.pages.add(page);
        this.pageButtons.add(buttons);
        return this;
    }

    public Inventory getInventory() {
        return this.pages.get(0);
    }
}

