/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.Utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.material.MaterialData;

public class ItemBuilder {
    private ItemStack item;
    private ItemMeta itemMeta;

    private String colorise(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public ItemBuilder(Material mat) {
        this.item = new ItemStack(mat);
        this.itemMeta = this.item.getItemMeta();
    }

    public ItemBuilder type(Material material) {
        this.item.setType(material);
        return this;
    }

    public ItemBuilder amount(int amount) {
        this.item.setAmount(amount);
        return this;
    }

    public ItemBuilder durability(int durability) {
        this.item.setDurability((short)durability);
        return this;
    }

    public ItemBuilder data(int data) {
        this.item.setData(new MaterialData(this.item.getType(), (byte)data));
        return this;
    }

    public ItemBuilder name(String name) {
        this.itemMeta.setDisplayName(this.colorise(name));
        this.applyMeta();
        return this;
    }

    public ItemBuilder lore(List<String> lore) {
        ArrayList itemlore = new ArrayList();
        lore.forEach(s -> itemlore.add(this.colorise((String)s)));
        this.itemMeta.setLore(itemlore);
        this.applyMeta();
        return this;
    }

    public ItemBuilder lores(String[] lore) {
        ArrayList<String> itemlore = new ArrayList<String>();
        for (String s : lore) {
            itemlore.add(this.colorise(s));
        }
        this.itemMeta.setLore(itemlore);
        this.applyMeta();
        return this;
    }

    public ItemBuilder enchant(Enchantment enc, int level) {
        this.item.addUnsafeEnchantment(enc, level);
        return this;
    }

    public ItemBuilder enchants(Map<Enchantment, Integer> enchants) {
        this.item.addUnsafeEnchantments(enchants);
        return this;
    }

    public ItemBuilder flag(ItemFlag flag) {
        this.itemMeta.addItemFlags(new ItemFlag[]{flag});
        this.applyMeta();
        return this;
    }

    public ItemBuilder flags(ItemFlag[] flags) {
        this.itemMeta.addItemFlags(flags);
        this.applyMeta();
        return this;
    }

    public ItemBuilder color(Color color) {
        if (this.item.getType() == Material.LEATHER_HELMET || this.item.getType() == Material.LEATHER_CHESTPLATE || this.item.getType() == Material.LEATHER_LEGGINGS || this.item.getType() == Material.LEATHER_BOOTS) {
            LeatherArmorMeta meta = (LeatherArmorMeta)this.itemMeta;
            meta.setColor(color);
            this.item.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    public ItemBuilder skull(String owner) {
        if (this.item.getType() == Material.SKULL_ITEM && this.item.getDurability() == 3) {
            SkullMeta meta = (SkullMeta)this.itemMeta;
            meta.setOwner(owner);
            this.item.setItemMeta((ItemMeta)meta);
        }
        return this;
    }

    public ItemBuilder glow(boolean glow) {
        this.flag(ItemFlag.HIDE_ENCHANTS);
        this.enchant(Enchantment.LUCK, 1);
        return this;
    }

    public ItemBuilder unbreakable(boolean unbreakable) {
        this.itemMeta.spigot().setUnbreakable(unbreakable);
        this.applyMeta();
        return this;
    }

    private void applyMeta() {
        this.item.setItemMeta(this.itemMeta);
    }

    public ItemStack getItem() {
        return this.item;
    }
}

