/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.Utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.Tom.Gridiron.PluginCore;
import me.Tom.Gridiron.Utilities.PageInventorys.ItemButton;
import me.Tom.Gridiron.Utilities.PageInventorys.PageGUI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class InventoryBuilder {
    private PluginCore pl = (PluginCore)PluginCore.getPlugin(PluginCore.class);
    private InventoryHolder holder;
    private InventoryType type;
    private int size;
    private String title;
    private boolean pageable = false;
    private ItemStack filler;
    private Map<Integer, ItemStack> slotitems = new HashMap<Integer, ItemStack>();
    private List<ItemStack> items = new ArrayList<ItemStack>();
    private List<ItemButton> buttons = new ArrayList<ItemButton>();

    private String colorise(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public InventoryBuilder(String title) {
        this.title = title;
    }

    public InventoryBuilder size(int size) {
        this.size = size;
        return this;
    }

    public InventoryBuilder holder(InventoryHolder holder) {
        this.holder = holder;
        return this;
    }

    public InventoryBuilder type(InventoryType type) {
        this.type = type;
        return this;
    }

    public InventoryBuilder pageable(boolean pageable) {
        this.pageable = pageable;
        return this;
    }

    public InventoryBuilder filler(ItemStack filler) {
        this.filler = filler;
        return this;
    }

    public InventoryBuilder item(int slot, ItemStack item) {
        this.slotitems.put(slot, item);
        return this;
    }

    public InventoryBuilder buttons(List<ItemButton> buttons) {
        this.buttons = buttons;
        return this;
    }

    public InventoryBuilder items(List<ItemStack> items) {
        this.items = items;
        return this;
    }

    public Inventory build() {
        if (this.pageable) {
            PageGUI pageGUI = new PageGUI(this.colorise(this.title));
            pageGUI.addItemButtons(this.buttons);
            pageGUI.build();
            this.pl.getAllPageGUIs().add(pageGUI);
            return null;
        }
        Inventory inv = this.type != null ? Bukkit.createInventory((InventoryHolder)this.holder, (InventoryType)this.type, (String)this.colorise(this.title)) : Bukkit.createInventory((InventoryHolder)this.holder, (int)this.size, (String)this.colorise(this.title));
        for (int i : this.slotitems.keySet()) {
            inv.setItem(i, this.slotitems.get(i));
        }
        if (this.filler != null) {
            for (int i = 0; i < inv.getSize(); ++i) {
                if (inv.getItem(i) != null) continue;
                inv.setItem(i, this.filler);
            }
        }
        return inv;
    }
}

