/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.Tom.Gridiron.CommandManager.CommandManager;
import me.Tom.Gridiron.ConfigManager.ConfigManager;
import me.Tom.Gridiron.EventManager.EventManager;
import me.Tom.Gridiron.GameManager.GameManager;
import me.Tom.Gridiron.GameManager.GameScoreboard;
import me.Tom.Gridiron.GameManager.PlayerManager;
import me.Tom.Gridiron.GameManager.Teams;
import me.Tom.Gridiron.Inventorys;
import me.Tom.Gridiron.Utilities.MessageUtils;
import me.Tom.Gridiron.Utilities.PageInventorys.PageGUI;
import org.apache.commons.io.IOUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PluginCore
extends JavaPlugin {
    private List<PageGUI> allPageGUIs = new ArrayList<PageGUI>();
    private Map<Player, PlayerManager> playerManagerMap = new HashMap<Player, PlayerManager>();
    private Map<Player, GameScoreboard> playerGameScoreboardMap = new HashMap<Player, GameScoreboard>();
    private List<Teams> allTeams = new ArrayList<Teams>();
    private ConfigManager configManager;
    private CommandManager commandManager;
    private EventManager eventManager;
    private GameManager gameManager;
    private Inventorys inventorys;

    public List<PageGUI> getAllPageGUIs() {
        return this.allPageGUIs;
    }

    public PageGUI getPageGUI(String name) {
        for (PageGUI pageGUI : this.allPageGUIs) {
            if (!pageGUI.getName().equalsIgnoreCase(name)) continue;
            return pageGUI;
        }
        return null;
    }

    public Map<Player, PlayerManager> getPlayerManagerMap() {
        return this.playerManagerMap;
    }

    public Map<Player, GameScoreboard> getPlayerGameScoreboardMap() {
        return this.playerGameScoreboardMap;
    }

    public List<Teams> getAllTeams() {
        return this.allTeams;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public Inventorys getInventorys() {
        return this.inventorys;
    }

    public void onEnable() {
        MessageUtils.consoleMessage("&5=-=-=-=-=-=-=-= " + this.getDescription().getName() + " =-=-=-=-=-=-=-=");
        MessageUtils.consoleMessage("| &aVersion: " + this.getDescription().getVersion());
        MessageUtils.consoleMessage("| &aAuthor: " + this.getDescription().getAuthors());
        this.configManager = new ConfigManager(this);
        this.configManager.setup();
        this.checkDepends();
        this.inventorys = new Inventorys(this);
        this.inventorys.setup();
        this.gameManager = new GameManager(this);
        this.gameManager.setupGame();
        this.commandManager = new CommandManager(this);
        this.commandManager.setup();
        this.eventManager = new EventManager(this);
        this.eventManager.setup();
        this.versionChecker();
        this.verifyMethods();
    }

    private void checkDepends() {
        if (Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            MessageUtils.consoleMessage("| &aHolographicDisplays Features: Enabled");
        } else {
            MessageUtils.consoleMessage("| &cHolographicDisplays Features: Disabled");
        }
    }

    private void verifyMethods() {
        if (!Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.verifyError("&7Gridiron cannot run without &cHolographicDisplays!");
            return;
        }
        MessageUtils.consoleMessage("&5=-=-=-=-=-=-= A WW2 Remake =-=-=-=-=-=-=");
    }

    public void onDisable() {
        this.gameManager.gameStop();
    }

    private void verifyError(String message) {
        MessageUtils.consoleMessage("");
        MessageUtils.consoleMessage(message);
        MessageUtils.consoleMessage("");
        MessageUtils.consoleMessage("&5=-=-=-=-=-=-= A WW2 Remake =-=-=-=-=-=-=");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    private void versionChecker() {
        try {
            String spigotversion = IOUtils.toString((URL)new URL("https://api.spigotmc.org/legacy/update.php?resource=54905"));
            String pluginversion = this.getDescription().getVersion();
            Double spigotver = Double.parseDouble(spigotversion);
            Double pluginver = Double.parseDouble(pluginversion);
            if (spigotver > pluginver) {
                MessageUtils.consoleMessage("");
                MessageUtils.consoleMessage(MessageUtils.format("&cYou are not using the most up to date version of " + this.getDescription().getName() + "!"));
                MessageUtils.consoleMessage(MessageUtils.format("&chttps://www.spigotmc.org/resources/gridiron-beta.54905/"));
                MessageUtils.consoleMessage("");
            } else {
                MessageUtils.consoleMessage("");
                MessageUtils.consoleMessage(MessageUtils.format("&aYou are using the most up to date version of " + this.getDescription().getName() + "!"));
                MessageUtils.consoleMessage("");
            }
        }
        catch (IOException e) {
            MessageUtils.consoleMessage("");
            MessageUtils.consoleMessage(MessageUtils.format("&cCould not make connection to SpigotMC.org to check for updates!"));
            MessageUtils.consoleMessage("");
        }
    }
}

