/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.GameManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.Tom.Gridiron.GameManager.CustomScoreboard;
import me.Tom.Gridiron.PluginCore;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class GameScoreboard
implements CustomScoreboard {
    private PluginCore core;
    private final Objective objective;
    private final Scoreboard board;
    private final Map<Integer, String> entries = new HashMap<Integer, String>();
    private final List<Integer> shown = new ArrayList<Integer>();
    private int index = 0;
    private int times = 0;

    public GameScoreboard(PluginCore pl) {
        this.core = pl;
        this.board = Bukkit.getScoreboardManager().getNewScoreboard();
        this.objective = this.board.registerNewObjective("test", "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    @Override
    public void set(Object line, int score) {
        String stringLine = ChatColor.translateAlternateColorCodes((char)'&', (String)line.toString());
        Team team = this.board.getTeam(String.valueOf(score));
        if (team == null) {
            team = this.board.registerNewTeam(String.valueOf(score));
            String entry = this.getNextEntry();
            team.addEntry(entry);
            this.entries.put(score, entry);
        }
        if (!this.shown.contains(score)) {
            this.objective.getScore(this.entries.get(score)).setScore(score);
            this.shown.add(score);
        }
        String prefix = stringLine.substring(0, Math.min(stringLine.length(), 16));
        team.setPrefix(prefix);
        String lastColors = ChatColor.getLastColors((String)prefix);
        if (stringLine.length() > 16) {
            team.setSuffix(lastColors + stringLine.substring(16, Math.min(stringLine.length(), 32 - lastColors.length())));
        }
        if (stringLine.length() > 32) {
            System.err.println("[CustomScoreboard] A " + stringLine.length() + " character line was truncated to 32 characters. Line: " + score + " Text: '" + stringLine + "'");
        }
    }

    public void setLines(List<String> lines, String name, String team, int points, int goal, int timer) {
        for (int i = 0; i < lines.size(); ++i) {
            this.set(lines.get(i).replace("%PlayersName%", name).replace("%PlayersTeam%", team).replace("%PlayersTeamsPoints%", String.valueOf(points)).replace("%AllyPoints%", String.valueOf(this.core.getAllTeams().get(0).getPoints())).replace("%AxisPoints%", String.valueOf(this.core.getAllTeams().get(1).getPoints())).replace("%GameTimer%", String.valueOf(timer)).replace("%GoalSwitch%", String.valueOf(goal)), lines.size() - 1 - i);
        }
    }

    @Override
    public void remove(int score) {
        if (this.entries.containsKey(score)) {
            this.board.resetScores(this.entries.get(score));
        }
        if (this.shown.contains(score)) {
            this.shown.remove((Object)score);
        }
    }

    @Override
    public void setTitle(Object title) {
        this.objective.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)title.toString()));
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.board;
    }

    private String getNextEntry() {
        ChatColor color = ChatColor.values()[this.index++];
        if (this.index >= ChatColor.values().length) {
            this.index = 0;
            ++this.times;
        }
        return color.toString() + ChatColor.values()[this.times] + ChatColor.RESET;
    }
}

