/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.GameManager;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.gmail.filoghost.holographicdisplays.api.line.ItemLine;
import com.gmail.filoghost.holographicdisplays.api.line.TextLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.Tom.Gridiron.ConfigManager.ConfigManager;
import me.Tom.Gridiron.ConfigManager.Configs.Messages;
import me.Tom.Gridiron.GameManager.GameScoreboard;
import me.Tom.Gridiron.GameManager.GameState;
import me.Tom.Gridiron.GameManager.GameTimer;
import me.Tom.Gridiron.GameManager.LobbyCountdown;
import me.Tom.Gridiron.GameManager.PlayerManager;
import me.Tom.Gridiron.GameManager.Teams;
import me.Tom.Gridiron.PluginCore;
import me.Tom.Gridiron.Utilities.FileUtils;
import me.Tom.Gridiron.Utilities.ItemBuilder;
import me.Tom.Gridiron.Utilities.MessageUtils;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.DisplaySlot;

public class GameManager {
    private PluginCore core;
    private ConfigManager configs;
    private Map<Player, PlayerManager> playerManagerMap;
    private List<Teams> allTeams;
    private Map<Player, GameScoreboard> playerGameScoreboardMap;
    private List<Player> onlinePlayers = new ArrayList<Player>();
    private int playersNeeded;
    private int lobbyCountdown;
    private int goalSwitchCountdown;
    private int gameTimer;
    private Location lobbySpawn;
    private Location allySpawn;
    private Location axisSpawn;
    private List<Location> goalLocations = new ArrayList<Location>();
    private Location currentGoal;
    private List<Location> ballLocations = new ArrayList<Location>();
    private Location currentBall;
    private List<ItemStack> allyGear = new ArrayList<ItemStack>();
    private List<ItemStack> axisGear = new ArrayList<ItemStack>();
    private GameScoreboard board;
    private List<String> scoreboardLines;

    public GameManager(PluginCore pl) {
        this.core = pl;
        this.configs = this.core.getConfigManager();
        this.playerManagerMap = this.core.getPlayerManagerMap();
        this.allTeams = this.core.getAllTeams();
        this.playerGameScoreboardMap = this.core.getPlayerGameScoreboardMap();
    }

    public int getPlayersNeeded() {
        return this.playersNeeded;
    }

    public void setPlayersNeeded(int playersNeeded) {
        this.playersNeeded = playersNeeded;
    }

    public int getLobbyCountdown() {
        return this.lobbyCountdown;
    }

    public void setLobbyCountdown(int lobbyCountdown) {
        this.lobbyCountdown = lobbyCountdown;
    }

    public int getGoalSwitchCountdown() {
        return this.goalSwitchCountdown;
    }

    public void setGoalSwitchCountdown(int goalSwitchCountdown) {
        this.goalSwitchCountdown = goalSwitchCountdown;
    }

    public int getGameTimer() {
        return this.gameTimer;
    }

    public void setGameTimer(int gameTimer) {
        this.gameTimer = gameTimer;
    }

    public Location getLobbySpawn() {
        return this.lobbySpawn;
    }

    public void setLobbySpawn(Location lobbySpawn) {
        this.lobbySpawn = lobbySpawn;
    }

    public List<Location> getGoalLocations() {
        return this.goalLocations;
    }

    public Location getCurrentGoal() {
        return this.currentGoal;
    }

    public List<Location> getBallLocations() {
        return this.ballLocations;
    }

    public List<String> getScoreboardLines() {
        return this.scoreboardLines;
    }

    public void setupGame() {
        this.playersNeeded = this.configs.getGridironCfg().getInt("GameManager.PlayersNeeded");
        this.lobbyCountdown = this.configs.getGridironCfg().getInt("GameManager.LobbyCountdownTime");
        this.goalSwitchCountdown = this.configs.getGridironCfg().getInt("GameManager.GoalSwitchTime");
        this.gameTimer = this.configs.getGridironCfg().getInt("GameManager.GameTime");
        String[] lobbyLoc = this.configs.getGridironCfg().getString("GameManager.LobbySpawn").split(", ");
        this.lobbySpawn = FileUtils.deserialiseLocation(lobbyLoc);
        this.configs.getGridironCfg().getStringList("GameManager.GoalLocations").forEach(s -> {
            String[] goalLoc = s.split(", ");
            this.goalLocations.add(FileUtils.deserialiseLocation(goalLoc));
        });
        this.configs.getGridironCfg().getStringList("GameManager.BallLocations").forEach(s -> {
            String[] ballLoc = s.split(", ");
            this.ballLocations.add(FileUtils.deserialiseLocation(ballLoc));
        });
        String[] allyLoc = this.configs.getGridironCfg().getString("Teams.Ally.Spawn").split(", ");
        this.allySpawn = FileUtils.deserialiseLocation(allyLoc);
        this.configs.getGridironCfg().getStringList("Teams.Ally.Gear.Armour").forEach(s -> {
            String[] armour = s.replace("[", "").replace("]", "").split(", ");
            String[] lore = armour[3].split(";");
            this.allyGear.add(new ItemBuilder(Material.valueOf((String)armour[0])).name(armour[1]).color(FileUtils.getColourfromString(armour[2])).lores(lore).flag(ItemFlag.HIDE_ATTRIBUTES).getItem());
        });
        String[] allySword = this.configs.getGridironCfg().getString("Teams.Ally.Gear.Sword").split(", ");
        String[] allySwordLore = allySword[3].split(";");
        this.allyGear.add(new ItemBuilder(Material.valueOf((String)allySword[0])).name(allySword[1]).durability(Integer.parseInt(allySword[2])).lores(allySwordLore).flags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE}).unbreakable(true).enchant(Enchantment.DAMAGE_ALL, 5).glow(true).getItem());
        this.allTeams.add(new Teams("Ally", 0, this.allySpawn, this.allyGear));
        String[] axisLoc = this.configs.getGridironCfg().getString("Teams.Axis.Spawn").split(", ");
        this.axisSpawn = FileUtils.deserialiseLocation(axisLoc);
        this.configs.getGridironCfg().getStringList("Teams.Axis.Gear.Armour").forEach(s -> {
            String[] armour = s.replace("[", "").replace("]", "").split(", ");
            String[] lore = armour[3].split(";");
            this.axisGear.add(new ItemBuilder(Material.valueOf((String)armour[0])).name(armour[1]).color(FileUtils.getColourfromString(armour[2])).lores(lore).flag(ItemFlag.HIDE_ATTRIBUTES).getItem());
        });
        String[] axisSword = this.configs.getGridironCfg().getString("Teams.Axis.Gear.Sword").split(", ");
        String[] axisSwordLore = axisSword[3].split(";");
        this.axisGear.add(new ItemBuilder(Material.valueOf((String)axisSword[0])).name(axisSword[1]).durability(Integer.parseInt(axisSword[2])).lores(axisSwordLore).flags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE}).unbreakable(true).enchant(Enchantment.DAMAGE_ALL, 5).glow(true).getItem());
        this.allTeams.add(new Teams("Axis", 0, this.axisSpawn, this.axisGear));
        this.scoreboardLines = this.configs.getGridironCfg().getStringList("Scoreboard.Lines");
        Bukkit.getOnlinePlayers().forEach(online -> {
            online.setGlowing(false);
            this.playerManagerMap.put((Player)online, new PlayerManager((Player)online, null, false));
        });
        GameState.setCurrentState(GameState.IN_LOBBY);
        this.lobbyWait();
    }

    public void lobbyWait() {
        int online = Bukkit.getOnlinePlayers().size();
        if (online > 0) {
            MessageUtils.broadcastMessage("");
            MessageUtils.broadcastMessage(Messages.PLAYERSNEEDED.replace("%Online%", String.valueOf(online)).replace("%PlayersNeeded%", String.valueOf(this.playersNeeded)));
            MessageUtils.broadcastMessage("");
            this.playerCheck(online);
        }
    }

    public void gameStart() {
        this.setRandomGoal();
        this.setRandomBall();
        Bukkit.getOnlinePlayers().forEach(p -> this.onlinePlayers.add((Player)p));
        Collections.shuffle(this.onlinePlayers, new Random());
        for (int online = 0; online < this.onlinePlayers.size(); ++online) {
            Player p2 = this.onlinePlayers.get(online);
            if (online % 2 == 0) {
                this.playerManagerMap.get(p2).setTeam(this.allTeams.get(0));
                continue;
            }
            this.playerManagerMap.get(p2).setTeam(this.allTeams.get(1));
        }
        this.onlinePlayers.forEach(p -> {
            p.resetTitle();
            p.setGameMode(GameMode.ADVENTURE);
            p.getInventory().clear();
            p.setFoodLevel(20);
            p.setHealth(20.0);
            Teams team = this.playerManagerMap.get(p).getTeam();
            p.getInventory().setHelmet(team.getGear().get(0));
            p.getInventory().setChestplate(team.getGear().get(1));
            p.getInventory().setLeggings(team.getGear().get(2));
            p.getInventory().setBoots(team.getGear().get(3));
            p.getInventory().setItem(0, team.getGear().get(4));
            p.teleport(team.getSpawn());
            this.board = new GameScoreboard(this.core);
            this.board.setTitle(MessageUtils.format(this.configs.getGridironCfg().getString("Scoreboard.Title")));
            this.board.setLines(this.scoreboardLines, p.getName(), team.getName(), team.getPoints(), this.goalSwitchCountdown, this.gameTimer);
            this.playerGameScoreboardMap.put((Player)p, this.board);
            p.setScoreboard(this.board.getScoreboard());
        });
        new GameTimer(this.core).runTaskTimer((Plugin)this.core, 0L, 20L);
        GameState.setCurrentState(GameState.IN_PROGRESS);
    }

    public void gameStop() {
        if (GameState.getCurrentState() != null) {
            if (GameState.isState(GameState.IN_PROGRESS)) {
                GameState.setCurrentState(GameState.POST_GAME);
            }
            this.onlinePlayers.clear();
            this.playerManagerMap.clear();
            this.playerGameScoreboardMap.clear();
            this.ballLocations.clear();
            this.goalLocations.clear();
            this.allyGear.clear();
            this.axisGear.clear();
            String[] loc = this.configs.getGridironCfg().getString("GameManager.LobbySpawn").split(", ");
            Bukkit.getOnlinePlayers().forEach(p -> {
                p.getScoreboard().clearSlot(DisplaySlot.SIDEBAR);
                p.setGlowing(false);
                p.resetTitle();
                p.getInventory().clear();
                p.teleport(FileUtils.deserialiseLocation(loc));
                if (GameState.isState(GameState.POST_GAME)) {
                    p.kickPlayer(MessageUtils.format("&5&lGame over!\n&7Ally: &d" + this.allTeams.get(0).getPoints() + "\n&7Axis: &d" + this.allTeams.get(1).getPoints()));
                }
            });
            this.allTeams.clear();
            HologramsAPI.getHolograms((Plugin)this.core).forEach(holo -> holo.delete());
        }
        Bukkit.getScheduler().cancelAllTasks();
        this.setupGame();
    }

    private void playerCheck(int online) {
        if (online >= this.playersNeeded && GameState.isState(GameState.IN_LOBBY)) {
            new LobbyCountdown(this.core).runTaskTimer((Plugin)this.core, 0L, 20L);
            GameState.setCurrentState(GameState.LOADING);
        }
    }

    public void setRandomGoal() {
        this.currentGoal = this.goalLocations.get(new Random().nextInt(this.goalLocations.size()));
    }

    public void setRandomBall() {
        HologramsAPI.getHolograms((Plugin)this.core).forEach(hologram -> {
            if (hologram.getLine(0) instanceof TextLine && ((TextLine)hologram.getLine(0)).getText().equals(MessageUtils.format(this.configs.getGridironCfg().getString("Ball.Name")))) {
                hologram.delete();
            }
        });
        this.currentBall = this.ballLocations.get(new Random().nextInt(this.ballLocations.size()));
        this.spawnBall(this.currentBall);
    }

    public void spawnBall(Location loc) {
        Hologram holo = HologramsAPI.createHologram((Plugin)this.core, (Location)loc);
        holo.appendTextLine(MessageUtils.format(this.configs.getGridironCfg().getString("Ball.Name")));
        ItemLine item = holo.appendItemLine(new ItemBuilder(Material.valueOf((String)this.configs.getGridironCfg().getString("Ball.Item"))).getItem());
        item.setTouchHandler(p -> {
            if (GameState.isState(GameState.IN_PROGRESS)) {
                holo.delete();
                ArrayList<String> lore = new ArrayList<String>();
                this.configs.getGridironCfg().getStringList("Ball.Lore").forEach(s -> lore.add(MessageUtils.format(s)));
                p.getInventory().setItem(8, new ItemBuilder(Material.valueOf((String)this.configs.getGridironCfg().getString("Ball.Item"))).name(this.configs.getGridironCfg().getString("Ball.Name")).lore(lore).glow(true).getItem());
                this.playerManagerMap.get(p).setHasBall(true);
                p.setGlowing(true);
                MessageUtils.broadcastMessage(Messages.BALLPICKEDUP.replace("%PlayerName%", p.getName()));
            }
        });
    }
}

