/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.CommandManager.Commands;

import me.Tom.Gridiron.CommandManager.SubCommands;
import me.Tom.Gridiron.ConfigManager.ConfigManager;
import me.Tom.Gridiron.ConfigManager.Configs.Messages;
import me.Tom.Gridiron.GameManager.GameState;
import me.Tom.Gridiron.PluginCore;
import me.Tom.Gridiron.Utilities.MessageUtils;
import org.bukkit.command.CommandSender;

public class Reload
extends SubCommands {
    private PluginCore core;
    private ConfigManager configManager;

    public Reload(PluginCore pl) {
        this.core = pl;
        this.configManager = this.core.getConfigManager();
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("gridiron.admin")) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.NOPERMS));
            return;
        }
        if (args.length == 1) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGFORMAT));
            return;
        }
        if (GameState.isState(GameState.IN_PROGRESS)) {
            sender.sendMessage(MessageUtils.formattedMessage("&7Config reloading cannot take place while a game is in progress"));
            return;
        }
        if (args[1].equalsIgnoreCase("game")) {
            this.configManager.getGridiron().reloadCfg();
            if (this.configManager.getGridiron().getCfg().getKeys(false).size() == 0) {
                this.configManager.getGridiron().getFile().delete();
                this.configManager.getGridiron().createCfg();
                sender.sendMessage(MessageUtils.formattedMessage("&cThere was an error in the &dGridiron &cconfig so it has been reset"));
            } else if (this.configManager.getGridiron().getCfg().getKeys(false).size() > 0) {
                this.core.getGameManager().setupGame();
                sender.sendMessage(MessageUtils.formattedMessage("&7The &dGridiron &7config has no errors and successfully reloaded"));
            }
        } else if (args[1].equalsIgnoreCase("messages")) {
            this.configManager.getMessages().reloadCfg();
            if (this.configManager.getMessages().getCfg().getKeys(false).size() == 0) {
                this.configManager.getMessages().getFile().delete();
                this.configManager.getMessages().createCfg();
                sender.sendMessage(MessageUtils.formattedMessage("&cThere was an error in the &dMessages &cconfig so it has been reset"));
            } else if (this.configManager.getMessages().getCfg().getKeys(false).size() > 0) {
                this.configManager.getMessages().setup();
                sender.sendMessage(MessageUtils.formattedMessage("&7The &dMessages &7config has no errors and successfully reloaded"));
            }
        } else {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGFORMAT));
        }
    }

    @Override
    public String name() {
        return this.core.getCommandManager().reload;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public String[] aliases() {
        return new String[0];
    }
}

