/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.CommandManager.Commands;

import java.util.ArrayList;
import me.Tom.Gridiron.CommandManager.SubCommands;
import me.Tom.Gridiron.ConfigManager.ConfigManager;
import me.Tom.Gridiron.ConfigManager.Configs.Messages;
import me.Tom.Gridiron.GameManager.GameManager;
import me.Tom.Gridiron.GameManager.GameState;
import me.Tom.Gridiron.PluginCore;
import me.Tom.Gridiron.Utilities.FileUtils;
import me.Tom.Gridiron.Utilities.MessageUtils;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LocationEdit
extends SubCommands {
    private PluginCore core;
    private ConfigManager configManager;
    private GameManager gameManager;

    public LocationEdit(PluginCore pl) {
        this.core = pl;
        this.configManager = this.core.getConfigManager();
        this.gameManager = this.core.getGameManager();
    }

    private void saveLocations(Player p) {
        p.sendMessage("");
        p.spigot().sendMessage(new ComponentBuilder("Update game locations").color(ChatColor.LIGHT_PURPLE).bold(true).event(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/gridiron location save")).create());
        p.sendMessage("");
    }

    @Override
    public void onCommand(CommandSender sender, String[] args) {
        if (!sender.hasPermission("gridiron.admin")) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.NOPERMS));
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGUSER));
            return;
        }
        if (args.length == 1) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGFORMAT));
            return;
        }
        if (!GameState.isState(GameState.IN_LOBBY)) {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.GAMEINPROGRESS));
            return;
        }
        Player p = (Player)sender;
        Location pLocation = p.getLocation();
        if (args[1].equalsIgnoreCase("set")) {
            if (args[2].equalsIgnoreCase("lobby")) {
                this.gameManager.setLobbySpawn(pLocation);
                p.sendMessage(MessageUtils.formattedMessage(Messages.LOBBYSET));
                this.saveLocations(p);
            } else if (args[2].equalsIgnoreCase("goal")) {
                this.gameManager.getGoalLocations().add(pLocation);
                p.sendMessage(MessageUtils.formattedMessage(Messages.GOALSET));
                this.saveLocations(p);
            } else if (args[2].equalsIgnoreCase("ball")) {
                this.gameManager.getBallLocations().add(pLocation);
                p.sendMessage(MessageUtils.formattedMessage(Messages.BALLSET));
                this.saveLocations(p);
            } else {
                sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGFORMAT));
            }
        } else if (args[1].equalsIgnoreCase("save")) {
            this.configManager.getGridironCfg().set("GameManager.LobbySpawn", (Object)FileUtils.seraliseLocation(this.gameManager.getLobbySpawn()));
            ArrayList goalocs = new ArrayList();
            this.gameManager.getGoalLocations().forEach(loc -> goalocs.add(FileUtils.seraliseLocation(loc)));
            this.configManager.getGridironCfg().set("GameManager.GoalLocations", goalocs);
            ArrayList balllocs = new ArrayList();
            this.gameManager.getBallLocations().forEach(loc -> balllocs.add(FileUtils.seraliseLocation(loc)));
            this.configManager.getGridironCfg().set("GameManager.BallLocations", balllocs);
            this.configManager.getGridiron().saveCfg();
            sender.sendMessage(MessageUtils.formattedMessage(Messages.LOCATIONSSAVE));
        } else {
            sender.sendMessage(MessageUtils.formattedMessage(Messages.WRONGFORMAT));
        }
    }

    @Override
    public String name() {
        return this.core.getCommandManager().loc;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public String[] aliases() {
        return new String[0];
    }
}

