/*
 * Decompiled with CFR 0.152.
 */
package me.Tom.Gridiron.CommandManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.Tom.Gridiron.CommandManager.Commands.AdminGUI;
import me.Tom.Gridiron.CommandManager.Commands.Help;
import me.Tom.Gridiron.CommandManager.Commands.LocationEdit;
import me.Tom.Gridiron.CommandManager.Commands.Reload;
import me.Tom.Gridiron.CommandManager.SubCommands;
import me.Tom.Gridiron.ConfigManager.Configs.Messages;
import me.Tom.Gridiron.PluginCore;
import me.Tom.Gridiron.Utilities.MessageUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class CommandManager
implements CommandExecutor {
    private PluginCore core;
    private List<SubCommands> commands = new ArrayList<SubCommands>();
    private String main = "gridiron";
    public String help = "help";
    public String admin = "admin";
    public String loc = "location";
    public String reload = "reload";

    public CommandManager(PluginCore pl) {
        this.core = pl;
    }

    public void setup() {
        this.core.getCommand(this.main).setExecutor((CommandExecutor)this);
        this.commands.add(new Help(this.core));
        this.commands.add(new AdminGUI(this.core));
        this.commands.add(new LocationEdit(this.core));
        this.commands.add(new Reload(this.core));
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (command.getName().equalsIgnoreCase(this.main)) {
            if (args.length == 0) {
                sender.sendMessage(MessageUtils.formattedMessage(Messages.NOCMD));
                return true;
            }
            SubCommands target = this.get(args[0]);
            if (target == null) {
                sender.sendMessage(MessageUtils.formattedMessage(Messages.NOCMD));
                return true;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(args));
            arrayList.remove(0);
            try {
                target.onCommand(sender, args);
            }
            catch (Exception e) {
                MessageUtils.sendError(sender, "&4Something has gone wrong when using this command!");
                e.printStackTrace();
            }
        }
        return true;
    }

    private SubCommands get(String name) {
        for (SubCommands sc : this.commands) {
            if (sc.name().equalsIgnoreCase(name)) {
                return sc;
            }
            for (String alias : sc.aliases()) {
                if (!name.equalsIgnoreCase(alias)) continue;
                return sc;
            }
        }
        return null;
    }
}

