/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.schematics;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.BuiltInClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import de.eldoria.schematicbrush.brush.config.util.Nameable;
import de.eldoria.schematicbrush.schematics.Schematic;
import de.eldoria.schematicbrush.schematics.SchematicCache;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class GridSchematics
implements SchematicCache {
    public static final Nameable KEY = Nameable.of((String)"grid");
    private final Plugin plugin;
    private final WorldEdit worldEdit = WorldEdit.getInstance();
    private final Map<UUID, Integer> directoryIds = new HashMap<UUID, Integer>();

    public GridSchematics(Plugin plugin) {
        this.plugin = plugin;
    }

    public void saveRegions(Player player, List<CuboidRegion> regions) {
        Path playerDirectory = this.getDirectory(player, this.getNextDirectoryId(player));
        int num = 0;
        for (CuboidRegion region : regions) {
            BlockArrayClipboard clipboard = new BlockArrayClipboard((Region)region);
            try (EditSession session = this.worldEdit.newEditSession(BukkitAdapter.adapt((World)player.getWorld()));){
                ForwardExtentCopy copy = new ForwardExtentCopy((Extent)session, (Region)region, (Extent)clipboard, region.getMinimumPoint());
                Operations.complete((Operation)copy);
                File schemFile = playerDirectory.resolve(Path.of(num + ".schem", new String[0])).toFile();
                try (ClipboardWriter writer = BuiltInClipboardFormat.SPONGE_SCHEMATIC.getWriter((OutputStream)new FileOutputStream(schemFile));){
                    writer.write((Clipboard)clipboard);
                }
            }
            catch (WorldEditException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not save player schematic.", e);
            }
            catch (FileNotFoundException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Schematic file not found.", e);
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Could not write player schematic.", e);
            }
            ++num;
        }
    }

    private Path getDirectory(Player player, int id) {
        return this.getDirectory(player.getUniqueId(), id);
    }

    private Path getDirectory(UUID uuid, int id) {
        Path schematics = this.plugin.getDataFolder().toPath().resolve(Path.of("schematics", uuid.toString(), String.valueOf(id)));
        try {
            Files.createDirectories(schematics, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create player directory", e);
        }
        return schematics;
    }

    public void init() {
        this.clearSchematics();
    }

    public void shutdown() {
        this.clearSchematics();
    }

    private void clearSchematics() {
        try (Stream<Path> stream2 = Files.walk(this.plugin.getDataFolder().toPath().resolve(Path.of("schematics", new String[0])), new FileVisitOption[0]);){
            stream2.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (FileNotFoundException stream2) {
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Cloud not clear player directory", e);
        }
    }

    public void reload() {
    }

    public Set<Schematic> getSchematicsByName(Player player, String name) {
        Set<Schematic> set;
        block8: {
            Stream<Path> stream = Files.walk(this.getDirectory(player, this.getDirectoryId(player)), new FileVisitOption[0]);
            try {
                set = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(f -> Schematic.of((File)f.toFile())).collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.plugin.getLogger().log(Level.SEVERE, "Could not load player schematics");
                    return Collections.emptySet();
                }
            }
            stream.close();
        }
        return set;
    }

    public Set<Schematic> getSchematicsByDirectory(Player player, String name, String filter) {
        return this.getSchematicsByName(player, name);
    }

    public List<String> getMatchingDirectories(Player player, String dir, int count) {
        return Collections.emptyList();
    }

    public List<String> getMatchingSchematics(Player player, String name, int count) {
        return Collections.emptyList();
    }

    public int schematicCount() {
        return 0;
    }

    public int directoryCount() {
        return 0;
    }

    private int getDirectoryId(Player uuid) {
        return this.directoryIds.computeIfAbsent(uuid.getUniqueId(), k -> 0);
    }

    private int getNextDirectoryId(Player uuid) {
        return this.directoryIds.compute(uuid.getUniqueId(), (k, v) -> v == null ? 0 : v + 1);
    }
}

