/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.config.elements.cluster;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import de.eldoria.gridselector.config.elements.cluster.Plot;
import de.eldoria.gridselector.util.Colors;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.MessageComposer;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.SerializationUtil;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.TypeResolvingMap;
import de.eldoria.schematicbrush.libs.eldoutilities.utils.EMath;
import de.eldoria.schematicbrush.libs.eldoutilities.utils.EnumUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="gridSelectorGridCluster")
public class GridCluster
implements ConfigurationSerializable {
    private int id = -1;
    private int minHeight = 0;
    private Plot plot;
    private int elementSize = 7;
    private int offset = 1;
    private int rows = 2;
    private int columns = 2;
    private Material borderMaterial = Material.RED_CONCRETE;
    private Material offsetMaterial = Material.LIGHT_GRAY_CONCRETE;
    private Material floorMaterial = Material.WHITE_CONCRETE;

    public GridCluster(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        this.id = (Integer)map.getValue("id");
        this.minHeight = (Integer)map.getValue("minHeight");
        this.plot = (Plot)map.getValue("plot");
        this.elementSize = (Integer)map.getValue("elementSize");
        this.offset = (Integer)map.getValue("offset");
        this.rows = (Integer)map.getValue("rows");
        this.columns = (Integer)map.getValue("columns");
        this.borderMaterial = (Material)map.getValue("borderMaterial", e -> EnumUtil.parse((String)e, Material.class).orElse(this.borderMaterial));
        this.offsetMaterial = (Material)map.getValue("offsetMaterial", e -> EnumUtil.parse((String)e, Material.class).orElse(this.offsetMaterial));
        this.floorMaterial = (Material)map.getValue("floorMaterial", e -> EnumUtil.parse((String)e, Material.class).orElse(this.floorMaterial));
    }

    public GridCluster() {
    }

    public GridCluster(Plot boundings, int elementSize, int offset, int rows, int columns, Material borderMaterial, Material offsetMaterial, Material floorMaterial) {
        this.plot = boundings;
        this.elementSize = elementSize;
        this.offset = offset;
        this.rows = rows;
        this.columns = columns;
        this.borderMaterial = borderMaterial;
        this.offsetMaterial = offsetMaterial;
        this.floorMaterial = floorMaterial;
    }

    public static Builder builder(Location center, Direction direction) {
        return new Builder(center, direction);
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("id", (Object)this.id).add("minHeight", (Object)this.minHeight).add("plot", (Object)this.plot).add("elementSize", (Object)this.elementSize).add("offset", (Object)this.offset).add("rows", (Object)this.rows).add("columns", (Object)this.columns).add("borderMaterial", (Enum)this.borderMaterial).add("offsetMaterial", (Enum)this.offsetMaterial).add("floorMaterial", (Enum)this.floorMaterial).build();
    }

    public void updateMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

    public int minHeight() {
        return this.minHeight;
    }

    public BlockState getBlock(BlockVector2 location) {
        return BukkitAdapter.adapt((BlockData)this.getMaterial(location).createBlockData());
    }

    public Material getMaterial(BlockVector2 location) {
        Optional<Plot> optRegion = this.getRegion(location);
        if (optRegion.isEmpty()) {
            return this.offsetMaterial;
        }
        Plot region = optRegion.get();
        Plot borderless = region.borderLessPlot();
        if (borderless.contains(location)) {
            return this.floorMaterial;
        }
        return this.borderMaterial;
    }

    public Optional<Plot> getRegion(Location location) {
        return this.getRegion(location.toVector().toVector2().toBlockPoint());
    }

    public Optional<Plot> getRegion(BlockVector2 vector) {
        if (!this.plot.contains(vector)) {
            return Optional.empty();
        }
        int totalElementSize = this.elementSize + 2 + this.offset;
        BlockVector2 min = this.plot.min();
        int xOffset = EMath.diff((int)min.getX(), (int)vector.getX());
        int zOffset = EMath.diff((int)min.getZ(), (int)vector.getZ());
        int xIndex = xOffset % totalElementSize;
        int zIndex = zOffset % totalElementSize;
        if (xIndex >= this.elementSize + 2) {
            return Optional.empty();
        }
        if (zIndex >= this.elementSize + 2) {
            return Optional.empty();
        }
        double gridX = Math.floor(xOffset / totalElementSize);
        double gridZ = Math.floor(zOffset / totalElementSize);
        return Optional.ofNullable(this.getRegion(min, (int)gridX, (int)gridZ));
    }

    public Plot getRegion(BlockVector2 base, int x, int z) {
        int totalElementSize = this.elementSize + 2 + this.offset;
        BlockVector2 min = BlockVector2.at((int)(base.getX() + x * totalElementSize), (int)(base.getZ() + z * totalElementSize));
        return Plot.of(min, min.add(BlockVector2.at((int)(this.elementSize + 1), (int)(this.elementSize + 1))));
    }

    public boolean contains(BlockVector2 location) {
        return this.plot.contains(location);
    }

    public Plot plot() {
        return this.plot;
    }

    public int elementSize() {
        return this.elementSize;
    }

    public int offset() {
        return this.offset;
    }

    public int rows() {
        return this.rows;
    }

    public int columns() {
        return this.columns;
    }

    public Material borderMaterial() {
        return this.borderMaterial;
    }

    public Material offsetMaterial() {
        return this.offsetMaterial;
    }

    public Material floorMaterial() {
        return this.floorMaterial;
    }

    public int id() {
        return this.id;
    }

    public void id(int id) {
        if (this.id != -1) {
            throw new IllegalStateException("Id already set");
        }
        this.id = id;
    }

    public List<Plot> getRegions() {
        ArrayList<Plot> plots = new ArrayList<Plot>();
        for (int x = this.plot.min().getBlockX(); x < this.plot.max().getBlockX(); x += this.elementSize + 2 + this.offset) {
            for (int z = this.plot.min().getBlockZ(); z < this.plot.max().getBlockZ(); z += this.elementSize + 2 + this.offset) {
                this.getRegion(BlockVector2.at((int)x, (int)z)).ifPresent(plots::add);
            }
        }
        return plots;
    }

    public static class Builder {
        private World world;
        private Location center;
        private Direction direction;
        private int elementSize = 7;
        private int offset = 1;
        private int rows = 2;
        private int columns = 2;
        private boolean expandRight = true;
        private Material borderMaterial = Material.RED_CONCRETE;
        private Material offsetMaterial = Material.LIGHT_GRAY_CONCRETE;
        private Material floorMaterial = Material.WHITE_CONCRETE;

        public Builder(Location center, Direction direction) {
            this.world = (World)center.getExtent();
            this.center = center.setY((double)this.world.getMinY());
            this.direction = direction;
        }

        private static Direction rotate(Direction direction, boolean rotateRight) {
            int index = direction.toRotationIndex().getAsInt() + (rotateRight ? 4 : 12);
            return (Direction)Direction.fromRotationIndex((int)(index % 16)).get();
        }

        public void elementSize(int elementSize) {
            this.elementSize = elementSize;
        }

        public void offset(int offset) {
            this.offset = offset;
        }

        public void rows(int rows) {
            this.rows = rows;
        }

        public void columns(int columns) {
            this.columns = columns;
        }

        public void expandRight(boolean expandRight) {
            this.expandRight = expandRight;
        }

        public void borderMaterial(Material borderMaterial) {
            this.borderMaterial = borderMaterial;
        }

        public void offsetMaterial(Material offsetMaterial) {
            this.offsetMaterial = offsetMaterial;
        }

        public void floorMaterial(Material floorMaterial) {
            this.floorMaterial = floorMaterial;
        }

        public GridCluster build() {
            int rowsSize = (this.elementSize + 2) * this.rows + (this.rows - 1) * this.offset;
            int columnSize = (this.elementSize + 2) * this.columns + (this.columns - 1) * this.offset;
            Direction columnDir = Builder.rotate(this.direction, this.expandRight);
            Vector3 offsetVec = Vector3.ZERO.add(this.direction.toVector().multiply((double)rowsSize)).add(columnDir.toVector().multiply((double)columnSize));
            BlockVector first = BukkitAdapter.adapt((Location)this.center).toVector().toBlockVector();
            BlockVector second = BukkitAdapter.adapt((Location)new Location((Extent)this.world, this.center.toVector().add(offsetVec).withY((double)this.world.getMaxY()))).toVector().toBlockVector();
            Plot boundings = Plot.of(this.floorVector((Vector)first), this.floorVector((Vector)second)).modify(min -> min, max -> max.subtract(1, 1));
            return new GridCluster(boundings, this.elementSize, this.offset, this.rows, this.columns, this.borderMaterial, this.offsetMaterial, this.floorMaterial);
        }

        public BlockVector2 floorVector(Vector vector) {
            return BlockVector2.at((int)vector.getBlockX(), (int)vector.getBlockZ());
        }

        public String asComponent() {
            String message = MessageComposer.create().text("<%s>Cluster Settings", new Object[]{Colors.HEADING}).newLine().text("<%s>Location: <%s>%s|%s", new Object[]{Colors.NAME, Colors.VALUE, this.center.getBlockX(), this.center.getBlockZ()}).space().text("<%s><click:run_command:'/sbrg cluster modify center'>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Direction: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.direction.name()}).space().text("<%s><click:run_command:'/sbrg cluster modify direction'>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Expand: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.expandRight ? "right" : "left"}).space().text("<%s><click:run_command:'/sbrg cluster modify expandRight'>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Size: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.elementSize}).space().text("<%s><click:suggest_command:'/sbrg cluster modify size '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Rows: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.rows}).space().text("<%s><click:suggest_command:'/sbrg cluster modify rows '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Columns: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.columns}).space().text("<%s><click:suggest_command:'/sbrg cluster modify columns '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Offset: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.offset}).space().text("<%s><click:suggest_command:'/sbrg cluster modify offset '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Floor Material: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.floorMaterial}).space().text("<%s><click:suggest_command:'/sbrg cluster modify floorMaterial '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Border Material: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.borderMaterial}).space().text("<%s><click:suggest_command:'/sbrg cluster modify borderMaterial '>[change]</click>", new Object[]{Colors.CHANGE}).newLine().text("<%s>Offset Material: <%s>%s", new Object[]{Colors.NAME, Colors.VALUE, this.offsetMaterial}).space().text("<%s><click:suggest_command:'/sbrg cluster modify offsetMaterial '>[change]</click>", new Object[]{Colors.CHANGE}).build();
            return message;
        }

        public boolean isExpandRight() {
            return this.expandRight;
        }

        public void center(Location center) {
            this.world = (World)center.getExtent();
            this.center = center.setY((double)this.world.getMinY());
        }

        public void direction(Direction direction) {
            this.direction = direction;
        }
    }

    private record PlotKey(int x, int y) {
    }
}

