/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.config.elements.cluster;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector2;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.Replacement;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.SerializationUtil;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.TypeResolvingMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="gridSelectorClusterWorld")
public class ClusterWorld
implements ConfigurationSerializable {
    private final UUID uid;
    private final List<GridCluster> cluster;
    private int id = 1;

    public ClusterWorld(World world) {
        this.uid = world.getUID();
        this.cluster = new ArrayList<GridCluster>();
    }

    public ClusterWorld(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        this.uid = UUID.fromString((String)map.getValue("UID"));
        this.cluster = (List)map.getValue("cluster");
        this.id = (Integer)map.getValue("id");
    }

    public void register(GridCluster cluster) throws CommandException {
        this.assertOverlap(cluster);
        cluster.id(this.id++);
        this.cluster.add(cluster);
    }

    public void assertOverlap(GridCluster cluster) throws CommandException {
        for (GridCluster gridCluster : this.cluster) {
            CommandAssertions.isFalse((boolean)gridCluster.plot().overlaps(cluster.plot()), (String)("Cluster overlaps with cluster " + gridCluster.id() + ". Change dimensions/position or remove other cluster first."), (Replacement[])new Replacement[0]);
        }
    }

    public boolean unregister(int id) {
        return this.cluster.removeIf(c -> c.id() == id);
    }

    public boolean unregister(GridCluster cluster) {
        return this.unregister(cluster.id());
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("UID", (Object)this.uid.toString()).add("id", (Object)this.id).add("cluster", this.cluster).build();
    }

    public Optional<GridCluster> getCluster(Location location) {
        BlockVector2 vec2 = BukkitAdapter.adapt((Location)location).toVector().toBlockPoint().toBlockVector2();
        return this.cluster.stream().filter(c -> c.contains(vec2)).findFirst();
    }

    public Optional<GridCluster> getCluster(int id) {
        return this.cluster.stream().filter(c -> c.id() == id).findFirst();
    }

    public List<GridCluster> cluster() {
        return Collections.unmodifiableList(this.cluster);
    }

    public UUID uid() {
        return this.uid;
    }
}

