/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.config.elements;

import de.eldoria.gridselector.config.elements.cluster.ClusterWorld;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.SerializationUtil;
import de.eldoria.schematicbrush.libs.eldoutilities.serialization.TypeResolvingMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.SerializableAs;
import org.jetbrains.annotations.NotNull;

@SerializableAs(value="gridSelectorClusterWorlds")
public class ClusterWorlds
implements ConfigurationSerializable {
    private final Map<UUID, ClusterWorld> clusterWorlds = new HashMap<UUID, ClusterWorld>();

    public ClusterWorlds() {
    }

    public ClusterWorlds(Map<String, Object> objectMap) {
        TypeResolvingMap map = SerializationUtil.mapOf(objectMap);
        List worlds = (List)map.getValue("worlds");
        for (ClusterWorld world : worlds) {
            this.clusterWorlds.put(world.uid(), world);
        }
    }

    @NotNull
    public Map<String, Object> serialize() {
        return SerializationUtil.newBuilder().add("worlds", new ArrayList<ClusterWorld>(this.clusterWorlds.values())).build();
    }

    public ClusterWorld world(World world) {
        return this.clusterWorlds.computeIfAbsent(world.getUID(), k -> new ClusterWorld(world));
    }
}

