/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.command.grid.cluster;

import de.eldoria.gridselector.adapter.worldguard.IWorldGuardAdapter;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import de.eldoria.gridselector.util.Permissions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.CommandMeta;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.Arguments;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.executor.IPlayerTabExecutor;
import de.eldoria.schematicbrush.libs.eldoutilities.localization.Replacement;
import java.util.List;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Remove
extends AdvancedCommand
implements IPlayerTabExecutor {
    private final Configuration configuration;
    private final IWorldGuardAdapter worldGuardAdapter;

    public Remove(Plugin plugin, Configuration configuration, IWorldGuardAdapter worldGuardAdapter) {
        super(plugin, CommandMeta.builder((String)"remove").addUnlocalizedArgument("id", false).withPermission(new String[]{Permissions.Cluster.REMOVE}).build());
        this.configuration = configuration;
        this.worldGuardAdapter = worldGuardAdapter;
    }

    public void onCommand(@NotNull Player player, @NotNull String alias, @NotNull Arguments args) throws CommandException {
        Optional<GridCluster> cluster;
        if (args.isEmpty()) {
            cluster = this.configuration.cluster().world(player.getWorld()).getCluster(player.getLocation());
            CommandAssertions.isTrue((boolean)cluster.isPresent(), (String)"You are not inside a cluster", (Replacement[])new Replacement[0]);
        } else {
            cluster = this.configuration.cluster().world(player.getWorld()).getCluster(args.asInt(0));
            CommandAssertions.isTrue((boolean)cluster.isPresent(), (String)"Unkown cluster id", (Replacement[])new Replacement[0]);
        }
        this.worldGuardAdapter.unregister(cluster.get(), player);
        this.configuration.cluster().world(player.getWorld()).unregister(cluster.get().id());
        this.messageSender().sendMessage((CommandSender)player, "Cluster removed");
        this.configuration.save();
    }

    @Nullable
    public List<String> onTabComplete(@NotNull Player player, @NotNull String alias, @NotNull Arguments args) throws CommandException {
        return super.onTabComplete(player, alias, args);
    }
}

