/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.command.grid;

import de.eldoria.gridselector.schematics.GridSchematics;
import de.eldoria.gridselector.util.Permissions;
import de.eldoria.schematicbrush.SchematicBrushReborn;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.AdvancedCommand;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.CommandMeta;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.Arguments;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.command.util.CommandAssertions;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.exceptions.CommandException;
import de.eldoria.schematicbrush.libs.eldoutilities.commands.executor.IPlayerTabExecutor;
import de.eldoria.schematicbrush.schematics.Schematic;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class Export
extends AdvancedCommand
implements IPlayerTabExecutor {
    private final SchematicBrushReborn schematicBrushReborn;
    private final GridSchematics gridSchematics;

    public Export(Plugin plugin, SchematicBrushReborn schematicBrushReborn, GridSchematics gridSchematics) {
        super(plugin, CommandMeta.builder((String)"export").addArgument("name", true).withPermission(new String[]{Permissions.Save.EXPORT}).build());
        this.schematicBrushReborn = schematicBrushReborn;
        this.gridSchematics = gridSchematics;
    }

    public void onCommand(@NotNull Player player, @NotNull String alias, @NotNull Arguments args) throws CommandException {
        Set<Schematic> schematics = this.gridSchematics.getSchematicsByName(player, null);
        Path basePath = this.schematicBrushReborn.getDataFolder().toPath().resolve(Path.of("schematics", new String[0]));
        if (!args.flags().has("g")) {
            basePath = basePath.resolve(Path.of(player.getUniqueId().toString(), new String[0]));
        } else {
            CommandAssertions.permission((CommandSender)player, (boolean)false, (String[])new String[]{Permissions.Save.GLOBAL});
        }
        try {
            Files.createDirectories(basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin().getLogger().log(Level.WARNING, "Could not create directories", e);
            this.messageSender().sendError((CommandSender)player, "Failed to save schematics. See console for further information.");
            return;
        }
        for (Schematic schematic : schematics) {
            try {
                Path target = basePath.resolve(args.asString(0) + "_" + schematic.getFile().getName());
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                if (target.toFile().exists() && !args.flags().has("f")) {
                    this.messageSender().sendError((CommandSender)player, "Name already in use.");
                    return;
                }
                Files.copy(schematic.getFile().toPath(), target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.plugin().getLogger().log(Level.WARNING, "Could not save schematic", e);
                this.messageSender().sendError((CommandSender)player, "Failed to save schematics. See console for further information.");
                return;
            }
        }
        this.messageSender().sendMessage((CommandSender)player, "Saved " + schematics.size() + " schematics.");
    }
}

