/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.adapter.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import de.eldoria.gridselector.adapter.worldguard.IWorldGuardAdapter;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.cluster.GridCluster;
import org.bukkit.entity.Player;

public class WorldGuardAdapter
implements IWorldGuardAdapter {
    private final WorldGuard worldGuard = WorldGuard.getInstance();
    private final Configuration configuration;

    public WorldGuardAdapter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void register(GridCluster cluster, Player player) {
        if (this.configuration.general().isCreateWorldGuardRegions() && this.worldGuard != null) {
            World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
            ProtectedCuboidRegion region = new ProtectedCuboidRegion(cluster.plot().id(), cluster.plot().min().toBlockVector3(world.getMinY()), cluster.plot().max().toBlockVector3(world.getMaxY()));
            region.getOwners().addPlayer(player.getUniqueId());
            this.worldGuard.getPlatform().getRegionContainer().get(world).addRegion((ProtectedRegion)region);
        }
    }

    @Override
    public void unregister(GridCluster cluster, Player player) {
        if (this.configuration.general().isCreateWorldGuardRegions() && this.worldGuard != null) {
            World world = BukkitAdapter.adapt((org.bukkit.World)player.getWorld());
            this.worldGuard.getPlatform().getRegionContainer().get(world).removeRegion(cluster.plot().id());
        }
    }
}

