/*
 * Decompiled with CFR 0.152.
 */
package de.eldoria.gridselector.adapter.regionadapter;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import de.eldoria.gridselector.adapter.regionadapter.RegionAdapter;
import de.eldoria.gridselector.adapter.regionadapter.RegionResult;
import de.eldoria.gridselector.config.Configuration;
import de.eldoria.gridselector.config.elements.cluster.Plot;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;

public class ClusterWorldAdapter
implements RegionAdapter {
    private final Configuration configuration;

    public ClusterWorldAdapter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public boolean isApplicable(Location location) {
        return !this.configuration.cluster().world(location.getWorld()).cluster().isEmpty();
    }

    @Override
    public Optional<RegionResult> getRegion(Location location) {
        return this.configuration.cluster().world(location.getWorld()).getCluster(location).flatMap(cluster -> {
            Optional<Plot> optPlot = cluster.getRegion(BukkitAdapter.adapt((Location)location));
            return optPlot.map(plot -> new RegionResult(plot.id(), plot.borderLessPlot().asRegion(BukkitAdapter.adapt((World)location.getWorld())), plot.asRegion(BukkitAdapter.adapt((World)location.getWorld())), cluster.minHeight()));
        });
    }
}

