/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.internal.editor.toml;

import dev.mrwere.storage.storage.internal.editor.toml.TomlManager;
import dev.mrwere.storage.storage.internal.exceptions.TomlException;
import java.io.IOException;
import java.io.Writer;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class TomlWriter {
    private final Writer writer;
    private final int indentSize;
    private final char indentCharacter;
    private final String lineSeparator;
    private final LinkedList<String> tablesNames = new LinkedList();
    private int lineBreaks = 0;
    private int indentationLevel = -1;

    public TomlWriter(Writer writer) {
        this(writer, 1, false, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean indentWithSpaces) {
        this(writer, indentSize, indentWithSpaces, System.lineSeparator());
    }

    public TomlWriter(Writer writer, int indentSize, boolean indentWithSpaces, String lineSeparator) {
        this.writer = writer;
        this.indentSize = indentSize;
        this.indentCharacter = (char)(indentWithSpaces ? 32 : 9);
        this.lineSeparator = lineSeparator;
    }

    private static void addEscaped(StringBuilder stringBuilder, char c) {
        switch (c) {
            case '\b': {
                stringBuilder.append("\\b");
                break;
            }
            case '\t': {
                stringBuilder.append("\\t");
                break;
            }
            case '\n': {
                stringBuilder.append("\\n");
                break;
            }
            case '\\': {
                stringBuilder.append("\\\\");
                break;
            }
            case '\r': {
                stringBuilder.append("\\r");
                break;
            }
            case '\f': {
                stringBuilder.append("\\f");
                break;
            }
            case '\"': {
                stringBuilder.append("\\\"");
                break;
            }
            default: {
                stringBuilder.append(c);
            }
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(Map<String, Object> data) throws IOException {
        this.writeTableContent(data);
    }

    private void writeTableName() throws IOException {
        Iterator it = this.tablesNames.iterator();
        while (it.hasNext()) {
            String namePart = (String)it.next();
            this.writeKey(namePart);
            if (!it.hasNext()) continue;
            this.write('.');
        }
    }

    private void writeTableContent(Map<String, Object> table) throws IOException {
        this.writeTableContent(table, true);
        this.writeTableContent(table, false);
    }

    private void writeTableContent(Map<String, Object> table, boolean simpleValues) throws IOException {
        for (Map.Entry<String, Object> entry : table.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection c = (Collection)value;
                if (!c.isEmpty() && c.iterator().next() instanceof Map) {
                    if (simpleValues) continue;
                    this.tablesNames.addLast(name);
                    ++this.indentationLevel;
                    for (Object element : c) {
                        this.indent();
                        this.write("[[");
                        this.writeTableName();
                        this.write("]]\n");
                        Map map = (Map)element;
                        this.writeTableContent(map);
                    }
                    --this.indentationLevel;
                    this.tablesNames.removeLast();
                } else {
                    if (!simpleValues) continue;
                    this.indent();
                    this.writeKey(name);
                    this.write(" = ");
                    this.writeArray(c);
                }
            } else if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length > 0 && array[0] instanceof Map) {
                    if (simpleValues) continue;
                    this.tablesNames.addLast(name);
                    ++this.indentationLevel;
                    for (Object element : array) {
                        this.indent();
                        this.write("[[");
                        this.writeTableName();
                        this.write("]]\n");
                        Map map = (Map)element;
                        this.writeTableContent(map);
                    }
                    --this.indentationLevel;
                    this.tablesNames.removeLast();
                } else {
                    if (!simpleValues) continue;
                    this.indent();
                    this.writeKey(name);
                    this.write(" = ");
                    this.writeArray(array);
                }
            } else if (value instanceof Map) {
                if (simpleValues) continue;
                this.tablesNames.addLast(name);
                ++this.indentationLevel;
                this.indent();
                this.write('[');
                this.writeTableName();
                this.write(']');
                this.newLine();
                this.writeTableContent((Map)value);
                --this.indentationLevel;
                this.tablesNames.removeLast();
            } else {
                if (!simpleValues) continue;
                this.indent();
                this.writeKey(name);
                this.write(" = ");
                this.writeValue(value);
            }
            this.newLine();
        }
        this.newLine();
    }

    private void writeKey(String key) throws IOException {
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
            this.writeString(key);
            return;
        }
        this.write(key);
    }

    private void writeString(String str) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            TomlWriter.addEscaped(stringBuilder, c);
        }
        stringBuilder.append('\"');
        this.write(stringBuilder.toString());
    }

    private void writeArray(Collection<?> c) throws IOException {
        this.write('[');
        for (Object element : c) {
            this.writeValue(element);
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(Object[] array) throws IOException {
        this.write('[');
        for (Object element : array) {
            this.writeValue(element);
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(byte[] array) throws IOException {
        this.write('[');
        for (byte element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(short[] array) throws IOException {
        this.write('[');
        for (short element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(char[] array) throws IOException {
        this.write('[');
        for (char element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(int[] array) throws IOException {
        this.write('[');
        for (int element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(long[] array) throws IOException {
        this.write('[');
        for (long element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(float[] array) throws IOException {
        this.write('[');
        for (float element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeArray(double[] array) throws IOException {
        this.write('[');
        for (double element : array) {
            this.write(String.valueOf(element));
            this.write(", ");
        }
        this.write(']');
    }

    private void writeValue(Object value) throws IOException {
        if (value instanceof String) {
            this.writeString((String)value);
        } else if (value instanceof Number || value instanceof Boolean) {
            this.write(value.toString());
        } else if (value instanceof TemporalAccessor) {
            String formatted = TomlManager.DATE_FORMATTER.format((TemporalAccessor)value);
            if (formatted.endsWith("T")) {
                formatted = formatted.substring(0, formatted.length() - 1);
            }
            this.write(formatted);
        } else if (value instanceof Collection) {
            this.writeArray((Collection)value);
        } else if (value instanceof int[]) {
            this.writeArray((int[])value);
        } else if (value instanceof byte[]) {
            this.writeArray((byte[])value);
        } else if (value instanceof short[]) {
            this.writeArray((short[])value);
        } else if (value instanceof char[]) {
            this.writeArray((char[])value);
        } else if (value instanceof long[]) {
            this.writeArray((long[])value);
        } else if (value instanceof float[]) {
            this.writeArray((float[])value);
        } else if (value instanceof double[]) {
            this.writeArray((double[])value);
        } else {
            if (value instanceof Map) {
                throw new IOException("Unexpected value " + value);
            }
            throw new TomlException(new String[]{"Unsupported value of type " + value.getClass().getCanonicalName()});
        }
    }

    private void newLine() throws IOException {
        if (this.lineBreaks <= 1) {
            this.writer.write(this.lineSeparator);
            ++this.lineBreaks;
        }
    }

    private void write(char c) throws IOException {
        this.writer.write(c);
        this.lineBreaks = 0;
    }

    private void write(String str) throws IOException {
        this.writer.write(str);
        this.lineBreaks = 0;
    }

    private void indent() throws IOException {
        for (int i = 0; i < this.indentationLevel; ++i) {
            for (int j = 0; j < this.indentSize; ++j) {
                this.write(this.indentCharacter);
            }
        }
    }
}

