/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.Grenades.utils;

import dev.mrwere.Grenades.Core;
import dev.mrwere.Grenades.nbtapi.nbtapi.NBTItem;
import dev.mrwere.Grenades.utils.messaging;
import java.util.ArrayList;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class validator {
    public static boolean isValid(ItemStack is) {
        int LGVERSION;
        if (is.getType() == Material.AIR) {
            return false;
        }
        if (!new NBTItem(is).getBoolean("ISGRENADE").booleanValue()) {
            return false;
        }
        NBTItem nbti = new NBTItem(is);
        Integer GID = nbti.getInteger("GID");
        if (GID == null) {
            return false;
        }
        if (Core.grenades.get("" + GID) == null) {
            if (Core.debugMode) {
                messaging.log("Grenade with GID: " + GID + " not found!");
            }
            return false;
        }
        int GVERSION = nbti.getInteger("GVERSION");
        if (GVERSION < (LGVERSION = Core.grenades.getInt(GID + ".version"))) {
            if (Core.debugMode) {
                messaging.log("&7Updating grenade (GID: &d'" + GID + "'&7) from version '" + GVERSION + "' to '" + LGVERSION + "'");
            }
            validator.setupGrenade(is, GID, true);
        }
        return true;
    }

    public static void setupGrenade(ItemStack is, Integer grenadeID, boolean force) {
        NBTItem nbti = new NBTItem(is);
        if (nbti.getInteger("GID") != 0 && !force) {
            messaging.log("Tried to setup item which is already a grenade! GID: " + nbti.getInteger("GID"));
            return;
        }
        if (Core.grenades.get("" + grenadeID) == null) {
            messaging.log("Invalid grenade ID! Please make sure its in the config: " + grenadeID);
            return;
        }
        nbti.setInteger("GID", grenadeID);
        nbti.setBoolean("ISGRENADE", true);
        nbti.setBoolean("ISLANDMINE", Core.grenades.getBoolean(grenadeID + ".item.islandmine"));
        nbti.setInteger("GVERSION", Core.grenades.getInt(grenadeID + ".version"));
        nbti.setString("PARTICLE", Core.grenades.getString(grenadeID + ".item.particle.explode.type"));
        nbti.setString("SHAPE", Core.grenades.getString(grenadeID + ".item.particle.explode.shape"));
        nbti.setInteger("PARTICLECOUNT", Core.grenades.getInt(grenadeID + ".item.particle.explode.count"));
        nbti.setDouble("PARTICLEOFFSETX", Core.grenades.getDouble(grenadeID + ".item.particle.explode.offsetx"));
        nbti.setDouble("PARTICLEOFFSETY", Core.grenades.getDouble(grenadeID + ".item.particle.explode.offsety"));
        nbti.setDouble("PARTICLEOFFSETZ", Core.grenades.getDouble(grenadeID + ".item.particle.explode.offsetz"));
        nbti.setString("PARTICLECOLOR", Core.grenades.getString(grenadeID + ".item.particle.explode.color"));
        nbti.setString("PARTICLECOLORFADE", Core.grenades.getString(grenadeID + ".item.particle.explode.colorfade"));
        nbti.setString("TRAIL", Core.grenades.getString(grenadeID + ".item.particle.trail.type"));
        nbti.setInteger("TRAILCOUNT", Core.grenades.getInt(grenadeID + ".item.particle.trail.count"));
        nbti.setInteger("TRAILSIZE", Core.grenades.getInt(grenadeID + ".item.particle.trail.size"));
        nbti.setString("TRAILCOLOR", Core.grenades.getString(grenadeID + ".item.particle.trail.color"));
        nbti.setDouble("TRAILOFFSETX", Core.grenades.getDouble(grenadeID + ".item.particle.trail.offsetx"));
        nbti.setDouble("TRAILOFFSETY", Core.grenades.getDouble(grenadeID + ".item.particle.trail.offsety"));
        nbti.setDouble("TRAILOFFSETZ", Core.grenades.getDouble(grenadeID + ".item.particle.trail.offsetz"));
        nbti.setBoolean("GLOW", Core.grenades.getBoolean(grenadeID + ".item.glow"));
        nbti.setBoolean("COUNTDOWN", Core.grenades.getBoolean(grenadeID + ".item.countdown.enabled"));
        nbti.setInteger("COUNTDOWNTIME", Core.grenades.getInt(grenadeID + ".item.countdown.time"));
        nbti.setInteger("POWER", Core.grenades.getInt(grenadeID + ".item.power"));
        nbti.setBoolean("FIRE", Core.grenades.getBoolean(grenadeID + ".item.fire"));
        nbti.setBoolean("DESTROYBLOCKS", Core.grenades.getBoolean(grenadeID + ".item.destroy-blocks"));
        nbti.setString("MODEL", Core.grenades.getString(grenadeID + ".item.model").toUpperCase());
        nbti.setString("CRAFTPERM", Core.grenades.getString(grenadeID + ".craft.perm"));
        nbti.setString("SOUND", Core.grenades.getString(grenadeID + ".item.sound.type"));
        nbti.setInteger("VOLUME", Core.grenades.getInt(grenadeID + ".item.sound.volume"));
        nbti.setDouble("PITCH", Core.grenades.getDouble(grenadeID + ".item.sound.pitch"));
        nbti.setString("EXPLOSIONTYPE", Core.grenades.getString(grenadeID + ".item.explosion-type"));
        nbti.mergeNBT(is);
        ItemMeta ism = is.getItemMeta();
        ism.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)Core.grenades.getString(grenadeID + ".item.display-name")));
        ArrayList<String> dalore = new ArrayList<String>();
        for (int i = 0; i < Core.grenades.getList(grenadeID + ".item.lore").size(); ++i) {
            dalore.add(Core.grenades.getList(grenadeID + ".item.lore").get(i).toString().replaceAll("&", "\u00a7"));
        }
        ism.setLore(dalore);
        is.setItemMeta(ism);
    }
}

