/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.Grenades.event;

import dev.mrwere.Grenades.Core;
import dev.mrwere.Grenades.nbtapi.nbtapi.NBTItem;
import dev.mrwere.Grenades.utils.effect;
import dev.mrwere.Grenades.utils.messaging;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.scheduler.BukkitRunnable;

public class landmineListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    private void onBlockPressurePlate(PlayerInteractEvent e) {
        if (e.getAction() != Action.PHYSICAL) {
            return;
        }
        Block pressureplate = e.getClickedBlock();
        this.detonateLandmine(pressureplate.getLocation());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    private void onBlockDestroy(BlockBreakEvent e) {
        Block b = e.getBlock();
        String w = b.getWorld().getName();
        Chunk ch = b.getChunk();
        int xch = ch.getX();
        int zch = ch.getZ();
        int x = b.getX();
        int y = b.getY();
        int z = b.getZ();
        String dlocpath = x + "/" + y + "/" + z + "/";
        String chunkpath = w + "." + xch + "/" + zch + "/";
        if (Core.landmines.get(chunkpath) == null || Core.landmines.get(chunkpath + "." + dlocpath) == null || e.isCancelled() || !e.isDropItems() && e.getPlayer().getGameMode() != GameMode.CREATIVE) {
            return;
        }
        NBTItem nbti = new NBTItem(new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)Core.landmines.getString(chunkpath + "." + dlocpath + ".MATERIAL.data"))), 1));
        Core.landmines.getSection(chunkpath + "." + dlocpath).keySet().forEach(kkey -> this.transformConfigDataToNBTItem(nbti, kkey.replace(".data", "").replace(".type", ""), chunkpath + "." + dlocpath));
        ItemStack is = nbti.getItem();
        ItemMeta ism = is.getItemMeta();
        ism.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)Core.landmines.getString(chunkpath + "." + dlocpath + ".DISPLAYNAME.data")));
        try {
            ArrayList<String> lore = new ArrayList<String>((ArrayList)Core.landmines.get(chunkpath + "." + dlocpath + ".LORE.data"));
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                line = ChatColor.translateAlternateColorCodes((char)'&', (String)line);
                lore.set(i, line);
            }
            ism.setLore(lore);
        }
        catch (Exception lore) {
            // empty catch block
        }
        is.setItemMeta(ism);
        if (Core.landmines.getString(chunkpath + "." + dlocpath + ".OWNER.data").equals(e.getPlayer().getName())) {
            Location oneuploc = b.getLocation();
            oneuploc.setY((double)(b.getY() + 1));
            Block oneupblock = oneuploc.getBlock();
            if (oneupblock.getType().toString().toUpperCase().contains("PRESSURE_PLATE")) {
                oneupblock.setType(Material.AIR);
            }
            Core.landmines.remove(chunkpath + "." + dlocpath);
            ch.getWorld().dropItem(b.getLocation(), is);
        } else {
            if (Core.cfg.getBoolean("landmine.minednotowner.prevent")) {
                e.setCancelled(true);
                return;
            }
            if (Core.cfg.getBoolean("landmine.minednotowner.detonate")) {
                this.detonateLandmine(b.getLocation());
            }
        }
    }

    private void detonateLandmine(Location loc) {
        int x = (int)loc.getX();
        int y = (int)loc.getY();
        int z = (int)loc.getZ();
        Block b = loc.getWorld().getBlockAt(x, y - 1, z);
        if (b.getType() == Material.AIR) {
            return;
        }
        Chunk ch = b.getChunk();
        int xch = ch.getX();
        int zch = ch.getZ();
        NamespacedKey key = new NamespacedKey(Core.plugin, x + "/" + (y - 1) + "/" + z + "/owner");
        String dlocpath = x + "/" + (y - 1) + "/" + z + "/";
        String chunkpath = ch.getWorld().getName() + "." + xch + "/" + zch + "/";
        if (Core.landmines.get(chunkpath) != null) {
            Location desiredloc = new Location(loc.getWorld(), (double)x, (double)(y - 20), (double)z);
            ArmorStand as = (ArmorStand)ch.getWorld().spawnEntity(desiredloc, EntityType.ARMOR_STAND);
            as.setVisible(false);
            as.teleport(loc);
            Core.landmines.getSection(chunkpath + "." + dlocpath).keySet().forEach(kkey -> this.transformConfigDataToArmorstand(kkey.replace(".data", "").replace(".type", ""), chunkpath + "." + dlocpath, as));
            Core.landmines.remove(chunkpath + "." + dlocpath);
            effect.geffect(as);
        }
    }

    public static void landmineHiderCaretaker() {
        if (Core.debugMode) {
            messaging.log("Landmine hiding enabled, task will be executed every '" + Core.cfg.getInt("landmine.hiding-refresh-rate") + "' tick(s).");
        }
        new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    Chunk ch = p.getLocation().getChunk();
                    if (Core.landmines.get(ch.getWorld().getName()) == null || Core.landmines.get(ch.getWorld().getName() + "." + ch.getX() + "/" + ch.getZ() + "/") == null) {
                        return;
                    }
                    int xch = ch.getX();
                    int zch = ch.getZ();
                    ArrayList<String> locs = new ArrayList<String>();
                    Core.landmines.getSection(ch.getWorld().getName() + "." + xch + "/" + zch + "/").keySet().forEach(dloc -> locs.add(dloc.toString()));
                    locs.forEach(bloc -> p.sendBlockChange(landmineListener.parseLocation(bloc), Material.AIR.createBlockData()));
                }
            }
        }.runTaskTimer(Core.plugin, 0L, (long)Core.cfg.getInt("landmine.hiding-refresh-rate"));
    }

    private void transformConfigDataToArmorstand(String key, String dloc, ArmorStand as) {
        try {
            String stype = Core.landmines.getString(dloc + "." + key + ".type");
            NamespacedKey theKey = new NamespacedKey(Core.plugin, key);
            PersistentDataContainer ascont = as.getPersistentDataContainer();
            switch (stype) {
                case "NBTTagInt": {
                    ascont.set(theKey, PersistentDataType.INTEGER, (Object)Core.landmines.getInt(dloc + "." + key + ".data"));
                    break;
                }
                case "NBTTagDouble": {
                    ascont.set(theKey, PersistentDataType.DOUBLE, (Object)Core.landmines.getDouble(dloc + "." + key + ".data"));
                    break;
                }
                case "NBTTagString": {
                    ascont.set(theKey, PersistentDataType.STRING, (Object)Core.landmines.getString(dloc + "." + key + ".data"));
                    break;
                }
                case "NBTTagByte": {
                    ascont.set(theKey, PersistentDataType.STRING, (Object)(Core.landmines.getBoolean(dloc + "." + key + ".data") + ""));
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void transformConfigDataToNBTItem(NBTItem i, String key, String dloc) {
        NamespacedKey theKey = new NamespacedKey(Core.plugin, key);
        String type = Core.landmines.getString(dloc + "." + key + ".type");
        switch (key) {
            case "OWNER": 
            case "LORE": 
            case "DISPLAYNAME": 
            case "MATERIAL": {
                return;
            }
        }
        switch (type) {
            case "NBTTagInt": {
                i.setInteger(key, Core.landmines.getInt(dloc + "." + key + ".data"));
                break;
            }
            case "NBTTagDouble": {
                i.setDouble(key, Core.landmines.getDouble(dloc + "." + key + ".data"));
                break;
            }
            case "NBTTagString": {
                i.setString(key, Core.landmines.getString(dloc + "." + key + ".data"));
                break;
            }
            default: {
                i.setBoolean(key, Core.landmines.getBoolean(dloc + "." + key + ".data"));
            }
        }
    }

    public static void incAmountDatacontainer(boolean increment, PersistentDataContainer dataContainer) {
        NamespacedKey key = new NamespacedKey(Core.plugin, "LANDMINE_AMOUNT");
        int landmine_amount = 0;
        if (dataContainer.has(key, PersistentDataType.INTEGER)) {
            landmine_amount += ((Integer)dataContainer.get(key, PersistentDataType.INTEGER)).intValue();
        }
        if (increment) {
            ++landmine_amount;
        } else if (--landmine_amount <= 0) {
            dataContainer.remove(key);
            return;
        }
        dataContainer.set(key, PersistentDataType.INTEGER, (Object)landmine_amount);
    }

    public static Location parseLocation(String locationString) {
        int z;
        int y;
        int x;
        String[] coordinates = (locationString = locationString.trim().replaceAll("^/|/$", "")).split("/");
        if (coordinates.length != 4) {
            throw new IllegalArgumentException("Invalid location string: " + locationString);
        }
        try {
            x = Integer.parseInt(coordinates[0]);
            y = Integer.parseInt(coordinates[1]) + 1;
            z = Integer.parseInt(coordinates[2]);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid location string: " + locationString, e);
        }
        World w = Bukkit.getWorld((String)coordinates[3]);
        Location location = new Location(w, (double)x, (double)y, (double)z);
        return location;
    }
}

