/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.Grenades.event;

import dev.mrwere.Grenades.Core;
import dev.mrwere.Grenades.nbtapi.nbtapi.NBTItem;
import dev.mrwere.Grenades.utils.effect;
import dev.mrwere.Grenades.utils.helpers.antigrief;
import dev.mrwere.Grenades.utils.messaging;
import dev.mrwere.Grenades.utils.validator;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class interact
implements Listener {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @EventHandler(priority=EventPriority.HIGH)
    private void interact(PlayerInteractEvent e) {
        if (!validator.isValid(e.getPlayer().getInventory().getItemInMainHand())) {
            return;
        }
        if (!e.getAction().toString().contains("RIGHT_CLICK")) {
            return;
        }
        final Player p = e.getPlayer();
        e.setCancelled(true);
        Core.cooldown.putIfAbsent(p, false);
        if (Core.cooldown.get(p).booleanValue() && !p.hasPermission("grenades.cooldown.bypass")) {
            if (Core.cfg.getBoolean("cooldown.notify")) {
                p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)messaging.whisperback("oncooldown", p)));
            }
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask(Core.plugin, new Runnable(){

                @Override
                public void run() {
                    Core.cooldown.put(p, false);
                }
            }, (long)Core.cfg.getInt("cooldown.time"));
            return;
        }
        int amount = 1;
        ItemStack itemInMainHand = p.getInventory().getItemInMainHand();
        amount = itemInMainHand.getAmount();
        if (amount < 1) {
            itemInMainHand.setAmount(1);
        }
        NBTItem nbti = new NBTItem(itemInMainHand);
        Location desiredloc = p.getLocation();
        if (nbti.getBoolean("ISLANDMINE").booleanValue() && Core.cfg.getBoolean("landmine.enabled")) {
            Block block = e.getClickedBlock();
            if (block == null) {
                messaging.whisper("landmine.noblockinsight", p);
                return;
            }
            Location oneuploc = block.getLocation();
            oneuploc.setY((double)(block.getY() + 1));
            if (oneuploc.getBlock().getType() != Material.AIR) {
                messaging.whisper("landmine.nospaceforlandmine", p);
                return;
            }
            if (!antigrief.canDestroyThatBlock(p, block).booleanValue()) return;
            String xyzloc = block.getX() + "/" + block.getY() + "/" + block.getZ() + "/";
            Chunk ch = block.getChunk();
            int xch = ch.getX();
            int zch = ch.getZ();
            String cfgsection = block.getWorld().getName() + "." + xch + "/" + zch + "/";
            nbti.getKeys().forEach(key -> this.registerLandmine(cfgsection, xyzloc, nbti, (String)key));
            Core.landmines.set(cfgsection + "." + xyzloc + ".LORE.data", Objects.requireNonNull(Objects.requireNonNull(nbti.getItem().getItemMeta()).getLore()));
            Core.landmines.set(cfgsection + "." + xyzloc + ".DISPLAYNAME.data", nbti.getItem().getItemMeta().getDisplayName().replaceAll("\u00a7", "&"));
            Core.landmines.set(cfgsection + "." + xyzloc + ".MATERIAL.data", nbti.getItem().getType().toString());
            Core.landmines.set(cfgsection + "." + xyzloc + ".OWNER.data", e.getPlayer().getName());
            messaging.whisper("landmine.registered", p);
            p.sendMessage(xyzloc);
            oneuploc.getBlock().setType(Material.OAK_PRESSURE_PLATE);
        } else {
            desiredloc.setY(p.getLocation().getY() - 20.0);
            ArmorStand as = (ArmorStand)p.getWorld().spawnEntity(desiredloc, EntityType.ARMOR_STAND);
            as.setVisible(false);
            as.teleport(p.getEyeLocation());
            as.setVelocity(p.getLocation().getDirection().multiply(Core.cfg.getDouble("grenade-velocity")));
            nbti.setString("DAITEM", nbti.getItem().getType().toString());
            nbti.setString("THROWER", e.getPlayer().getName());
            nbti.getKeys().forEach(key -> this.transformItemToArmorstand(as, nbti, (String)key, nbti.getType((String)key).toString()));
            effect.geffect(as);
        }
        Core.cooldown.put(p, true);
        itemInMainHand.setAmount(amount - 1);
    }

    private void registerLandmine(String chunkloc, String dloc, NBTItem i, String key) {
        String type = i.getType(key).toString();
        if (type.equals("NBTTagCompound")) {
            return;
        }
        Core.landmines.set(chunkloc + "." + dloc + "." + key + ".type", type);
        switch (type) {
            case "NBTTagInt": {
                Core.landmines.set(chunkloc + "." + dloc + "." + key + ".data", i.getInteger(key));
                break;
            }
            case "NBTTagDouble": {
                Core.landmines.set(chunkloc + "." + dloc + "." + key + ".data", i.getDouble(key));
                break;
            }
            case "NBTTagByte": {
                Core.landmines.set(chunkloc + "." + dloc + "." + key + ".data", i.getBoolean(key).toString());
                break;
            }
            default: {
                String s = i.getString(key);
                if (s == null) break;
                Core.landmines.set(chunkloc + "." + dloc + "." + key + ".data", s);
            }
        }
    }

    private void transformDataToContainer(PersistentDataContainer container, NBTItem i, String key, String type) {
        NamespacedKey theKey = new NamespacedKey(Core.plugin, key);
        switch (type) {
            case "NBTTagInt": {
                container.set(theKey, PersistentDataType.INTEGER, (Object)i.getInteger(key));
                break;
            }
            case "NBTTagDouble": {
                container.set(theKey, PersistentDataType.DOUBLE, (Object)i.getDouble(key));
                break;
            }
            case "NBTTagString": {
                container.set(theKey, PersistentDataType.STRING, (Object)i.getString(key));
                break;
            }
            default: {
                container.set(theKey, PersistentDataType.STRING, (Object)i.getBoolean(key).toString());
            }
        }
    }

    private void transformItemToArmorstand(ArmorStand as, NBTItem i, String key, String type) {
        this.transformDataToContainer(as.getPersistentDataContainer(), i, key, type);
    }

    private void transformDataToChunk(Block block, NBTItem i, String key, String type) {
        this.transformDataToContainer(block.getChunk().getPersistentDataContainer(), i, key, type);
    }
}

