/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.util;

import dev.mrwere.storage.storage.internal.exceptions.SimplixValidationException;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import lombok.NonNull;

public final class Valid {
    public static void error(Throwable cause, String ... messages) {
        throw new SimplixValidationException(cause, messages);
    }

    public static void error(String ... errorMessage) {
        throw new SimplixValidationException(errorMessage);
    }

    public static void checkBoolean(boolean condition) {
        Valid.checkBoolean(condition, "Valid.checkBoolean(): Condition is False.");
    }

    public static void checkBoolean(boolean condition, String ... errorMessage) {
        if (!condition) {
            throw new SimplixValidationException(errorMessage);
        }
    }

    public static <T> void checkEqualityNull(@NonNull T first, T second) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        Valid.checkBoolean(first.equals(second), "Valid.checkEquality(): first and second must be equal");
    }

    public static <T> void checkEquality(@NonNull T first, T second, String ... messages) {
        if (first == null) {
            throw new NullPointerException("first is marked non-null but is null");
        }
        Valid.checkBoolean(first.equals(second), messages);
    }

    public static <T> T notNull(@Nullable T object) {
        return Valid.notNull(object, "Valid.notNull(): Validated Object is null");
    }

    public static <T> T notNull(@Nullable T object, String ... message) {
        if (object != null) {
            return object;
        }
        throw new SimplixValidationException(message);
    }

    private Valid() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

