/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage;

import dev.mrwere.storage.storage.internal.FileData;
import dev.mrwere.storage.storage.internal.FileType;
import dev.mrwere.storage.storage.internal.FlatFile;
import dev.mrwere.storage.storage.internal.editor.toml.TomlManager;
import dev.mrwere.storage.storage.internal.settings.ReloadSettings;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import dev.mrwere.storage.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import lombok.NonNull;

public class Toml
extends FlatFile {
    public Toml(@NonNull Toml toml) {
        super(toml.getFile());
        if (toml == null) {
            throw new NullPointerException("toml is marked non-null but is null");
        }
        this.fileData = toml.getFileData();
        this.pathPrefix = toml.getPathPrefix();
    }

    public Toml(String name, String path) {
        this(name, path, null);
    }

    public Toml(String name, String path, InputStream inputStream) {
        this(name, path, inputStream, null, null);
    }

    public Toml(@NonNull String name, @NonNull String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable Consumer<FlatFile> reloadConsumer) {
        super(name, path, FileType.TOML, reloadConsumer);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (this.create() && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        this.forceReload();
    }

    public Toml(File file) {
        super(file, FileType.TOML);
        this.create();
        this.forceReload();
    }

    @Override
    protected final Map<String, Object> readToMap() throws IOException {
        return TomlManager.read(this.getFile());
    }

    @Override
    protected final void write(FileData data) {
        try {
            TomlManager.write(data.toMap(), this.getFile());
        }
        catch (IOException ioException) {
            System.err.println("Exception while writing fileData to file '" + this.getName() + "'");
            System.err.println("In '" + FileUtils.getParentDirPath(this.file) + "'");
            ioException.printStackTrace();
        }
    }
}

