/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.shaded.esotericsoftware.yamlbeans;

public class Version {
    public static final Version DEFAULT_VERSION = new Version(1, 1);
    public final int major;
    public final int minor;

    public Version(String value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null.");
        }
        int dotIndex = value.indexOf(46);
        if (dotIndex == -1) {
            throw new IllegalArgumentException("value must contain a period: " + value);
        }
        this.major = Integer.parseInt(value.substring(0, dotIndex));
        this.minor = Integer.parseInt(value.substring(dotIndex + 1));
    }

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(int minor, int major) {
        return this.minor == minor && this.major == major;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }
}

