/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage.shaded.esotericsoftware.yamlbeans;

import dev.mrwere.storage.storage.shaded.esotericsoftware.yamlbeans.DeferredConstruction;
import dev.mrwere.storage.storage.shaded.esotericsoftware.yamlbeans.YamlConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Beans {
    private Beans() {
    }

    public static boolean isScalar(Class c) {
        return c.isPrimitive() || c == String.class || c == Integer.class || c == Boolean.class || c == Float.class || c == Long.class || c == Double.class || c == Short.class || c == Byte.class || c == Character.class;
    }

    public static DeferredConstruction getDeferredConstruction(Class type, YamlConfig config) {
        YamlConfig.ConstructorParameters parameters = config.readConfig.constructorParameters.get(type);
        if (parameters != null) {
            return new DeferredConstruction(parameters.constructor, parameters.parameterNames);
        }
        try {
            Class<?> constructorProperties = Class.forName("java.beans.ConstructorProperties");
            for (Constructor<?> typeConstructor : type.getConstructors()) {
                Object annotation = typeConstructor.getAnnotation(constructorProperties);
                if (annotation == null) continue;
                String[] parameterNames = (String[])constructorProperties.getMethod("value", new Class[0]).invoke(annotation, (Object[])null);
                return new DeferredConstruction(typeConstructor, parameterNames);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object createObject(Class type, boolean privateConstructors) throws InvocationTargetException {
        Constructor<Object> constructor = null;
        for (Constructor<?> typeConstructor : type.getConstructors()) {
            if (typeConstructor.getParameterTypes().length != 0) continue;
            constructor = typeConstructor;
            break;
        }
        if (constructor == null && privateConstructors) {
            try {
                constructor = type.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (constructor == null) {
            try {
                if (List.class.isAssignableFrom(type)) {
                    constructor = ArrayList.class.getConstructor(new Class[0]);
                } else if (Set.class.isAssignableFrom(type)) {
                    constructor = HashSet.class.getConstructor(new Class[0]);
                } else if (Map.class.isAssignableFrom(type)) {
                    constructor = HashMap.class.getConstructor(new Class[0]);
                }
            }
            catch (Exception ex) {
                throw new InvocationTargetException(ex, "Error getting constructor for class: " + type.getName());
            }
        }
        if (constructor == null) {
            throw new InvocationTargetException(null, "Unable to find a no-arg constructor for class: " + type.getName());
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new InvocationTargetException(ex, "Error constructing instance of class: " + type.getName());
        }
    }

    public static Set<Property> getProperties(Class type, boolean beanProperties, boolean privateFields, YamlConfig config) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        Class[] noArgs = new Class[]{};
        Class[] oneArg = new Class[1];
        LinkedHashSet<Property> properties = config.writeConfig.keepBeanPropertyOrder ? new LinkedHashSet() : new TreeSet();
        for (Field field : Beans.getAllFields(type)) {
            int modifiers;
            String name = field.getName();
            if (beanProperties) {
                DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, config);
                boolean constructorProperty = deferredConstruction != null && deferredConstruction.hasParameter(name);
                String nameUpper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                Method getMethod = null;
                Method setMethod = null;
                try {
                    oneArg[0] = field.getType();
                    setMethod = type.getMethod("set" + nameUpper, oneArg);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    getMethod = type.getMethod("get" + nameUpper, noArgs);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (getMethod == null && (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE))) {
                    try {
                        getMethod = type.getMethod("is" + nameUpper, noArgs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (getMethod != null && (setMethod != null || constructorProperty)) {
                    properties.add(new MethodProperty(name, setMethod, getMethod));
                    continue;
                }
            }
            if (Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers) || !Modifier.isPublic(modifiers) && !privateFields) continue;
            try {
                field.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            properties.add(new FieldProperty(field));
        }
        return properties;
    }

    private static String toJavaIdentifier(String name) {
        StringBuilder buffer = new StringBuilder();
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static Property getProperty(Class type, String name, boolean beanProperties, boolean privateFields, YamlConfig config) {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null.");
        }
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty.");
        }
        name = Beans.toJavaIdentifier(name);
        if (beanProperties) {
            DeferredConstruction deferredConstruction = Beans.getDeferredConstruction(type, config);
            boolean constructorProperty = deferredConstruction != null && deferredConstruction.hasParameter(name);
            String nameUpper = Character.toUpperCase(name.charAt(0)) + name.substring(1);
            Method getMethod = null;
            try {
                getMethod = type.getMethod("get" + nameUpper, new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (getMethod == null) {
                try {
                    getMethod = type.getMethod("is" + nameUpper, new Class[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (getMethod != null) {
                Method setMethod = null;
                try {
                    setMethod = type.getMethod("set" + nameUpper, getMethod.getReturnType());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (getMethod != null && (setMethod != null || constructorProperty)) {
                    return new MethodProperty(name, setMethod, getMethod);
                }
            }
        }
        for (Field field : Beans.getAllFields(type)) {
            int modifiers;
            if (!field.getName().equals(name) || Modifier.isStatic(modifiers = field.getModifiers()) || Modifier.isTransient(modifiers) || !Modifier.isPublic(modifiers) && !privateFields) continue;
            try {
                field.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new FieldProperty(field);
        }
        return null;
    }

    private static ArrayList<Field> getAllFields(Class type) {
        ArrayList classes = new ArrayList();
        for (Class nextClass = type; nextClass != null && nextClass != Object.class; nextClass = nextClass.getSuperclass()) {
            classes.add(nextClass);
        }
        ArrayList<Field> allFields = new ArrayList<Field>();
        for (int i = classes.size() - 1; i >= 0; --i) {
            Collections.addAll(allFields, ((Class)classes.get(i)).getDeclaredFields());
        }
        return allFields;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Property
    implements Comparable<Property> {
        private final Class declaringClass;
        private final String name;
        private final Class type;
        private final Class elementType;

        Property(Class declaringClass, String name, Class type, Type genericType) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
            this.elementType = this.getElementTypeFromGenerics(genericType);
        }

        private Class getElementTypeFromGenerics(Type type) {
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            Type rawType;
            if (type instanceof ParameterizedType && (this.isCollection(rawType = (parameterizedType = (ParameterizedType)type).getRawType()) || this.isMap(rawType)) && (actualTypeArguments = parameterizedType.getActualTypeArguments()).length > 0) {
                Type cType = actualTypeArguments[actualTypeArguments.length - 1];
                if (cType instanceof Class) {
                    return (Class)cType;
                }
                if (cType instanceof WildcardType) {
                    WildcardType t = (WildcardType)cType;
                    Type bound = t.getUpperBounds()[0];
                    return bound instanceof Class ? (Class)bound : null;
                }
                if (cType instanceof ParameterizedType) {
                    ParameterizedType t = (ParameterizedType)cType;
                    Type rt = t.getRawType();
                    return rt instanceof Class ? (Class)rt : null;
                }
            }
            return null;
        }

        private boolean isMap(Type type) {
            return Map.class.isAssignableFrom((Class)type);
        }

        private boolean isCollection(Type type) {
            return Collection.class.isAssignableFrom((Class)type);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.declaringClass == null ? 0 : this.declaringClass.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.declaringClass == null ? other.declaringClass != null : !this.declaringClass.equals(other.declaringClass)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
                return false;
            }
            return !(this.elementType == null ? other.elementType != null : !this.elementType.equals(other.elementType));
        }

        public Class getDeclaringClass() {
            return this.declaringClass;
        }

        public Class getElementType() {
            return this.elementType;
        }

        public Class getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(Property o) {
            int comparison = this.name.compareTo(o.name);
            if (comparison != 0) {
                if (this.name.equals("id")) {
                    return -1;
                }
                if (o.name.equals("id")) {
                    return 1;
                }
                if (this.name.equals("name")) {
                    return -1;
                }
                if (o.name.equals("name")) {
                    return 1;
                }
            }
            return comparison;
        }

        public abstract void set(Object var1, Object var2) throws Exception;

        public abstract Object get(Object var1) throws Exception;
    }

    public static class FieldProperty
    extends Property {
        private final Field field;

        public FieldProperty(Field field) {
            super(field.getDeclaringClass(), field.getName(), field.getType(), field.getGenericType());
            this.field = field;
        }

        public void set(Object object, Object value) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, value);
                return;
            }
            this.field.set(object, value);
        }

        public Object get(Object object) throws Exception {
            return this.field.get(object);
        }
    }

    public static class MethodProperty
    extends Property {
        private final Method setMethod;
        private final Method getMethod;

        public MethodProperty(String name, Method setMethod, Method getMethod) {
            super(getMethod.getDeclaringClass(), name, getMethod.getReturnType(), getMethod.getGenericReturnType());
            this.setMethod = setMethod;
            this.getMethod = getMethod;
        }

        public void set(Object object, Object value) throws Exception {
            if (object instanceof DeferredConstruction) {
                ((DeferredConstruction)object).storeProperty(this, value);
                return;
            }
            this.setMethod.invoke(object, value);
        }

        public Object get(Object object) throws Exception {
            return this.getMethod.invoke(object, new Object[0]);
        }
    }
}

