/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage;

import dev.mrwere.storage.storage.internal.FileData;
import dev.mrwere.storage.storage.internal.FileType;
import dev.mrwere.storage.storage.internal.FlatFile;
import dev.mrwere.storage.storage.internal.editor.yaml.SimpleYamlReader;
import dev.mrwere.storage.storage.internal.editor.yaml.SimpleYamlWriter;
import dev.mrwere.storage.storage.internal.editor.yaml.YamlEditor;
import dev.mrwere.storage.storage.internal.editor.yaml.YamlParser;
import dev.mrwere.storage.storage.internal.settings.ConfigSettings;
import dev.mrwere.storage.storage.internal.settings.DataType;
import dev.mrwere.storage.storage.internal.settings.ReloadSettings;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import dev.mrwere.storage.storage.util.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class Yaml
extends FlatFile {
    protected final InputStream inputStream;
    protected final YamlEditor yamlEditor;
    protected final YamlParser parser;
    private ConfigSettings configSettings = ConfigSettings.SKIP_COMMENTS;

    public Yaml(@NonNull Yaml yaml) {
        super(yaml.getFile());
        if (yaml == null) {
            throw new NullPointerException("yaml is marked non-null but is null");
        }
        this.fileData = yaml.getFileData();
        this.yamlEditor = yaml.getYamlEditor();
        this.parser = yaml.getParser();
        this.configSettings = yaml.getConfigSettings();
        this.inputStream = yaml.getInputStream().orElse(null);
        this.pathPrefix = yaml.getPathPrefix();
    }

    public Yaml(String name, @Nullable String path) {
        this(name, path, null, null, null, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream) {
        this(name, path, inputStream, null, null, null);
    }

    public Yaml(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings, @Nullable ConfigSettings configSettings, @Nullable DataType dataType) {
        super(name, path, FileType.YAML);
        this.inputStream = inputStream;
        if (this.create() && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        this.yamlEditor = new YamlEditor(this.file);
        this.parser = new YamlParser(this.yamlEditor);
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        if (configSettings != null) {
            this.configSettings = configSettings;
        }
        this.dataType = dataType != null ? dataType : DataType.forConfigSetting(configSettings);
        this.forceReload();
    }

    public Yaml(File file) {
        this(file.getName(), FileUtils.getParentDirPath(file));
    }

    public Yaml addDefaultsFromInputStream() {
        return this.addDefaultsFromInputStream(this.getInputStream().orElse(null));
    }

    public Yaml addDefaultsFromInputStream(@Nullable InputStream inputStream) {
        this.reloadIfNeeded();
        if (inputStream == null) {
            return this;
        }
        try {
            Map<String, Object> data = new SimpleYamlReader(new InputStreamReader(inputStream)).readToMap();
            FileData newData = new FileData(data, DataType.UNSORTED);
            for (String key : newData.keySet()) {
                if (this.fileData.containsKey(key)) continue;
                this.fileData.insert(key, newData.get(key));
            }
            this.write();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    @Override
    protected Map<String, Object> readToMap() throws IOException {
        SimpleYamlReader reader = new SimpleYamlReader(new FileReader(this.getFile()));
        try {
            Map<String, Object> map = reader.readToMap();
            return map;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Override
    protected void write(FileData data) throws IOException {
        if (!ConfigSettings.PRESERVE_COMMENTS.equals((Object)this.configSettings)) {
            this.write0(this.fileData);
            return;
        }
        List<String> unEdited = this.yamlEditor.read();
        this.write0(this.fileData);
        this.yamlEditor.write(this.parser.parseLines(unEdited, this.yamlEditor.readKeys()));
    }

    private void write0(FileData fileData) throws IOException {
        SimpleYamlWriter writer = new SimpleYamlWriter(this.file);
        try {
            writer.write(fileData.toMap());
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }

    public final List<String> getHeader() {
        return this.yamlEditor.readHeader();
    }

    public final void setHeader(List<String> header) {
        this.yamlEditor.setHeader(header);
    }

    public final void setHeader(String ... header) {
        this.setHeader(Arrays.asList(header));
    }

    public final void addHeader(List<String> toAdd) {
        this.yamlEditor.addHeader(toAdd);
    }

    public final void addHeader(String ... header) {
        this.addHeader(Arrays.asList(header));
    }

    public final Optional<InputStream> getInputStream() {
        return Optional.ofNullable(this.inputStream);
    }

    public YamlEditor getYamlEditor() {
        return this.yamlEditor;
    }

    public YamlParser getParser() {
        return this.parser;
    }

    public ConfigSettings getConfigSettings() {
        return this.configSettings;
    }

    public void setConfigSettings(ConfigSettings configSettings) {
        this.configSettings = configSettings;
    }
}

