/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.storage.storage;

import dev.mrwere.storage.storage.internal.FileData;
import dev.mrwere.storage.storage.internal.FileType;
import dev.mrwere.storage.storage.internal.FlatFile;
import dev.mrwere.storage.storage.internal.settings.ReloadSettings;
import dev.mrwere.storage.storage.shaded.jetbrains.annotations.Nullable;
import dev.mrwere.storage.storage.shaded.json.JSONObject;
import dev.mrwere.storage.storage.shaded.json.JSONTokener;
import dev.mrwere.storage.storage.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Json
extends FlatFile {
    public Json(Json json) {
        super(json.getFile(), json.fileType);
        this.fileData = json.getFileData();
        this.pathPrefix = json.getPathPrefix();
    }

    public Json(String name, String path) {
        this(name, path, (InputStream)null);
    }

    public Json(String name, String path, InputStream inputStream) {
        this(name, path, inputStream, null);
    }

    public Json(String name, @Nullable String path, @Nullable InputStream inputStream, @Nullable ReloadSettings reloadSettings) {
        super(name, path, FileType.JSON);
        if ((this.create() || this.file.length() == 0L) && inputStream != null) {
            FileUtils.writeToFile(this.file, inputStream);
        }
        if (reloadSettings != null) {
            this.reloadSettings = reloadSettings;
        }
        this.forceReload();
    }

    public Json(File file) {
        super(file, FileType.JSON);
        this.create();
        this.forceReload();
    }

    public Map getMap(String key) {
        String finalKey;
        String string = finalKey = this.pathPrefix == null ? key : this.pathPrefix + "." + key;
        if (!this.contains(finalKey)) {
            return new HashMap();
        }
        Object map = this.get(key);
        if (map instanceof Map) {
            return (Map)this.fileData.get(key);
        }
        if (map instanceof JSONObject) {
            return ((JSONObject)map).toMap();
        }
        throw new IllegalArgumentException("ClassCastEx: Json contains key: '" + key + "' but it is not a Map");
    }

    @Override
    protected Map<String, Object> readToMap() throws IOException {
        if (this.file.length() == 0L) {
            Files.write(this.file.toPath(), Collections.singletonList("{}"), new OpenOption[0]);
        }
        JSONTokener jsonTokener = new JSONTokener(FileUtils.createInputStream(this.file));
        return new JSONObject(jsonTokener).toMap();
    }

    @Override
    protected void write(FileData data) throws IOException {
        Writer writer = FileUtils.createWriter(this.file);
        try {
            writer.write(data.toJsonObject().toString(3));
            writer.flush();
        }
        finally {
            if (Collections.singletonList(writer).get(0) != null) {
                writer.close();
            }
        }
    }
}

