/*
 * Decompiled with CFR 0.152.
 */
package dev.mrwere.Grenades.utils.helpers;

import dev.mrwere.Grenades.Core;
import dev.mrwere.Grenades.command.getOrSetRecipe;
import dev.mrwere.Grenades.nbtapi.nbtapi.NBTItem;
import dev.mrwere.Grenades.utils.messaging;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;

public class recipeHelper {
    public static void preventItemTransfer(InventoryClickEvent e) {
        InventoryAction a = e.getAction();
        Player p = (Player)e.getWhoClicked();
        if (getOrSetRecipe.reditors.get(p) != null) {
            int s = e.getRawSlot();
            if (e.getView().getTopInventory().equals(e.getClickedInventory())) {
                switch (s) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 22: 
                    case 23: 
                    case 24: {
                        break;
                    }
                    default: {
                        e.setCancelled(true);
                    }
                }
            }
        } else if (!a.equals((Object)InventoryAction.PICKUP_ALL)) {
            e.setCancelled(true);
        }
    }

    public static boolean isRecipeVanilla(ShapedRecipe r) {
        if (Core.cfg.getBoolean("no-vanilla-recipes")) {
            return false;
        }
        return r.getKey().getNamespace().equalsIgnoreCase("minecraft");
    }

    public static void saveItemToFile(String PATH, NBTItem i) {
        i.getKeys().forEach(key -> {
            String type = i.getType((String)key).toString().toUpperCase();
            String finalPath = PATH + ".nbt." + type + "." + key;
            switch (type) {
                case "NBTTAGINT": {
                    Core.recipes.set(finalPath, i.getInteger((String)key));
                    break;
                }
                case "NBTTAGDOUBLE": {
                    Core.recipes.set(finalPath, i.getDouble((String)key));
                    break;
                }
                case "NBTTAGSTRING": {
                    Core.recipes.set(finalPath, i.getString((String)key));
                    break;
                }
                default: {
                    Core.recipes.set(finalPath, i.getBoolean((String)key));
                }
            }
        });
        String fpath = PATH + ".item.";
        ItemMeta ism = i.getItem().getItemMeta();
        Core.recipes.set(fpath + "display-name", ism.getDisplayName().replace('\u00a7', '&'));
        ArrayList<String> dalore = new ArrayList<String>();
        for (int o = 0; o < ism.getLore().size(); ++o) {
            dalore.add(((String)ism.getLore().get(o)).replace('\u00a7', '&'));
        }
        Core.recipes.set(fpath + "lore", dalore);
        Core.recipes.set(fpath + "material", i.getItem().getType());
        Core.recipes.set(fpath + "amount", i.getItem().getAmount());
    }

    public static void registerRecipe(int rID) {
        ShapedRecipe r = new ShapedRecipe(new NamespacedKey(Core.plugin, "rid" + rID), recipeHelper.getItemFromFile(rID + ".result").getItem());
        r.shape(new String[]{"qwe", "asd", "yxc"});
        for (int i = 0; i != 9; ++i) {
            char d = recipeHelper.transformIntToChar(i);
            Material potato = Material.AIR;
            if (Core.recipes.get(rID + ".recipe.workbench.slot." + i) != null && !Core.recipes.getString(rID + ".recipe.workbench.slot." + i).equalsIgnoreCase("AIR")) {
                potato = Material.valueOf((String)Core.recipes.getString(rID + ".recipe.workbench.slot." + i));
            }
            r.setIngredient(d, potato);
        }
        Core.plugin.getServer().addRecipe((Recipe)r);
        if (Core.debugMode) {
            messaging.log("Registered recipe: rid" + rID);
        }
    }

    public static NBTItem getItemFromFile(String PATH) {
        NBTItem daitem = new NBTItem(new ItemStack(Material.DIRT));
        Core.recipes.getSection(PATH + ".nbt").keySet().forEach(section -> {
            String[] p = section.replace(".", ";;").split(";;");
            String type = p[0];
            String key = p[1];
            String almostFinalpath = PATH + ".nbt." + type;
            String finalPath = almostFinalpath + "." + key;
            switch (type) {
                case "NBTTAGINT": {
                    daitem.setInteger(key, Core.recipes.getInt(finalPath));
                    break;
                }
                case "NBTTAGDOUBLE": {
                    daitem.setDouble(key, Core.recipes.getDouble(finalPath));
                    break;
                }
                case "NBTTAGSTRING": {
                    daitem.setString(key, Core.recipes.getString(finalPath));
                    break;
                }
                case "NBTTAGBYTE": {
                    daitem.setBoolean(key, Core.recipes.getBoolean(finalPath));
                    break;
                }
                case "NBTTAGCOMPOUND": {
                    daitem.setObject(key, Core.recipes.get(finalPath));
                    break;
                }
                default: {
                    messaging.log("Unrecognized nbt while getting item from file: " + type);
                }
            }
        });
        String fpath = PATH + ".item.";
        ItemMeta ism = daitem.getItem().getItemMeta();
        ism.setDisplayName(Core.recipes.getString(fpath + "display-name").replaceAll("&", "\u00a7"));
        ArrayList<String> dalore = new ArrayList<String>();
        for (int i = 0; i < Core.recipes.getList(fpath + "lore").size(); ++i) {
            dalore.add(Core.recipes.getList(fpath + "lore").get(i).toString().replaceAll("&", "\u00a7"));
        }
        ism.setLore(dalore);
        daitem.getItem().setItemMeta(ism);
        daitem.getItem().setType(Material.valueOf((String)Core.recipes.getString(fpath + "material")));
        daitem.getItem().setAmount(Core.recipes.getInt(fpath + "amount"));
        return daitem;
    }

    public static void applyIngredient(String PATH, int slot, ItemStack ingredient) {
        int workbenchslot = 10;
        switch (slot) {
            case 4: {
                workbenchslot = 0;
                break;
            }
            case 5: {
                workbenchslot = 1;
                break;
            }
            case 6: {
                workbenchslot = 2;
                break;
            }
            case 13: {
                workbenchslot = 3;
                break;
            }
            case 14: {
                workbenchslot = 4;
                break;
            }
            case 15: {
                workbenchslot = 5;
                break;
            }
            case 22: {
                workbenchslot = 6;
                break;
            }
            case 23: {
                workbenchslot = 7;
                break;
            }
            case 24: {
                workbenchslot = 8;
                break;
            }
            default: {
                return;
            }
        }
        Core.recipes.set(PATH + ".workbench.slot." + workbenchslot, ingredient.getType().toString());
    }

    private static char transformIntToChar(int i) {
        char d = 'a';
        if (i == 0) {
            d = 'q';
        }
        if (i == 1) {
            d = 'w';
        }
        if (i == 2) {
            d = 'e';
        }
        if (i == 3) {
            d = 'a';
        }
        if (i == 4) {
            d = 's';
        }
        if (i == 5) {
            d = 'd';
        }
        if (i == 6) {
            d = 'y';
        }
        if (i == 7) {
            d = 'x';
        }
        if (i == 8) {
            d = 'c';
        }
        return d;
    }
}

