/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.ui;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.PlayerCache;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.BiomeRecipe;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.Util;
import com.wasteofplastic.greenhouses.util.VaultHelper;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GreenhouseCmd
implements CommandExecutor {
    public boolean busyFlag = true;
    private Greenhouses plugin;
    private PlayerCache players;

    public GreenhouseCmd(Greenhouses plugin, PlayerCache players) {
        this.plugin = plugin;
        this.players = players;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] split) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (!Settings.worldName.contains(player.getWorld().getName())) {
            player.sendMessage(ChatColor.RED + Locale.generalnotavailable);
            return true;
        }
        if (!VaultHelper.checkPerm(player, "greenhouses.player")) {
            player.sendMessage(ChatColor.RED + Locale.errornoPermission);
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        switch (split.length) {
            case 0: {
                Greenhouse greenhouseInNow = this.players.getInGreenhouse(player);
                if (greenhouseInNow == null || greenhouseInNow.getOwner().equals(playerUUID)) {
                    player.openInventory(this.plugin.getRecipeInv(player));
                    return true;
                }
                player.sendMessage(ChatColor.RED + Locale.errornotowner);
                return true;
            }
            case 1: {
                if (split[0].equalsIgnoreCase("help")) {
                    player.sendMessage(ChatColor.GREEN + Locale.generalgreenhouses + " " + this.plugin.getDescription().getVersion() + " " + Locale.helphelp + ":");
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " : " + ChatColor.WHITE + Locale.helpopengui);
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " make: " + ChatColor.WHITE + Locale.helpmake);
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " remove: " + ChatColor.WHITE + Locale.helpremove);
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " info: " + ChatColor.WHITE + Locale.helpinfo);
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " list: " + ChatColor.WHITE + Locale.helplist);
                    player.sendMessage(ChatColor.YELLOW + "/" + label + " recipe <number>: " + ChatColor.WHITE + Locale.helprecipe);
                    return true;
                }
                if (split[0].equalsIgnoreCase("list")) {
                    player.sendMessage(ChatColor.GREEN + Locale.listtitle);
                    player.sendMessage(Locale.listinfo);
                    int index = 0;
                    for (BiomeRecipe br : this.plugin.getBiomeRecipes()) {
                        if (br.getFriendlyName().isEmpty()) {
                            player.sendMessage(ChatColor.YELLOW + Integer.toString(index++) + ": " + Util.prettifyText(br.getBiome().toString()));
                            continue;
                        }
                        player.sendMessage(ChatColor.YELLOW + Integer.toString(index++) + ": " + br.getFriendlyName());
                    }
                    return true;
                }
                if (split[0].equalsIgnoreCase("remove")) {
                    Greenhouse greenhouseNow = this.players.getInGreenhouse(player);
                    if (greenhouseNow != null) {
                        if (greenhouseNow.getOwner().equals(playerUUID)) {
                            player.sendMessage(ChatColor.RED + Locale.errorremoving);
                            this.plugin.removeGreenhouse(greenhouseNow);
                            return true;
                        }
                        player.sendMessage(ChatColor.RED + Locale.errornotyours);
                    } else {
                        player.sendMessage(ChatColor.RED + Locale.errornotinside);
                    }
                    return true;
                }
                if (split[0].equalsIgnoreCase("make")) {
                    Greenhouse greenhouseN = this.players.getInGreenhouse(player);
                    if (greenhouseN != null) {
                        player.sendMessage(ChatColor.RED + Locale.erroralreadyexists);
                        return true;
                    }
                    if (this.plugin.players.isAtLimit(player)) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.infonomore));
                    } else {
                        Greenhouse g = this.plugin.tryToMakeGreenhouse(player);
                        if (g == null) {
                            player.sendMessage(ChatColor.RED + Locale.errornorecipe);
                            return true;
                        }
                    }
                    return true;
                }
                if (!split[0].equalsIgnoreCase("info")) break;
                player.sendMessage(ChatColor.GREEN + ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.infotitle));
                for (String instructions : Locale.infoinstructions) {
                    player.sendMessage(ChatColor.GREEN + ChatColor.translateAlternateColorCodes((char)'&', (String)instructions));
                }
                Greenhouse greenhouseIn = this.players.getInGreenhouse(player);
                if (greenhouseIn != null) {
                    player.sendMessage(ChatColor.GOLD + Locale.infoinfo);
                    player.sendMessage(ChatColor.GREEN + Locale.generalbiome + ": " + Util.prettifyText(greenhouseIn.getBiome().toString()));
                    if (greenhouseIn.getOwner() != null) {
                        Player owner = this.plugin.getServer().getPlayer(greenhouseIn.getOwner());
                        if (owner != null) {
                            player.sendMessage(ChatColor.YELLOW + Locale.generalowner + ": " + owner.getDisplayName() + " (" + owner.getName() + ")");
                        } else {
                            player.sendMessage(ChatColor.YELLOW + Locale.generalowner + ": " + greenhouseIn.getPlayerName());
                        }
                    }
                }
                return true;
            }
            case 2: {
                if (split[0].equalsIgnoreCase("make")) {
                    if (this.players.getInGreenhouse(player) != null) {
                        player.sendMessage(ChatColor.RED + Locale.erroralreadyexists);
                        return true;
                    }
                    if (this.plugin.players.isAtLimit(player)) {
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.infonomore));
                    } else {
                        try {
                            if (NumberUtils.isNumber((String)split[1])) {
                                int recipeNum = Integer.valueOf(split[1]);
                                List<BiomeRecipe> recipeList = this.plugin.getBiomeRecipes();
                                if (recipeNum < 1 || recipeNum > recipeList.size()) {
                                    player.sendMessage(ChatColor.RED + Locale.errornorecipe);
                                    return true;
                                }
                                if (this.plugin.tryToMakeGreenhouse(player, recipeList.get(recipeNum)) == null) {
                                    player.sendMessage(ChatColor.RED + Locale.errornorecipe);
                                    return true;
                                }
                            }
                        }
                        catch (Exception e) {
                            player.sendMessage(ChatColor.RED + Locale.errornorecipe);
                            return true;
                        }
                    }
                    return true;
                }
                if (!split[0].equalsIgnoreCase("recipe")) break;
                int recipeNumber = 0;
                try {
                    recipeNumber = Integer.valueOf(split[1]);
                }
                catch (Exception e) {
                    player.sendMessage(ChatColor.RED + Locale.recipehint);
                    return true;
                }
                List<BiomeRecipe> recipeList = this.plugin.getBiomeRecipes();
                if (recipeNumber < 1 || recipeNumber > recipeList.size()) {
                    player.sendMessage(ChatColor.RED + Locale.recipewrongnumber.replace("[size]", String.valueOf(recipeList.size())));
                    return true;
                }
                BiomeRecipe br = recipeList.get(recipeNumber - 1);
                if (br.getFriendlyName().isEmpty()) {
                    player.sendMessage(ChatColor.GREEN + "[" + Util.prettifyText(br.getBiome().toString()) + " recipe]");
                } else {
                    player.sendMessage(ChatColor.GREEN + "[" + br.getFriendlyName() + " recipe]");
                }
                player.sendMessage(ChatColor.YELLOW + "Biome: " + Util.prettifyText(br.getBiome().toString()));
                if (br.getWaterCoverage() == 0) {
                    player.sendMessage(Locale.recipenowater);
                } else if (br.getWaterCoverage() > 0) {
                    player.sendMessage(Locale.recipewatermustbe.replace("[coverage]", String.valueOf(br.getWaterCoverage())));
                }
                if (br.getIceCoverage() == 0) {
                    player.sendMessage(Locale.recipenoice);
                } else if (br.getIceCoverage() > 0) {
                    player.sendMessage(Locale.recipeicemustbe.replace("[coverage]", String.valueOf(br.getIceCoverage())));
                }
                if (br.getLavaCoverage() == 0) {
                    player.sendMessage(Locale.recipenolava);
                } else if (br.getLavaCoverage() > 0) {
                    player.sendMessage(Locale.recipelavamustbe.replace("[coverage]", String.valueOf(br.getLavaCoverage())));
                }
                List<String> reqBlocks = br.getRecipeBlocks();
                if (reqBlocks.size() > 0) {
                    player.sendMessage(ChatColor.YELLOW + Locale.recipeminimumblockstitle);
                    int index = 1;
                    for (String list : reqBlocks) {
                        player.sendMessage(Locale.lineColor + index++ + ": " + list);
                    }
                } else {
                    player.sendMessage(ChatColor.YELLOW + Locale.recipenootherblocks);
                }
                return true;
            }
        }
        return false;
    }
}

