/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.ui;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.greenhouse.BiomeRecipe;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.Util;
import com.wasteofplastic.greenhouses.util.VaultHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ControlPanel
implements Listener {
    private Greenhouses plugin;
    private HashMap<UUID, HashMap<Integer, BiomeRecipe>> biomePanels = new HashMap();

    public ControlPanel(Greenhouses plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        int slot = event.getRawSlot();
        HashMap<Integer, BiomeRecipe> panel = this.biomePanels.get(player.getUniqueId());
        if (panel == null) {
            return;
        }
        if (inventory.getName().equals(ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.controlpaneltitle))) {
            event.setCancelled(true);
            if (slot < 0) {
                player.closeInventory();
                return;
            }
            if (slot == 0) {
                player.performCommand("greenhouse info");
                player.closeInventory();
                return;
            }
            if (panel.containsKey(slot)) {
                BiomeRecipe biomeRecipe = panel.get(slot);
                Greenhouse oldg = this.plugin.players.getInGreenhouse(player);
                if (oldg != null && !oldg.getOwner().equals(player.getUniqueId())) {
                    player.sendMessage(Locale.errornotyours);
                    player.closeInventory();
                    return;
                }
                if (oldg != null) {
                    this.plugin.removeGreenhouse(oldg);
                }
                if (this.plugin.players.isAtLimit(player)) {
                    player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.infonomore));
                } else {
                    Greenhouse g = this.plugin.tryToMakeGreenhouse(player, biomeRecipe);
                    if (g == null) {
                        player.closeInventory();
                        player.sendMessage(ChatColor.RED + Locale.errornorecipe);
                        return;
                    }
                    player.closeInventory();
                }
            }
        }
    }

    public Inventory getPanel(Player player) {
        HashMap<Integer, BiomeRecipe> store = new HashMap<Integer, BiomeRecipe>();
        int index = 1;
        for (BiomeRecipe br : this.plugin.getBiomeRecipes()) {
            if (!br.getPermission().isEmpty() && !VaultHelper.checkPerm(player, br.getPermission())) continue;
            store.put(index++, br);
        }
        int panelSize = store.size() + 9;
        panelSize -= panelSize % 9;
        Inventory biomePanel = Bukkit.createInventory((InventoryHolder)player, (int)panelSize, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.controlpaneltitle));
        ItemStack item = new ItemStack(Material.THIN_GLASS);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(Locale.generalgreenhouses);
        ArrayList<String> lore = new ArrayList<String>();
        lore.addAll(new ArrayList<String>(Arrays.asList(Locale.infowelcome.split("\\|"))));
        if (this.plugin.players.isAtLimit(player)) {
            lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)Locale.infonomore));
        } else if (this.plugin.players.getRemainingGreenhouses(player) > 0) {
            if (this.plugin.players.getRemainingGreenhouses(player) == 1) {
                lore.addAll(new ArrayList<String>(Arrays.asList(Locale.infoonemore.split("\\|"))));
            } else {
                String temp = Locale.infoyoucanbuild.replace("[number]", String.valueOf(this.plugin.players.getRemainingGreenhouses(player)));
                lore.addAll(new ArrayList<String>(Arrays.asList(temp.split("\\|"))));
            }
        } else {
            lore.addAll(new ArrayList<String>(Arrays.asList(Locale.infounlimited.split("\\|"))));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        biomePanel.setItem(0, item);
        index = 1;
        for (BiomeRecipe br : store.values()) {
            item = new ItemStack(br.getIcon());
            meta = item.getItemMeta();
            if (br.getFriendlyName().isEmpty()) {
                meta.setDisplayName(Util.prettifyText(br.getBiome().toString()));
            } else {
                meta.setDisplayName(br.getFriendlyName());
            }
            lore.clear();
            List<String> reqBlocks = br.getRecipeBlocks();
            if (reqBlocks.size() > 0) {
                lore.add(ChatColor.YELLOW + Locale.recipeminimumblockstitle);
                int i = 1;
                for (String list : reqBlocks) {
                    lore.add(Locale.lineColor + i++ + ": " + list);
                }
            } else {
                lore.add(ChatColor.YELLOW + Locale.recipenootherblocks);
            }
            if (br.getWaterCoverage() == 0) {
                lore.add(Locale.recipenowater);
            } else if (br.getWaterCoverage() > 0) {
                lore.add(Locale.recipewatermustbe.replace("[coverage]", String.valueOf(br.getWaterCoverage())));
            }
            if (br.getIceCoverage() == 0) {
                lore.add(Locale.recipenoice);
            } else if (br.getIceCoverage() > 0) {
                lore.add(Locale.recipeicemustbe.replace("[coverage]", String.valueOf(br.getIceCoverage())));
            }
            if (br.getLavaCoverage() == 0) {
                lore.add(Locale.recipenolava);
            } else if (br.getLavaCoverage() > 0) {
                lore.add(Locale.recipelavamustbe.replace("[coverage]", String.valueOf(br.getLavaCoverage())));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
            biomePanel.setItem(index++, item);
        }
        this.biomePanels.put(player.getUniqueId(), store);
        return biomePanel;
    }
}

