/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.ui;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.PlayerCache;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.VaultHelper;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminCmd
implements CommandExecutor {
    private Greenhouses plugin;
    private PlayerCache players;

    public AdminCmd(Greenhouses greenhouses, PlayerCache players) {
        this.plugin = greenhouses;
        this.players = players;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] split) {
        if (sender instanceof Player && !VaultHelper.checkPerm((Player)sender, "greenhouses.admin")) {
            sender.sendMessage(ChatColor.RED + Locale.errornoPermission);
            return true;
        }
        switch (split.length) {
            case 0: {
                sender.sendMessage(ChatColor.YELLOW + "/gadmin reload:" + ChatColor.WHITE + " " + Locale.adminHelpreload);
                sender.sendMessage(ChatColor.YELLOW + "/gadmin info:" + ChatColor.WHITE + Locale.adminHelpinfo);
                return true;
            }
            case 1: {
                if (split[0].equalsIgnoreCase("reload")) {
                    this.plugin.reloadConfig();
                    this.plugin.loadPluginConfig();
                    this.plugin.loadBiomeRecipes();
                    this.plugin.ecoTick();
                    sender.sendMessage(ChatColor.YELLOW + Locale.reloadconfigReloaded);
                    return true;
                }
                if (split[0].equalsIgnoreCase("info")) {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(ChatColor.RED + Locale.admininfoerror);
                        return true;
                    }
                    Player player = (Player)sender;
                    Greenhouse greenhouse = this.players.getInGreenhouse(player);
                    if (greenhouse == null) {
                        sender.sendMessage(ChatColor.RED + Locale.admininfoerror2);
                        return true;
                    }
                    sender.sendMessage(ChatColor.GREEN + Locale.infoinfo);
                    sender.sendMessage(ChatColor.GREEN + Locale.generalowner + ":" + greenhouse.getPlayerName());
                    sender.sendMessage(ChatColor.GREEN + Locale.admininfoflags);
                    for (String flag : greenhouse.getFlags().keySet()) {
                        sender.sendMessage(flag + ": " + greenhouse.getFlags().get(flag));
                    }
                    return true;
                }
                sender.sendMessage(ChatColor.RED + Locale.errorunknownCommand);
                return false;
            }
            case 2: {
                if (split[0].equalsIgnoreCase("info")) {
                    sender.sendMessage(ChatColor.GREEN + Locale.infoinfo);
                    int index = 0;
                    boolean found = false;
                    for (Greenhouse g : this.plugin.getGreenhouses()) {
                        if (!g.getPlayerName().equalsIgnoreCase(split[1])) continue;
                        if (!found) {
                            sender.sendMessage(ChatColor.GREEN + Locale.generalowner + ":" + g.getPlayerName());
                        }
                        found = true;
                        sender.sendMessage("Greenhouse #" + ++index);
                        sender.sendMessage("Biome: " + g.getBiome().name());
                        sender.sendMessage("Recipe: " + g.getBiomeRecipe().getFriendlyName());
                        sender.sendMessage(g.getWorld().getName());
                        sender.sendMessage(g.getPos1().getBlockX() + ", " + g.getPos1().getBlockZ() + " to " + g.getPos2().getBlockX() + ", " + g.getPos2().getBlockZ());
                        sender.sendMessage("Base at " + g.getPos1().getBlockY());
                        sender.sendMessage("Height = " + g.getHeight());
                        sender.sendMessage("Area = " + g.getArea());
                    }
                    if (found) {
                        if (index == 0) {
                            sender.sendMessage("Player has no greenhouses.");
                        } else {
                            Player player = this.plugin.getServer().getPlayer(split[1]);
                            if (player != null) {
                                sender.sendMessage("Player has " + index + " greenhouses and is allowed to build " + this.plugin.getMaxGreenhouses(player));
                            } else {
                                sender.sendMessage("Player has " + index + " greenhouses. Player is offline.");
                            }
                        }
                    } else {
                        sender.sendMessage(ChatColor.RED + "Cannot find that player. (May not have logged on recently)");
                    }
                    return true;
                }
                sender.sendMessage(ChatColor.RED + Locale.errorunknownCommand);
                return false;
            }
        }
        return false;
    }
}

