/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.listeners;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.PlayerCache;
import com.wasteofplastic.greenhouses.ui.Locale;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class JoinLeaveEvents
implements Listener {
    private Greenhouses plugin;
    private PlayerCache players;

    public JoinLeaveEvents(Greenhouses greenhouses, PlayerCache onlinePlayers) {
        this.plugin = greenhouses;
        this.players = onlinePlayers;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(final PlayerJoinEvent event) {
        Player p = event.getPlayer();
        UUID playerUUID = p.getUniqueId();
        this.plugin.players.addPlayer(p);
        this.plugin.logger(3, "Cached " + p.getName());
        final List<String> messages = this.plugin.getMessages(playerUUID);
        if (!messages.isEmpty()) {
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    event.getPlayer().sendMessage(ChatColor.AQUA + Locale.newsheadline);
                    int i = 1;
                    for (String message : messages) {
                        event.getPlayer().sendMessage(i++ + ": " + message);
                    }
                }
            }, 40L);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.players.removeOnlinePlayer(event.getPlayer());
    }
}

