/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.listeners;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class GreenhouseEvents
implements Listener {
    private final Greenhouses plugin;
    private List<Location> blockedPistons = new ArrayList<Location>();

    public GreenhouseEvents(Greenhouses plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!world.getEnvironment().equals((Object)World.Environment.NETHER) || !Settings.worldName.contains(world.getName())) {
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            Biome biome = event.getClickedBlock().getBiome();
            if (event.getItem() != null && biome != null && event.getItem().getType().equals((Object)Material.WATER_BUCKET) && !biome.equals((Object)Biome.HELL) && !biome.equals((Object)Biome.DESERT) && !biome.equals((Object)Biome.DESERT_HILLS)) {
                event.setCancelled(true);
                event.getClickedBlock().getRelative(event.getBlockFace()).setType(Material.WATER);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onIceBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (!Settings.worldName.contains(world.getName())) {
            return;
        }
        Biome biome = event.getBlock().getBiome();
        if (!(event.getBlock().getWorld().getEnvironment() != World.Environment.NETHER || event.getBlock().getType() != Material.ICE || biome.equals((Object)Biome.HELL) || biome.equals((Object)Biome.DESERT) || biome.equals((Object)Biome.DESERT_HILLS))) {
            event.setCancelled(true);
            event.getBlock().setType(Material.WATER);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent e) {
        if (!Settings.worldName.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        this.plugin.logger(3, "block break");
        Greenhouse g = this.plugin.getInGreenhouse(e.getBlock().getLocation());
        if (g == null) {
            this.plugin.logger(3, "not in greenhouse");
            return;
        }
        if (e.getBlock().getLocation().getBlockY() == g.getHeightY() || g.isAWall(e.getBlock().getLocation())) {
            e.getPlayer().sendMessage(ChatColor.RED + Locale.eventbroke.replace("[biome]", Util.prettifyText(g.getOriginalBiome().toString())));
            e.getPlayer().sendMessage(ChatColor.RED + Locale.eventfix);
            this.plugin.removeGreenhouse(g);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerBlockPlace(BlockPlaceEvent e) {
        if (!Settings.worldName.contains(e.getPlayer().getWorld().getName())) {
            return;
        }
        if (e.getPlayer().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        Greenhouse g = this.plugin.aboveAGreenhouse(e.getBlock().getLocation());
        if (g == null) {
            return;
        }
        e.getPlayer().sendMessage(ChatColor.RED + Locale.eventcannotplace);
        e.getPlayer().sendMessage("Greenhouse is at " + g.getPos1() + " to " + g.getPos2());
        e.setCancelled(true);
    }

    @EventHandler
    public void onPistonPush(BlockPistonExtendEvent e) {
        if (!Settings.worldName.contains(e.getBlock().getWorld().getName())) {
            return;
        }
        if (e.getBlock().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            return;
        }
        Location l = e.getBlock().getLocation();
        if (this.blockedPistons.contains(l)) {
            this.blockedPistons.remove(l);
            e.setCancelled(true);
            return;
        }
        this.plugin.logger(3, "Direction: " + e.getDirection());
        this.plugin.logger(3, "Location of piston block:" + l);
        for (int i = 0; i < 13 && (l = l.getBlock().getRelative(e.getDirection()).getLocation()).getBlock().getType().isSolid(); ++i) {
        }
        this.plugin.logger(3, "Location of end block + 1:" + l);
        if (this.plugin.aboveAGreenhouse(l) == null) {
            return;
        }
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            if (!Settings.worldName.contains(p.getLocation().getWorld().getName()) || !(p.getLocation().distanceSquared(e.getBlock().getLocation()) <= 25.0)) continue;
            p.sendMessage(ChatColor.RED + Locale.eventpistonerror);
            e.setCancelled(true);
            this.blockedPistons.add(e.getBlock().getLocation());
        }
    }
}

