/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.greenhouse;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.greenhouse.Roof;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;

public class Walls {
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int floor;
    private boolean useRoofMaxX;
    private boolean useRoofMinX;
    private boolean useRoofMaxZ;
    private boolean useRoofMinZ;
    private Location roofBlock;
    Location roofHopperLoc = null;
    static final List<Material> wallBlocks = Arrays.asList(Material.HOPPER, Material.GLASS, Material.THIN_GLASS, Material.GLOWSTONE, Material.WOODEN_DOOR, Material.IRON_DOOR_BLOCK, Material.STAINED_GLASS, Material.STAINED_GLASS_PANE);

    public Walls(Greenhouses plugin, Player player, Roof roof) {
        int z;
        int x;
        Location loc = player.getLocation();
        World world = player.getWorld();
        int wallBlockCount = 0;
        int y = roof.getHeight();
        do {
            wallBlockCount = 0;
            for (int x2 = roof.getMinX(); x2 <= roof.getMaxX(); ++x2) {
                for (int z2 = roof.getMinZ(); z2 <= roof.getMaxZ(); ++z2) {
                    if (!wallBlocks.contains(world.getBlockAt(x2, y, z2).getType())) continue;
                    ++wallBlockCount;
                }
            }
        } while (y-- > 0 && wallBlockCount > 0);
        this.floor = y + 1;
        plugin.logger(3, "#1 Floor found at " + this.floor);
        int radiusMinX = 0;
        int radiusMaxX = 0;
        int radiusMinZ = 0;
        int radiusMaxZ = 0;
        boolean stopMinX = false;
        boolean stopMaxX = false;
        boolean stopMinZ = false;
        boolean stopMaxZ = false;
        this.minX = loc.getBlockX();
        this.maxX = loc.getBlockX();
        this.minZ = loc.getBlockZ();
        this.maxZ = loc.getBlockZ();
        plugin.logger(3, "Starting point = " + loc.getBlockX() + "," + loc.getBlockZ());
        plugin.logger(3, "roof minX = " + roof.getMinX());
        plugin.logger(3, "roof maxX = " + roof.getMaxX());
        plugin.logger(3, "roof minZ = " + roof.getMinZ());
        plugin.logger(3, "roof maxZ = " + roof.getMaxZ());
        do {
            plugin.logger(3, "wall radiusminX = " + radiusMinX);
            plugin.logger(3, "wall radius maxX = " + radiusMaxX);
            plugin.logger(3, "wall radius minZ = " + radiusMinZ);
            plugin.logger(3, "wall radius maxZ = " + radiusMaxZ);
            this.minX = loc.getBlockX() - radiusMinX;
            this.maxX = loc.getBlockX() + radiusMaxX;
            this.minZ = loc.getBlockZ() - radiusMinZ;
            this.maxZ = loc.getBlockZ() + radiusMaxZ;
            y = roof.getHeight() - 1;
            for (y = roof.getHeight() - 1; y > this.floor; --y) {
                for (x = this.minX; x <= this.maxX; ++x) {
                    for (z = this.minZ; z <= this.maxZ; ++z) {
                        if (x > this.minX && x < this.maxX && z > this.minZ && z < this.maxZ) continue;
                        plugin.logger(3, "Checking block " + x + " " + y + " " + z);
                        block13: for (BlockFace bf : BlockFace.values()) {
                            switch (bf) {
                                case EAST: {
                                    if (!wallBlocks.contains(world.getBlockAt(x, y, z).getRelative(bf).getType())) continue block13;
                                    stopMaxX = true;
                                    plugin.logger(3, "Wall found, stopping MaxX");
                                    continue block13;
                                }
                                case WEST: {
                                    if (!wallBlocks.contains(world.getBlockAt(x, y, z).getRelative(bf).getType())) continue block13;
                                    stopMinX = true;
                                    plugin.logger(3, "Wall found, stopping minX");
                                    continue block13;
                                }
                                case NORTH: {
                                    if (!wallBlocks.contains(world.getBlockAt(x, y, z).getRelative(bf).getType())) continue block13;
                                    stopMinZ = true;
                                    plugin.logger(3, "Wall found, stopping minZ");
                                    continue block13;
                                }
                                case SOUTH: {
                                    if (!wallBlocks.contains(world.getBlockAt(x, y, z).getRelative(bf).getType())) continue block13;
                                    stopMaxZ = true;
                                    plugin.logger(3, "Wall found, stopping maxZ");
                                    continue block13;
                                }
                            }
                        }
                    }
                }
            }
            if (this.minX < roof.getMinX()) {
                plugin.logger(3, "minx is less that the roof minX");
                stopMinX = true;
            }
            if (this.maxX > roof.getMaxX()) {
                plugin.logger(3, "maxx is > that the roof minX");
                stopMaxX = true;
            }
            if (this.minZ < roof.getMinZ()) {
                plugin.logger(3, "minz is less that the roof minz");
                stopMinZ = true;
            }
            if (this.maxZ > roof.getMaxZ()) {
                plugin.logger(3, "maxZ is >t the roof maxZ");
                stopMaxZ = true;
            }
            if (!stopMinX) {
                ++radiusMinX;
            }
            if (!stopMaxX) {
                ++radiusMaxX;
            }
            if (!stopMinZ) {
                ++radiusMinZ;
            }
            if (stopMaxZ) continue;
            ++radiusMaxZ;
        } while (!stopMinX || !stopMaxX || !stopMinZ || !stopMaxZ);
        --this.minX;
        ++this.maxX;
        --this.minZ;
        ++this.maxZ;
        plugin.logger(3, "wall minX = " + this.minX);
        plugin.logger(3, "wall maxX = " + this.maxX);
        plugin.logger(3, "wall minZ = " + this.minZ);
        plugin.logger(3, "wall maxZ = " + this.maxZ);
        y = roof.getHeight();
        do {
            wallBlockCount = 0;
            for (x = this.minX; x <= this.maxX; ++x) {
                for (z = this.minZ; z <= this.maxZ; ++z) {
                    if (!wallBlocks.contains(world.getBlockAt(x, y, z).getType())) continue;
                    ++wallBlockCount;
                }
            }
        } while (y-- > 0 && wallBlockCount > 0);
        this.floor = y + 1;
        plugin.logger(3, "#2 floor = " + this.floor);
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public boolean useRoofMaxX() {
        return this.useRoofMaxX;
    }

    public boolean useRoofMinX() {
        return this.useRoofMinX;
    }

    public boolean useRoofMaxZ() {
        return this.useRoofMaxZ;
    }

    public boolean useRoofMinZ() {
        return this.useRoofMinZ;
    }

    public List<Material> getWallBlocks() {
        return wallBlocks;
    }

    public int getArea() {
        return (this.maxX - this.minX) * (this.maxZ - this.minZ);
    }

    public Location getRoofBlock() {
        return this.roofBlock;
    }

    public Location getRoofHopperLoc() {
        return this.roofHopperLoc;
    }

    public int getFloor() {
        return this.floor;
    }

    public static boolean isWallBlock(Material blockType) {
        return wallBlocks.contains(blockType);
    }
}

