/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.greenhouse;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.greenhouse.Walls;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class Roof {
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private int height;
    private boolean roofFound;
    private static final List<String> ROOFBLOCKS = Arrays.asList("GLASS", "STAINED_GLASS", "HOPPER", "TRAP_DOOR", "IRON_TRAPDOOR", "GLOWSTONE");

    public Roof(Greenhouses plugin, Location loc) {
        World world = loc.getWorld();
        this.roofFound = false;
        int roofY = loc.getBlockY();
        for (int radius = 0; radius < 100; ++radius) {
            for (int x = loc.getBlockX() - radius; x <= loc.getBlockX() + radius; ++x) {
                for (int z = loc.getBlockZ() - radius; z <= loc.getBlockZ() + radius; ++z) {
                    if (x <= loc.getBlockX() - radius || x >= loc.getBlockX() + radius || z <= loc.getBlockZ() - radius || z >= loc.getBlockZ() + radius) {
                        Block b = world.getBlockAt(x, roofY, z);
                        plugin.logger(3, "Checking column " + x + " " + z);
                        if (!Walls.isWallBlock(b.getType())) {
                            for (int y = roofY; y < world.getMaxHeight(); ++y) {
                                if (!ROOFBLOCKS.contains(world.getBlockAt(x, y, z).getType().name())) continue;
                                this.roofFound = true;
                                loc = new Location(world, (double)x, (double)y, (double)z);
                                plugin.logger(3, "Roof block found at " + x + " " + y + " " + z + " of type " + loc.getBlock().getType().toString());
                                break;
                            }
                        }
                    }
                    if (this.roofFound) break;
                }
                if (this.roofFound) break;
            }
            if (this.roofFound) break;
        }
        this.height = loc.getBlockY();
        this.minX = loc.getBlockX();
        this.maxX = loc.getBlockX();
        this.minZ = loc.getBlockZ();
        this.maxZ = loc.getBlockZ();
        this.expandCoords(loc);
        int minx = this.minX;
        int maxx = this.maxX;
        int minz = this.minZ;
        int maxz = this.maxZ;
        do {
            plugin.logger(3, "Roof minx=" + minx);
            plugin.logger(3, "Roof maxx=" + maxx);
            plugin.logger(3, "Roof minz=" + minz);
            plugin.logger(3, "Roof maxz=" + maxz);
            minx = this.minX;
            maxx = this.maxX;
            minz = this.minZ;
            maxz = this.maxZ;
            for (int x = minx; x <= maxx; ++x) {
                for (int z = minz; z <= maxz; ++z) {
                    this.expandCoords(new Location(world, (double)x, (double)loc.getBlockY(), (double)z));
                }
            }
        } while (minx != this.minX || maxx != this.maxX || minz != this.minZ || maxz != this.maxZ);
    }

    private void expandCoords(Location height) {
        int limit;
        Location maxx = height.clone();
        Location minx = height.clone();
        Location maxz = height.clone();
        Location minz = height.clone();
        for (limit = 0; ROOFBLOCKS.contains(maxx.getBlock().getType().name()) && limit < 100; ++limit) {
            maxx.add(new Vector(1, 0, 0));
        }
        if (maxx.getBlockX() - 1 > this.maxX) {
            this.maxX = maxx.getBlockX() - 1;
        }
        while (ROOFBLOCKS.contains(minx.getBlock().getType().name()) && limit < 200) {
            ++limit;
            minx.subtract(new Vector(1, 0, 0));
        }
        if (minx.getBlockX() + 1 < this.minX) {
            this.minX = minx.getBlockX() + 1;
        }
        while (ROOFBLOCKS.contains(maxz.getBlock().getType().name()) && limit < 300) {
            ++limit;
            maxz.add(new Vector(0, 0, 1));
        }
        if (maxz.getBlockZ() - 1 > this.maxZ) {
            this.maxZ = maxz.getBlockZ() - 1;
        }
        while (ROOFBLOCKS.contains(minz.getBlock().getType().name()) && limit < 400) {
            ++limit;
            minz.subtract(new Vector(0, 0, 1));
        }
        if (minz.getBlockZ() + 1 < this.minZ) {
            this.minZ = minz.getBlockZ() + 1;
        }
    }

    public int getMinX() {
        return this.minX;
    }

    public void setMinX(int minX) {
        this.minX = minX;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public void setMaxX(int maxX) {
        this.maxX = maxX;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public void setMinZ(int minZ) {
        this.minZ = minZ;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(int maxZ) {
        this.maxZ = maxZ;
    }

    public int getArea() {
        return (this.maxX - this.minX) * (this.maxZ - this.minZ);
    }

    public boolean isRoofFound() {
        return this.roofFound;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isRoofBlock(Material blockType) {
        return ROOFBLOCKS.contains(blockType.name());
    }
}

