/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.greenhouse;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.BiomeRecipe;
import com.wasteofplastic.greenhouses.util.Pair;
import com.wasteofplastic.greenhouses.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Hopper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Greenhouse {
    private Greenhouses plugin;
    private final Location pos1;
    private final Location pos2;
    private final World world;
    private UUID owner;
    private String playerName;
    private HashMap<String, Object> flags = new HashMap();
    private Biome originalBiome;
    private Biome greenhouseBiome;
    private Location roofHopperLocation;
    private int area;
    private int heightY;
    private int height;
    private int groundY;
    private BiomeRecipe biomeRecipe;

    public Greenhouse(Greenhouses plugin, Location pos1, Location pos2, UUID owner) {
        this.plugin = plugin;
        this.pos1 = pos1;
        this.pos2 = pos2;
        int minx = Math.min(pos1.getBlockX(), pos2.getBlockX());
        int maxx = Math.max(pos1.getBlockX(), pos2.getBlockX());
        int minz = Math.min(pos1.getBlockZ(), pos2.getBlockZ());
        int maxz = Math.max(pos1.getBlockZ(), pos2.getBlockZ());
        this.area = (maxx - minx - 1) * (maxz - minz - 1);
        this.heightY = Math.max(pos1.getBlockY(), pos2.getBlockY());
        this.groundY = Math.min(pos1.getBlockY(), pos2.getBlockY());
        this.height = this.heightY - this.groundY;
        this.world = pos1.getWorld();
        if (pos1.getWorld() == null || pos2.getWorld() == null) {
            plugin.getLogger().severe("This greenhouse's world does not exist!");
        } else if (!pos1.getWorld().equals(pos2.getWorld())) {
            plugin.getLogger().severe("Pos 1 and Pos 2 are not in the same world!");
        }
        this.originalBiome = pos1.getBlock().getBiome();
        this.greenhouseBiome = pos2.getBlock().getBiome();
        this.owner = owner;
        this.playerName = "";
        this.flags.put("enterMessage", "");
        this.flags.put("farewellMessage", "");
    }

    public Biome getOriginalBiome() {
        return this.originalBiome;
    }

    public Biome getBiome() {
        return this.greenhouseBiome;
    }

    public void setBiomeRecipe(BiomeRecipe winner) {
        this.greenhouseBiome = winner.getBiome();
        this.biomeRecipe = winner;
    }

    public BiomeRecipe getBiomeRecipe() {
        return this.biomeRecipe;
    }

    public void setBiome(Biome greenhouseBiome2) {
        this.greenhouseBiome = greenhouseBiome2;
    }

    public boolean insideGreenhouse(Location loc) {
        if (loc.getWorld().equals(this.world)) {
            this.plugin.logger(4, "Checking intersection");
            Vector v = loc.toVector();
            this.plugin.logger(4, "Pos 1 = " + this.pos1.toString());
            this.plugin.logger(4, "Pos 2 = " + this.pos2.toString());
            this.plugin.logger(4, "V = " + v.toString());
            boolean i = v.isInAABB(Vector.getMinimum((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector()), Vector.getMaximum((Vector)this.pos1.toVector(), (Vector)this.pos2.toVector()));
            return i;
        }
        return false;
    }

    public boolean aboveGreenhouse(Location loc) {
        if (loc.getWorld().equals(this.world)) {
            Vector v = loc.toVector();
            Vector p1 = new Vector(this.pos1.getBlockX(), this.heightY, this.pos1.getBlockZ());
            Vector p2 = new Vector(this.pos2.getBlockX(), this.world.getMaxHeight(), this.pos2.getBlockZ());
            boolean i = v.isInAABB(Vector.getMinimum((Vector)p1, (Vector)p2), Vector.getMaximum((Vector)p1, (Vector)p2));
            return i;
        }
        return false;
    }

    public boolean isAWall(Location loc) {
        this.plugin.logger(3, "wall check");
        return loc.getBlockX() == this.pos1.getBlockX() || loc.getBlockX() == this.pos2.getBlockX() || loc.getBlockZ() == this.pos1.getBlockZ() || loc.getBlockZ() == this.pos2.getBlockZ();
    }

    public Location getPos1() {
        return new Location(this.world, (double)this.pos1.getBlockX(), (double)this.pos1.getBlockY(), (double)this.pos1.getBlockZ());
    }

    public Location getPos2() {
        return new Location(this.world, (double)this.pos2.getBlockX(), (double)this.pos2.getBlockY(), (double)this.pos2.getBlockZ());
    }

    public UUID getOwner() {
        return this.owner;
    }

    public HashMap<String, Object> getFlags() {
        return this.flags;
    }

    public void setFlags(HashMap<String, Object> flags) {
        this.flags = flags;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
    }

    public String getEnterMessage() {
        return (String)this.flags.get("enterMessage");
    }

    public String getFarewellMessage() {
        return (String)this.flags.get("farewellMessage");
    }

    public void setEnterMessage(String enterMessage) {
        this.flags.put("enterMessage", enterMessage);
    }

    public void setFarewellMessage(String farewellMessage) {
        this.flags.put("farewellMessage", farewellMessage);
    }

    public void setOriginalBiome(Biome originalBiome) {
        this.originalBiome = originalBiome;
    }

    public void setRoofHopperLocation(Location roofHopperLoc) {
        this.roofHopperLocation = roofHopperLoc;
    }

    public World getWorld() {
        return this.world;
    }

    public Location getRoofHopperLocation() {
        return this.roofHopperLocation;
    }

    public int getArea() {
        return this.area;
    }

    public int getHeightY() {
        return this.heightY;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean checkEco() {
        this.plugin.logger(3, "Checking the ecology of the greenhouse.");
        if (this.biomeRecipe != null) {
            return this.biomeRecipe.checkRecipe(this.getPos1(), this.getPos2(), null);
        }
        this.plugin.logger(3, "BiomeRecipe is null! ");
        this.plugin.getLogger().warning("[Greenhouse info]");
        this.plugin.getLogger().warning("Owner: " + this.getOwner());
        this.plugin.getLogger().warning("Location :" + this.getPos1().toString() + " to " + this.getPos2().toString());
        return false;
    }

    public void startBiome(boolean teleport) {
        this.setBiomeBlocks(this.greenhouseBiome, teleport);
    }

    public void endBiome() {
        this.setBiomeBlocks(this.originalBiome, false);
    }

    private void setBiomeBlocks(Biome biome, boolean teleport) {
        block8: {
            HashSet<Chunk> chunks;
            block7: {
                if (biome == null) {
                    return;
                }
                this.plugin.logger(2, "Biome seting to " + biome.toString());
                HashSet<Pair> chunkCoords = new HashSet<Pair>();
                chunks = new HashSet<Chunk>();
                for (int x = this.pos1.getBlockX(); x < this.pos2.getBlockX(); ++x) {
                    for (int z = this.pos1.getBlockZ(); z < this.pos2.getBlockZ(); ++z) {
                        Block b = this.world.getBlockAt(x, this.groundY, z);
                        b.setBiome(biome);
                        if (teleport) {
                            chunks.add(b.getChunk());
                        }
                        if (!this.plugin.getServer().getVersion().contains("(MC: 1.7")) continue;
                        chunkCoords.add(new Pair(b.getChunk().getX(), b.getChunk().getZ()));
                    }
                }
                if (!this.plugin.getServer().getVersion().contains("(MC: 1.7")) break block7;
                for (Pair coords : chunkCoords) {
                    this.world.refreshChunk(coords.getLeft(), coords.getRight());
                }
                break block8;
            }
            if (!teleport) break block8;
            for (Chunk c : chunks) {
                if (!c.isLoaded()) continue;
                for (final Entity entity : c.getEntities()) {
                    Location playerLoc;
                    if (!(entity instanceof Player) || entity.isInsideVehicle() || (playerLoc = entity.getLocation()).getBlockX() < this.pos1.getBlockX() || playerLoc.getBlockX() >= this.pos2.getBlockX() || playerLoc.getBlockZ() < this.pos1.getBlockZ() || playerLoc.getBlockZ() >= this.pos2.getBlockZ()) continue;
                    entity.teleport(new Location(entity.getWorld(), 0.0, -5.0, 0.0));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            playerLoc.getChunk().load();
                            entity.teleport(playerLoc);
                        }
                    }, 5L);
                }
            }
        }
    }

    public void populateGreenhouse() {
        if (this.biomeRecipe == null) {
            return;
        }
        this.plugin.logger(3, "populating mobs in greenhouse");
        EntityType mob = this.biomeRecipe.getMob();
        if (mob == null) {
            return;
        }
        this.plugin.logger(3, "Mob ready to spawn in location " + this.pos1.getBlockX() + "," + this.pos2.getBlockZ() + " in world " + this.world.getName());
        int numberOfMobs = 0;
        HashSet<Pair> chunkSet = new HashSet<Pair>();
        for (int x = this.pos1.getBlockX() - 15; x < this.pos2.getBlockX() + 15; x += 16) {
            for (int z = this.pos1.getBlockZ() - 15; z < this.pos2.getBlockZ() + 15; z += 16) {
                Chunk chunk = this.world.getChunkAt(x / 16, z / 16);
                chunkSet.add(new Pair(x / 16, z / 16));
                chunk.load();
                this.plugin.logger(3, "Chunk = " + x / 16 + "," + z / 16 + " number of entities = " + chunk.getEntities().length);
                for (Entity entity : chunk.getEntities()) {
                    this.plugin.logger(3, entity.getType().toString());
                    if (!mob.equals((Object)entity.getType())) continue;
                    ++numberOfMobs;
                }
            }
        }
        this.plugin.logger(3, "Mobs in area = " + numberOfMobs);
        this.plugin.logger(3, "Area of greenhouse = " + this.area);
        if (this.area - numberOfMobs * this.biomeRecipe.getMobLimit() <= 0) {
            this.plugin.logger(3, "Too many mobs already in this greenhouse");
            for (Pair pair : chunkSet) {
                this.world.unloadChunkRequest(pair.getLeft(), pair.getRight());
            }
            return;
        }
        Material type = this.biomeRecipe.getMobSpawnOn(mob);
        int minx = Math.min(this.pos1.getBlockX(), this.pos2.getBlockX());
        int maxx = Math.max(this.pos1.getBlockX(), this.pos2.getBlockX());
        int minz = Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ());
        int maxz = Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ());
        for (int i = 0; i < 10; ++i) {
            int x = Greenhouses.randInt(minx, maxx);
            int z = Greenhouses.randInt(minz, maxz);
            Block h = this.getHighestBlockInGreenhouse(x, z);
            Block b = h.getRelative(BlockFace.DOWN);
            Block a = h.getRelative(BlockFace.UP);
            this.plugin.logger(3, "block found " + h.getType().toString());
            this.plugin.logger(3, "below found " + b.getType().toString());
            this.plugin.logger(3, "above found " + a.getType().toString());
            if ((!b.getType().equals((Object)type) || !h.getType().equals((Object)Material.AIR)) && (!h.getType().equals((Object)type) || !a.getType().equals((Object)Material.AIR))) continue;
            Location midBlock = new Location(this.world, h.getLocation().getX() + 0.5, h.getLocation().getY(), h.getLocation().getZ() + 0.5);
            Entity e = this.world.spawnEntity(midBlock, mob);
            if (e == null) break;
            this.plugin.logger(1, "Spawned a " + Util.prettifyText(mob.toString()) + " on " + Util.prettifyText(type.toString()) + " at " + midBlock.getBlockX() + "," + midBlock.getBlockY() + "," + midBlock.getBlockZ());
            break;
        }
        for (Pair pair : chunkSet) {
            this.world.unloadChunkRequest(pair.getLeft(), pair.getRight());
        }
    }

    public void snow() {
        ArrayList<Block> waterToIceBlocks = new ArrayList<Block>();
        long water = 0L;
        int minx = Math.min(this.pos1.getBlockX(), this.pos2.getBlockX());
        int maxx = Math.max(this.pos1.getBlockX(), this.pos2.getBlockX());
        int minz = Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ());
        int maxz = Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ());
        for (int x = minx + 1; x < maxx; ++x) {
            for (int z = minz + 1; z < maxz; ++z) {
                Block b = this.getHighestBlockInGreenhouse(x, z);
                for (int y = this.pos1.getBlockY(); y < this.heightY; ++y) {
                    Block airCheck = this.world.getBlockAt(x, y, z);
                    if (airCheck.getType().equals((Object)Material.AIR)) {
                        this.world.spawnParticle(Particle.SNOWBALL, airCheck.getLocation(), 5);
                        continue;
                    }
                    if (!airCheck.getType().equals((Object)Material.WATER) && !airCheck.getType().equals((Object)Material.STATIONARY_WATER)) continue;
                    ++water;
                }
                Block belowB = b.getRelative(BlockFace.DOWN);
                if (!(Math.random() < Settings.snowDensity)) continue;
                if (belowB.getType().equals((Object)Material.WATER) || belowB.getType().equals((Object)Material.STATIONARY_WATER)) {
                    if (this.biomeRecipe.getWaterCoverage() > 0) {
                        waterToIceBlocks.add(belowB);
                        continue;
                    }
                    belowB.setType(Material.ICE);
                    continue;
                }
                if (belowB.getType().equals((Object)Material.SNOW)) {
                    int snowHeight = belowB.getData() + 1;
                    if (snowHeight >= 5) continue;
                    belowB.setData((byte)snowHeight);
                    continue;
                }
                if (!b.getType().equals((Object)Material.AIR) || belowB.isLiquid() || belowB.getType().equals((Object)Material.SNOW)) continue;
                b.setType(Material.SNOW);
            }
        }
        this.plugin.logger(3, "water = " + water);
        if (this.biomeRecipe.getWaterCoverage() > 0 && water > 0L) {
            this.plugin.logger(3, "water coverage required = " + this.biomeRecipe.getWaterCoverage());
            for (Block toIce : waterToIceBlocks) {
                this.plugin.logger(3, "water ratio = " + (double)(water - 1L) / (double)this.area * 100.0);
                if ((double)(water - 1L) / (double)this.area * 100.0 > (double)this.biomeRecipe.getWaterCoverage()) {
                    toIce.setType(Material.ICE);
                    --water;
                    continue;
                }
                this.plugin.logger(3, "no more ice allowed");
                break;
            }
        }
    }

    public void growFlowers() {
        if (this.biomeRecipe == null) {
            return;
        }
        Location hopper = this.roofHopperLocation;
        if (hopper != null) {
            this.plugin.logger(3, "Hopper location:" + hopper.toString());
            Block b = hopper.getBlock();
            if (b.getType().equals((Object)Material.HOPPER)) {
                Hopper h = (Hopper)b.getState();
                this.plugin.logger(3, "Hopper found!");
                if (h.getInventory().contains(Material.INK_SACK)) {
                    ItemStack[] hopperInv = h.getInventory().getContents();
                    int bonemeal = 0;
                    int total = 0;
                    for (ItemStack item : hopperInv) {
                        if (item == null || item.getDurability() != 15) continue;
                        bonemeal += item.getAmount();
                    }
                    total = bonemeal;
                    if (bonemeal > 0) {
                        this.plugin.logger(3, "Bonemeal found! Amount = " + bonemeal);
                        int minx = Math.min(this.pos1.getBlockX(), this.pos2.getBlockX());
                        int maxx = Math.max(this.pos1.getBlockX(), this.pos2.getBlockX());
                        int minz = Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ());
                        int maxz = Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ());
                        for (int x = minx + 1; x < maxx; ++x) {
                            for (int z = minz + 1; z < maxz; ++z) {
                                Block bl = this.getHighestBlockInGreenhouse(x, z);
                                this.plugin.logger(3, "Block is " + bl.getRelative(BlockFace.DOWN).getType().toString());
                                if (bonemeal <= 0 || !this.biomeRecipe.growPlant(bl)) continue;
                                --bonemeal;
                                this.plugin.logger(3, "Grew plant, spraying bonemeal");
                                for (int y = bl.getLocation().getBlockY(); y < this.heightY; ++y) {
                                    Block airCheck = this.world.getBlockAt(x, y, z);
                                    if (!airCheck.getType().equals((Object)Material.AIR)) continue;
                                    this.world.spawnParticle(Particle.EXPLOSION_NORMAL, airCheck.getLocation(), 5);
                                }
                            }
                        }
                        this.plugin.logger(3, "Bonemeal left = " + bonemeal);
                        this.plugin.logger(3, "Amount to be removed  = " + (total -= bonemeal));
                        for (int index = 0; index < h.getInventory().getSize(); ++index) {
                            ItemStack i = h.getInventory().getItem(index);
                            if (i == null || !i.getType().equals((Object)Material.INK_SACK) || i.getDurability() != 15) continue;
                            this.plugin.logger(3, "Bonemeal found of size " + i.getAmount());
                            if (total - i.getAmount() > 0) {
                                this.plugin.logger(3, "Completely used up");
                                total -= i.getAmount();
                                h.getInventory().remove(i);
                                continue;
                            }
                            this.plugin.logger(3, "Left overs");
                            i.setAmount(i.getAmount() - total);
                            total = 0;
                        }
                    }
                }
            } else {
                this.plugin.logger(3, "Hopper is not there anymore...");
            }
        }
    }

    public void convertBlocks() {
        if (this.biomeRecipe == null) {
            return;
        }
        if (this.biomeRecipe.getBlockConvert()) {
            int minx = Math.min(this.pos1.getBlockX(), this.pos2.getBlockX());
            int maxx = Math.max(this.pos1.getBlockX(), this.pos2.getBlockX());
            int minz = Math.min(this.pos1.getBlockZ(), this.pos2.getBlockZ());
            int maxz = Math.max(this.pos1.getBlockZ(), this.pos2.getBlockZ());
            for (int x = minx + 1; x < maxx; ++x) {
                for (int z = minz + 1; z < maxz; ++z) {
                    for (int y = this.groundY; y < this.heightY; ++y) {
                        this.biomeRecipe.convertBlock(this.world.getBlockAt(x, y, z));
                    }
                }
            }
        }
    }

    public Block getHighestBlockInGreenhouse(int x, int z) {
        Block bl = this.world.getBlockAt(x, this.heightY, z).getRelative(BlockFace.DOWN);
        while (bl.getLocation().getBlockY() >= this.groundY && bl.isEmpty()) {
            bl = bl.getRelative(BlockFace.DOWN);
        }
        return bl.getRelative(BlockFace.UP);
    }
}

