/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.greenhouse;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.Hopper;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Ecosystem
implements Listener {
    private final Greenhouses plugin;
    private static final List<Biome> SNOWBIOMES = new ArrayList<Biome>();
    private BukkitTask snow = null;
    private List<Greenhouse> snowGlobes = new ArrayList<Greenhouse>();

    public Ecosystem(Greenhouses plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onWeatherChangeEvent(WeatherChangeEvent e) {
        if (!Settings.worldName.contains(e.getWorld().getName())) {
            return;
        }
        if (e.toWeatherState()) {
            this.plugin.logger(3, "It's raining!");
            this.startSnow();
        } else {
            this.plugin.logger(3, "Stopped raining!");
            if (this.snow != null) {
                this.snow.cancel();
            }
        }
    }

    private void startSnow() {
        if (this.snow != null) {
            this.snow.cancel();
        }
        this.snowGlobes.clear();
        this.snow = this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                Ecosystem.this.plugin.logger(3, "started scheduler");
                ArrayList<Greenhouse> toBeRemoved = new ArrayList<Greenhouse>();
                for (Greenhouse g : Ecosystem.this.plugin.getGreenhouses()) {
                    Location hopper;
                    Ecosystem.this.plugin.logger(3, "Testing greenhouse biome : " + g.getBiome().toString());
                    if (!SNOWBIOMES.contains(g.getBiome())) continue;
                    Ecosystem.this.plugin.logger(3, "Snow biome found!");
                    if (Ecosystem.this.snowGlobes.contains(g) || (hopper = g.getRoofHopperLocation()) == null) continue;
                    Ecosystem.this.plugin.logger(3, "Hopper location:" + hopper.toString());
                    Block b = hopper.getBlock();
                    if (b.getType().equals((Object)Material.HOPPER)) {
                        Hopper h = (Hopper)b.getState();
                        Ecosystem.this.plugin.logger(3, "Hopper found!");
                        if (!h.getInventory().contains(Material.WATER_BUCKET)) continue;
                        for (ItemStack item : h.getInventory().getContents()) {
                            if (item == null || !item.getType().equals((Object)Material.WATER_BUCKET)) continue;
                            ItemStack i = item.clone();
                            i.setAmount(1);
                            h.getInventory().removeItem(new ItemStack[]{i});
                            h.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                            break;
                        }
                        Ecosystem.this.snowGlobes.add(g);
                        continue;
                    }
                    Ecosystem.this.plugin.getLogger().warning("Hopper missing from greenhouse at " + g.getRoofHopperLocation().getBlockX() + " " + g.getRoofHopperLocation().getBlockY() + " " + g.getRoofHopperLocation().getBlockZ());
                    Ecosystem.this.plugin.getLogger().warning("Removing greenhouse");
                    toBeRemoved.add(g);
                }
                if (!Ecosystem.this.snowGlobes.isEmpty()) {
                    Ecosystem.this.snowOn(Ecosystem.this.snowGlobes);
                }
                for (Greenhouse g : toBeRemoved) {
                    Ecosystem.this.plugin.removeGreenhouse(g);
                }
                Ecosystem.this.plugin.saveGreenhouses();
            }
        }, 0L, Settings.snowSpeed * 20L);
    }

    protected void snowOn(List<Greenhouse> snowGlobes) {
        for (Greenhouse g : snowGlobes) {
            this.plugin.logger(3, "snowing in a greenhouse");
            if (Math.random() > Settings.snowChanceGlobal) {
                return;
            }
            g.snow();
        }
    }

    public void remove(Greenhouse g) {
        if (this.snowGlobes.contains(g)) {
            this.snowGlobes.remove(g);
        }
    }

    static {
        for (Biome biome : Biome.values()) {
            if (!biome.name().contains("COLD") && !biome.name().contains("ICE") && !biome.name().contains("FROZEN")) continue;
            SNOWBIOMES.add(biome);
        }
    }
}

