/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses.greenhouse;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BiomeRecipe {
    private Greenhouses plugin;
    private Biome type;
    private Material icon;
    private int priority;
    private String name;
    private String friendlyName;
    private List<Material> blockMaterial = new ArrayList<Material>();
    private List<Integer> blockType = new ArrayList<Integer>();
    private List<Long> blockQty = new ArrayList<Long>();
    private List<Long> blockQtyCheck = new ArrayList<Long>();
    private List<Material> plantMaterial = new ArrayList<Material>();
    private List<Integer> plantType = new ArrayList<Integer>();
    private List<Integer> plantProbability = new ArrayList<Integer>();
    private List<Material> plantGrownOn = new ArrayList<Material>();
    private List<EntityType> mobType = new ArrayList<EntityType>();
    private List<Double> mobProbability = new ArrayList<Double>();
    private List<Material> mobSpawnOn = new ArrayList<Material>();
    private List<Material> oldMaterial = new ArrayList<Material>();
    private List<Byte> oldType = new ArrayList<Byte>();
    private List<Integer> convChance = new ArrayList<Integer>();
    private List<Material> newMaterial = new ArrayList<Material>();
    private List<Byte> newType = new ArrayList<Byte>();
    private List<Material> localMaterial = new ArrayList<Material>();
    private List<Byte> localType = new ArrayList<Byte>();
    private int mobLimit;
    private int waterCoverage;
    private int iceCoverage;
    private int lavaCoverage;
    private String permission = "";

    public BiomeRecipe(Greenhouses plugin, Biome type, int priority) {
        this.plugin = plugin;
        this.type = type;
        this.priority = priority;
        plugin.logger(3, "" + type.toString() + " priority " + priority);
        this.mobLimit = 9;
    }

    public void addReqBlocks(Material blockMaterial, int blockType, long blockQty) {
        ItemStack i = new ItemStack(blockMaterial);
        if (blockType >= 0) {
            i.setDurability((short)blockType);
        }
        this.plugin.logger(1, "   " + Util.getName(i) + " x " + blockQty);
        this.blockMaterial.add(blockMaterial);
        this.blockType.add(blockType);
        this.blockQty.add(blockQty);
        this.blockQtyCheck.add(blockQty);
    }

    public boolean checkRecipe(Location pos1, Location pos2, Player player) {
        this.plugin.logger(3, "Checking for biome " + this.type.toString());
        long area = (pos2.getBlockX() - pos1.getBlockX() - 1) * (pos2.getBlockZ() - pos1.getBlockZ() - 1);
        this.plugin.logger(3, "area =" + area);
        this.plugin.logger(3, "Pos1 = " + pos1.toString());
        this.plugin.logger(3, "Pos1 = " + pos2.toString());
        long water = 0L;
        long lava = 0L;
        long ice = 0L;
        boolean pass = true;
        for (int y = pos1.getBlockY(); y < pos2.getBlockY(); ++y) {
            for (int x = pos1.getBlockX() + 1; x < pos2.getBlockX(); ++x) {
                for (int z = pos1.getBlockZ() + 1; z < pos2.getBlockZ(); ++z) {
                    Block b = pos1.getWorld().getBlockAt(x, y, z);
                    int data = b.getData();
                    if (!b.getType().equals((Object)Material.AIR)) {
                        this.plugin.logger(3, "Checking block " + b.getType() + ":" + b.getData() + "@" + x + " " + y + " " + z);
                    }
                    switch (b.getType()) {
                        case WATER: 
                        case STATIONARY_WATER: {
                            ++water;
                            break;
                        }
                        case LAVA: 
                        case STATIONARY_LAVA: {
                            ++lava;
                            break;
                        }
                        case ICE: 
                        case PACKED_ICE: {
                            ++ice;
                            break;
                        }
                        case LEAVES: 
                        case LEAVES_2: {
                            while (data > 3) {
                                data -= 4;
                            }
                            break;
                        }
                    }
                    int index = this.indexOfReqBlocks(b.getType(), data);
                    if (index < 0) continue;
                    this.plugin.logger(3, "Found block " + b.getType().toString() + " type " + b.getData() + " at index " + index);
                    this.blockQtyCheck.set(index, this.blockQtyCheck.get(index) - 1L);
                }
            }
        }
        double waterRatio = (double)water / (double)area * 100.0;
        double lavaRatio = (double)lava / (double)area * 100.0;
        double iceRatio = (double)ice / (double)area * 100.0;
        this.plugin.logger(3, "water count=" + water);
        this.plugin.logger(3, "water req=" + this.waterCoverage + " lava req=" + this.lavaCoverage + " ice req=" + this.iceCoverage);
        this.plugin.logger(3, "waterRatio=" + waterRatio + " lavaRatio=" + lavaRatio + " iceRatio=" + iceRatio);
        if (this.waterCoverage == 0 && waterRatio > 0.0) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipenowater);
            }
            pass = false;
        }
        if (this.lavaCoverage == 0 && lavaRatio > 0.0) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipenolava);
            }
            pass = false;
        }
        if (this.iceCoverage == 0 && iceRatio > 0.0) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipenoice);
            }
            pass = false;
        }
        if (this.waterCoverage > 0 && waterRatio < (double)this.waterCoverage) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipewatermustbe.replace("[coverage]", String.valueOf(this.waterCoverage)));
            }
            pass = false;
        }
        if (this.lavaCoverage > 0 && lavaRatio < (double)this.lavaCoverage) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipelavamustbe.replace("[coverage]", String.valueOf(this.lavaCoverage)));
            }
            pass = false;
        }
        if (this.iceCoverage > 0 && iceRatio < (double)this.iceCoverage) {
            if (player != null) {
                player.sendMessage(ChatColor.RED + Locale.recipeicemustbe.replace("[coverage]", String.valueOf(this.iceCoverage)));
            }
            pass = false;
        }
        this.plugin.logger(3, "checking blocks - total size is " + this.blockQty.size());
        for (int i = 0; i < this.blockQty.size(); ++i) {
            if (this.blockQtyCheck.get(i) > 0L) {
                this.plugin.logger(3, "missing: " + this.blockQtyCheck.get(i) + " x " + this.blockMaterial.get(i) + ":" + this.blockType.get(i));
                pass = false;
                if (player != null) {
                    ItemStack missingBlock = new ItemStack(this.blockMaterial.get(i));
                    if (this.blockType.get(i) > 0) {
                        missingBlock.setDurability(this.blockType.get(i).shortValue());
                    }
                    player.sendMessage(ChatColor.RED + Locale.recipemissing + " " + this.blockQtyCheck.get(i) + " x " + Util.getName(missingBlock));
                }
                pass = false;
            }
            this.blockQtyCheck.set(i, this.blockQty.get(i));
        }
        return pass;
    }

    private int indexOfReqBlocks(Material blockMaterial, int blockType) {
        this.plugin.logger(3, "looking for block " + blockMaterial.toString() + " type " + blockType);
        if (!this.blockMaterial.contains(blockMaterial)) {
            return -1;
        }
        int index = 0;
        for (Material m : this.blockMaterial) {
            if (m.equals((Object)blockMaterial) && (this.blockType.get(index) == -1 || this.blockType.get(index).equals(blockType))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public List<String> getRecipeBlocks() {
        ArrayList<String> blocks = new ArrayList<String>();
        int index = 0;
        for (Material m : this.blockMaterial) {
            blocks.add(Util.getName(new ItemStack(m, 1, this.blockType.get(index).shortValue())) + " x " + this.blockQty.get(index));
            ++index;
        }
        return blocks;
    }

    public void addPlants(Material plantMaterial, int plantType, int plantProbability, Material plantGrowOn) {
        ItemStack i = new ItemStack(plantMaterial);
        if (plantType > 0) {
            i.setDurability((short)plantType);
        }
        this.plugin.logger(1, "   " + plantProbability + "% chance for " + Util.getName(i) + " to grow.");
        this.plantMaterial.add(plantMaterial);
        this.plantType.add(plantType);
        this.plantProbability.add(plantProbability);
        this.plantGrownOn.add(plantGrowOn);
    }

    public void addMobs(EntityType mobType, int mobProbability, Material mobSpawnOn) {
        this.plugin.logger(1, "   " + mobProbability + "% chance for " + Util.prettifyText(mobType.toString()) + " to spawn on " + Util.prettifyText(mobSpawnOn.toString()) + ".");
        this.mobType.add(mobType);
        double probability = (double)mobProbability / 100.0;
        this.mobSpawnOn.add(mobSpawnOn);
        double totalProb = 0.0;
        for (double prob : this.mobProbability) {
            totalProb += prob;
        }
        if (1.0 - totalProb >= probability) {
            this.mobProbability.add(probability);
        } else {
            this.plugin.getLogger().warning("   Mob chances add up to >100% in " + this.type.toString() + " biome recipe!");
        }
    }

    public EntityType getMob() {
        double rand = Math.random();
        this.plugin.logger(3, "random number is " + rand);
        double runningTotal = 0.0;
        int index = 0;
        for (double prob : this.mobProbability) {
            this.plugin.logger(3, "running total is " + (runningTotal += prob));
            if (rand < runningTotal) {
                this.plugin.logger(3, "hit! " + this.mobType.get(index).toString());
                return this.mobType.get(index);
            }
            ++index;
        }
        return null;
    }

    public Material getMobSpawnOn(EntityType mobType) {
        int index = this.mobType.indexOf(mobType);
        if (index == -1) {
            return null;
        }
        return this.mobSpawnOn.get(index);
    }

    public int getMobLimit() {
        return this.mobLimit;
    }

    public void setMobLimit(int mobLimit) {
        this.mobLimit = mobLimit;
    }

    public void addConvBlocks(Material oldMaterial, int oldType, Material newMaterial, int newType, int convChance, Material localMaterial, int localType) {
        this.oldMaterial.add(oldMaterial);
        this.oldType.add((byte)oldType);
        this.newMaterial.add(newMaterial);
        this.newType.add((byte)newType);
        this.localMaterial.add(localMaterial);
        this.localType.add((byte)localType);
        this.convChance.add(convChance);
    }

    public boolean getBlockConvert() {
        return !this.oldMaterial.isEmpty();
    }

    public void convertBlock(Block b) {
        this.plugin.logger(3, "try to convert block");
        byte type = b.getData();
        if (!this.oldMaterial.contains(b.getType()) || !this.oldType.contains(type)) {
            this.plugin.logger(3, "no material or type match");
            return;
        }
        this.plugin.logger(3, "material or type match");
        int index = this.oldMaterial.indexOf(b.getType());
        if (!this.oldType.get(index).equals(type)) {
            this.plugin.logger(3, "no type match");
            return;
        }
        this.plugin.logger(3, "type match");
        double chance = Math.random();
        double convCh = (double)this.convChance.get(index).intValue() / 100.0;
        if (chance > convCh) {
            this.plugin.logger(3, "failed the probability check - " + chance + " > " + convCh);
            return;
        }
        this.plugin.logger(3, "pass the probability check");
        if (this.localMaterial.get(index) != null) {
            this.plugin.logger(3, "Looking for " + this.localMaterial.get(index).toString() + ":" + this.localType.get(index));
            boolean found = false;
            block3: for (BlockFace bf : BlockFace.values()) {
                switch (bf) {
                    case DOWN: 
                    case EAST: 
                    case NORTH: 
                    case SOUTH: 
                    case UP: 
                    case WEST: {
                        this.plugin.logger(3, bf.toString() + " material is " + b.getRelative(bf).getType().toString());
                        if (!b.getRelative(bf).getType().equals((Object)this.localMaterial.get(index))) continue block3;
                        this.plugin.logger(3, "Material matches");
                        byte t = b.getRelative(bf).getData();
                        if (!this.localType.get(index).equals((byte)0) && !this.localType.get(index).equals(t)) continue block3;
                        this.plugin.logger(3, "found adjacent block");
                        found = true;
                        continue block3;
                    }
                }
            }
            if (!found) {
                return;
            }
        } else {
            this.plugin.logger(3, "no adjacent block requirement");
        }
        this.plugin.logger(3, "Convert block");
        b.setType(this.newMaterial.get(index));
        b.setData(this.newType.get(index).byteValue());
    }

    public Biome getBiome() {
        return this.type;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getWaterCoverage() {
        return this.waterCoverage;
    }

    public int getIceCoverage() {
        return this.iceCoverage;
    }

    public int getLavaCoverage() {
        return this.lavaCoverage;
    }

    public void setType(Biome type) {
        this.type = type;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setWatercoverage(int watercoverage) {
        if (watercoverage == 0) {
            this.plugin.logger(1, "   No Water Allowed");
        } else if (watercoverage > 0) {
            this.plugin.logger(1, "   Water > " + watercoverage + "%");
        }
        this.waterCoverage = watercoverage;
    }

    public void setIcecoverage(int icecoverage) {
        if (icecoverage == 0) {
            this.plugin.logger(1, "   No Ice Allowed");
        } else if (icecoverage > 0) {
            this.plugin.logger(1, "   Ice > " + icecoverage + "%");
        }
        this.iceCoverage = icecoverage;
    }

    public void setLavacoverage(int lavacoverage) {
        if (lavacoverage == 0) {
            this.plugin.logger(1, "   No Lava Allowed");
        } else if (lavacoverage > 0) {
            this.plugin.logger(1, "   Lava > " + lavacoverage + "%");
        }
        this.lavaCoverage = lavacoverage;
    }

    public boolean growPlant(Block bl) {
        if (bl.getType() != Material.AIR) {
            return false;
        }
        boolean grewPlant = false;
        int index = 0;
        this.plugin.logger(3, "growPlant # of plants in biome = " + this.plantProbability.size());
        for (int prob : this.plantProbability) {
            this.plugin.logger(3, "probability = " + (double)prob / 100.0);
            if (Math.random() < (double)prob / 100.0) {
                this.plugin.logger(2, "trying to grow plant. Index is " + index);
                Material belowBl = bl.getRelative(BlockFace.DOWN).getType();
                Block aboveBl = bl.getRelative(BlockFace.UP);
                this.plugin.logger(3, "material found = " + belowBl.toString());
                this.plugin.logger(3, "above = " + aboveBl.getType().toString());
                this.plugin.logger(3, "req material = " + this.plantGrownOn.get(index).toString());
                if (belowBl == this.plantGrownOn.get(index)) {
                    if (!this.plantMaterial.get(index).equals((Object)Material.DOUBLE_PLANT)) {
                        bl.setType(this.plantMaterial.get(index));
                        bl.setData(this.plantType.get(index).byteValue());
                        grewPlant = true;
                    } else {
                        this.plugin.logger(2, "Double plant time!");
                        if (aboveBl.getType() == Material.AIR) {
                            this.plugin.logger(2, "Above above is AIR!");
                            bl.setType(this.plantMaterial.get(index));
                            bl.setData(this.plantType.get(index).byteValue());
                            aboveBl.setType(Material.DOUBLE_PLANT);
                            aboveBl.setData((byte)8);
                            grewPlant = true;
                        } else {
                            this.plugin.logger(3, "Above above is not AIR");
                        }
                    }
                }
            }
            ++index;
        }
        return grewPlant;
    }

    public Material getIcon() {
        return this.icon;
    }

    public void setIcon(Material icon) {
        this.icon = icon;
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }
}

