/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses;

import com.wasteofplastic.greenhouses.Greenhouses;
import com.wasteofplastic.greenhouses.Players;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.ui.Locale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class PlayerCache {
    private HashMap<UUID, Players> playerCache = new HashMap();
    private final Greenhouses plugin;

    public PlayerCache(Greenhouses plugin) {
        this.plugin = plugin;
        this.playerCache.clear();
        Collection serverPlayers = plugin.getServer().getOnlinePlayers();
        for (Player p : serverPlayers) {
            this.playerCache.put(p.getUniqueId(), new Players(p));
        }
    }

    public void addPlayer(Player player) {
        if (!this.playerCache.containsKey(player.getUniqueId())) {
            this.playerCache.put(player.getUniqueId(), new Players(player));
        }
        int limit = this.plugin.getMaxGreenhouses(player);
        ArrayList<Greenhouse> toBeRemoved = new ArrayList<Greenhouse>();
        int owned = 0;
        for (Greenhouse g : this.plugin.getGreenhouses()) {
            if (!g.getOwner().equals(player.getUniqueId())) continue;
            if (++owned <= limit) {
                this.playerCache.get(player.getUniqueId()).incrementGreenhouses();
                g.setPlayerName(player.getName());
                continue;
            }
            toBeRemoved.add(g);
        }
        if (Settings.deleteExtras && limit >= 0) {
            for (Greenhouse g : toBeRemoved) {
                this.plugin.removeGreenhouse(g);
                this.plugin.logger(2, "Removed greenhouse over the limit for " + player.getName());
            }
            if (toBeRemoved.size() > 0) {
                if (limit == 0) {
                    player.sendMessage(ChatColor.RED + Locale.limitsnoneallowed.replace("[number]", String.valueOf(toBeRemoved.size())));
                } else {
                    player.sendMessage(ChatColor.RED + Locale.limitslimitedto.replace("[limit]", String.valueOf(limit)).replace("[number]", String.valueOf(toBeRemoved.size())));
                }
            }
        }
    }

    public void removeOnlinePlayer(Player player) {
        if (this.playerCache.containsKey(player.getUniqueId())) {
            this.playerCache.remove(player);
            this.plugin.logger(3, "Removing player from cache: " + player);
        }
    }

    public void removeAllPlayers() {
        this.playerCache.clear();
    }

    public Greenhouse getInGreenhouse(Player player) {
        for (Greenhouse g : this.plugin.getGreenhouses()) {
            if (!g.insideGreenhouse(player.getLocation())) continue;
            return g;
        }
        return null;
    }

    public boolean incGreenhouseCount(Player player) {
        int limit = this.plugin.getMaxGreenhouses(player);
        if (limit < 0 || this.playerCache.get(player.getUniqueId()).getNumberOfGreenhouses() < limit) {
            this.playerCache.get(player.getUniqueId()).incrementGreenhouses();
            return true;
        }
        return false;
    }

    public void decGreenhouseCount(Player player) {
        this.playerCache.get(player.getUniqueId()).decrementGreenhouses();
    }

    public void decGreenhouseCount(UUID playerUUID) {
        if (this.playerCache.containsKey(playerUUID)) {
            this.playerCache.get(playerUUID).decrementGreenhouses();
        }
    }

    public boolean isAtLimit(Player player) {
        return this.getRemainingGreenhouses(player) == 0;
    }

    public int getRemainingGreenhouses(Player player) {
        int remaining;
        int limit = this.plugin.getMaxGreenhouses(player);
        if (limit < 0) {
            return -1;
        }
        int size = 0;
        if (this.plugin.getPlayerhouses().containsKey(player.getUniqueId())) {
            size = this.plugin.getPlayerhouses().get(player.getUniqueId()).size();
        }
        if ((remaining = limit - size) < 0) {
            return 0;
        }
        return remaining;
    }
}

