/*
 * Decompiled with CFR 0.152.
 */
package com.wasteofplastic.greenhouses;

import com.wasteofplastic.greenhouses.PlayerCache;
import com.wasteofplastic.greenhouses.Settings;
import com.wasteofplastic.greenhouses.greenhouse.BiomeRecipe;
import com.wasteofplastic.greenhouses.greenhouse.Ecosystem;
import com.wasteofplastic.greenhouses.greenhouse.Greenhouse;
import com.wasteofplastic.greenhouses.greenhouse.Roof;
import com.wasteofplastic.greenhouses.greenhouse.Walls;
import com.wasteofplastic.greenhouses.listeners.GreenhouseEvents;
import com.wasteofplastic.greenhouses.listeners.GreenhouseGuard;
import com.wasteofplastic.greenhouses.listeners.JoinLeaveEvents;
import com.wasteofplastic.greenhouses.ui.AdminCmd;
import com.wasteofplastic.greenhouses.ui.ControlPanel;
import com.wasteofplastic.greenhouses.ui.GreenhouseCmd;
import com.wasteofplastic.greenhouses.ui.Locale;
import com.wasteofplastic.greenhouses.util.MetricsLite;
import com.wasteofplastic.greenhouses.util.Util;
import com.wasteofplastic.greenhouses.util.VaultHelper;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class Greenhouses
extends JavaPlugin {
    private static final List<String> WALLBLOCKS = Arrays.asList("HOPPER", "GLASS", "GLOWSTONE", "STAINED_GLASS", "STAINED_GLASS_PANE", "THIN_GLASS", "IRON_DOOR_BLOCK");
    private static final int MAXIMUM_INVENTORY_SIZE = 49;
    private static Greenhouses plugin;
    public static World pluginWorld;
    private FileConfiguration locale = null;
    private File localeFile = null;
    public PlayerCache players;
    private HashSet<Greenhouse> greenhouses = new HashSet();
    private HashMap<UUID, HashSet<Greenhouse>> playerhouses = new HashMap();
    private File greenhouseFile;
    private YamlConfiguration greenhouseConfig;
    private HashMap<UUID, List<String>> messages = new HashMap();
    private YamlConfiguration messageStore;
    private Ecosystem eco = new Ecosystem(this);
    private BukkitTask plantTask = null;
    private BukkitTask mobTask = null;
    private BukkitTask blockTask = null;
    private BukkitTask ecoTask = null;
    private List<BiomeRecipe> biomeRecipes = new ArrayList<BiomeRecipe>();
    private ControlPanel biomeInv;
    private List<String> debug = new ArrayList<String>();

    public static Greenhouses getPlugin() {
        return plugin;
    }

    public static Location getLocationString(String s) {
        if (s == null || s.trim() == "") {
            return null;
        }
        String[] parts = s.split(":");
        if (parts.length == 4) {
            World w = Bukkit.getServer().getWorld(parts[0]);
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            return new Location(w, (double)x, (double)y, (double)z);
        }
        return null;
    }

    public static String getStringLocation(Location l) {
        if (l == null) {
            return "";
        }
        return l.getWorld().getName() + ":" + l.getBlockX() + ":" + l.getBlockY() + ":" + l.getBlockZ();
    }

    public static void saveYamlFile(YamlConfiguration yamlFile, String fileLocation) {
        File dataFolder = plugin.getDataFolder();
        File file = new File(dataFolder, fileLocation);
        try {
            yamlFile.save(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public YamlConfiguration loadYamlFile(String file) {
        File dataFolder = plugin.getDataFolder();
        File yamlFile = new File(dataFolder, file);
        YamlConfiguration config = new YamlConfiguration();
        if (!yamlFile.exists()) {
            this.logger(1, "No " + file + " found. Creating it...");
            this.saveResource(file, false);
        }
        try {
            config.load(yamlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return config;
    }

    public void loadBiomeRecipes() {
        this.biomeRecipes.clear();
        YamlConfiguration biomes = this.loadYamlFile("biomes.yml");
        ConfigurationSection biomeSection = biomes.getConfigurationSection("biomes");
        if (biomeSection == null) {
            this.getLogger().severe("biomes.yml file is missing, empty or corrupted. Delete and reload plugin again!");
            return;
        }
        for (String type : biomeSection.getValues(false).keySet()) {
            this.logger(1, "Loading " + type + " biome recipe:");
            try {
                ConfigurationSection biomeRecipe = biomeSection.getConfigurationSection(type);
                Biome thisBiome = null;
                thisBiome = biomeRecipe.contains("biome") ? Biome.valueOf((String)biomeRecipe.getString("biome").toUpperCase()) : Biome.valueOf((String)type);
                if (thisBiome != null) {
                    HashMap mobs;
                    HashMap plants;
                    ConfigurationSection temp;
                    int priority = biomeRecipe.getInt("priority", 0);
                    BiomeRecipe b = new BiomeRecipe(this, thisBiome, priority);
                    b.setName(type);
                    b.setPermission(biomeRecipe.getString("permission", ""));
                    b.setIcon(Material.valueOf((String)biomeRecipe.getString("icon", "SAPLING")));
                    b.setFriendlyName(ChatColor.translateAlternateColorCodes((char)'&', (String)biomeRecipe.getString("friendlyname", "")));
                    b.setWatercoverage(biomeRecipe.getInt("watercoverage", -1));
                    b.setLavacoverage(biomeRecipe.getInt("lavacoverage", -1));
                    b.setIcecoverage(biomeRecipe.getInt("icecoverage", -1));
                    b.setMobLimit(biomeRecipe.getInt("moblimit", 9));
                    String contents = biomeRecipe.getString("contents", "");
                    this.logger(3, "contents = '" + contents + "'");
                    if (!contents.isEmpty()) {
                        String[] split;
                        for (String s : split = contents.split(" ")) {
                            String[] subSplit = s.split(":");
                            if (subSplit.length > 1) {
                                Material blockMaterial = Material.valueOf((String)subSplit[0]);
                                int blockType = 0;
                                int blockQty = 0;
                                if (subSplit.length == 2) {
                                    blockQty = Integer.valueOf(subSplit[1]);
                                    blockType = -1;
                                } else if (subSplit.length == 3) {
                                    blockType = Integer.valueOf(subSplit[1]);
                                    blockQty = Integer.valueOf(subSplit[2]);
                                }
                                b.addReqBlocks(blockMaterial, blockType, blockQty);
                                continue;
                            }
                            this.getLogger().warning("Block material " + s + " has no associated qty in biomes.yml " + type);
                        }
                    }
                    if ((temp = biomes.getConfigurationSection("biomes." + type + ".plants")) != null && (plants = (HashMap)temp.getValues(false)) != null) {
                        for (String s : plants.keySet()) {
                            String[] split;
                            Material plantMaterial = null;
                            int plantType = 0;
                            if (s.contains(":")) {
                                split = s.split(":");
                                if (split.length == 2) {
                                    plantMaterial = Material.valueOf((String)split[0]);
                                    plantType = Integer.valueOf(split[1]);
                                }
                            } else {
                                plantMaterial = Material.valueOf((String)s);
                            }
                            split = ((String)plants.get(s)).split(":");
                            int plantProbability = Integer.valueOf(split[0]);
                            Material plantGrowOn = Material.valueOf((String)split[1]);
                            if (split.length == 3) {
                                plantType = Integer.valueOf(split[2]);
                            }
                            b.addPlants(plantMaterial, plantType, plantProbability, plantGrowOn);
                        }
                    }
                    if ((temp = biomes.getConfigurationSection("biomes." + type + ".mobs")) != null && (mobs = (HashMap)temp.getValues(false)) != null) {
                        for (String s : mobs.keySet()) {
                            EntityType mobType = EntityType.valueOf((String)s);
                            String[] split = ((String)mobs.get(s)).split(":");
                            int mobProbability = Integer.valueOf(split[0]);
                            Material mobSpawnOn = Material.valueOf((String)split[1]);
                            int mobSpawnOnType = 0;
                            if (split.length == 3) {
                                mobSpawnOnType = Integer.valueOf(split[2]);
                            }
                            b.addMobs(mobType, mobProbability, mobSpawnOn);
                        }
                    }
                    String conversions = biomeSection.getString(type + ".conversions", "");
                    this.logger(3, "conversions = '" + conversions + "'");
                    if (!conversions.isEmpty()) {
                        String[] split;
                        for (String s : split = conversions.split(" ")) {
                            String[] subSplit = s.split(":");
                            Material oldMaterial = null;
                            int oldType = 0;
                            Material newMaterial = null;
                            int newType = 0;
                            Material localMaterial = null;
                            int localType = 0;
                            oldMaterial = Material.valueOf((String)subSplit[0]);
                            oldType = Integer.valueOf(subSplit[1]);
                            int convChance = Integer.valueOf(subSplit[2]);
                            newMaterial = Material.valueOf((String)subSplit[3]);
                            newType = Integer.valueOf(subSplit[4]);
                            if (subSplit.length == 7) {
                                localMaterial = Material.valueOf((String)subSplit[5]);
                                localType = Integer.valueOf(subSplit[6]);
                            }
                            b.addConvBlocks(oldMaterial, oldType, newMaterial, newType, convChance, localMaterial, localType);
                        }
                    }
                    this.biomeRecipes.add(b);
                }
            }
            catch (Exception e) {
                this.logger(1, "Problem loading biome recipe - skipping!");
                String validBiomes = "";
                for (Biome biome : Biome.values()) {
                    validBiomes = validBiomes + " " + biome.name();
                }
                this.logger(1, "Valid biomes are " + validBiomes);
                e.printStackTrace();
            }
            if (this.biomeRecipes.size() != 49) continue;
            this.getLogger().warning("Cannot load any more biome recipies - limit is 49!");
            break;
        }
        this.logger(1, "Loaded " + this.biomeRecipes.size() + " biome recipes.");
    }

    public List<BiomeRecipe> getBiomeRecipes() {
        return this.biomeRecipes;
    }

    public void loadPluginConfig() {
        try {
            this.getConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getLocale();
        Locale.generalnotavailable = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("general.notavailable", "Greenhouses are not available in this world"));
        Locale.generalgreenhouses = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("general.greenhouses", "Greenhouses"));
        Locale.generalbiome = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("general.biome", "Biome"));
        Locale.generalowner = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("general.owner", "Owner"));
        Locale.helphelp = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.help", "help"));
        Locale.helpmake = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.make", "Tries to make a greenhouse"));
        Locale.helpremove = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.remove", "Removes a greenhouse that you are standing in if you are the owner"));
        Locale.helpinfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.info", "Shows info on the greenhouse you and general info"));
        Locale.helplist = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.list", "Lists all the greenhouse biomes that can be made"));
        Locale.helpopengui = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.opengui", "Opens the Greenhouse GUI"));
        Locale.helprecipe = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("help.recipe", "Tells you how to make greenhouse biome"));
        Locale.listtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("list.title", "[Greenhouse Biome Recipes]"));
        Locale.listinfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("list.info", "Use /greenhouse recipe <number> to see details on how to make each greenhouse"));
        Locale.errorunknownPlayer = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.unknownPlayer", "That player is unknown."));
        Locale.errornoPermission = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.noPermission", "You don't have permission to use that command!"));
        Locale.errorcommandNotReady = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.commandNotReady", "You can't use that command right now."));
        Locale.errorofflinePlayer = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.offlinePlayer", "That player is offline or doesn't exist."));
        Locale.errorunknownCommand = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.unknownCommand", "Unknown command."));
        Locale.errormove = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.move", "Move to a greenhouse you own first."));
        Locale.errornotowner = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.notowner", "You must be the owner of this greenhouse to do that."));
        Locale.errorremoving = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.removing", "Removing greenhouse!"));
        Locale.errornotyours = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.notyours", "This is not your greenhouse!"));
        Locale.errornotinside = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.notinside", "You are not in a greenhouse!"));
        Locale.errortooexpensive = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.tooexpensive", "You cannot afford [price]"));
        Locale.erroralreadyexists = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.alreadyexists", "Greenhouse already exists!"));
        Locale.errornorecipe = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("error.norecipe", "This does not meet any greenhouse recipe!"));
        Locale.messagesenter = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.enter", "Entering [owner]'s [biome] greenhouse!"));
        Locale.messagesleave = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.leave", "Now leaving [owner]'s greenhouse."));
        Locale.messagesyouarein = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.youarein", "You are now in [owner]'s [biome] greenhouse!"));
        Locale.messagesremoved = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.removed", "This greenhouse is no more..."));
        Locale.messagesremovedmessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.removedmessage", "A [biome] greenhouse of yours is no more!"));
        Locale.messagesecolost = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("messages.ecolost", "Your greenhouse at [location] lost its eco system and was removed."));
        Locale.infotitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.title", "&A[Greenhouse Construction]"));
        Locale.infoinstructions = this.getLocale().getStringList("info.instructions");
        Locale.infoinfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.info", "[Greenhouse Info]"));
        Locale.infonone = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.none", "None"));
        Locale.infowelcome = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.welcome", "&BWelcome! Click here for instructions"));
        Locale.infonomore = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.nomore", "&4You cannot build any more greenhouses!"));
        Locale.infoonemore = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.onemore", "&6You can build one more greenhouse."));
        Locale.infoyoucanbuild = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.youcanbuild", "&AYou can builds up to [number] more greenhouses!"));
        Locale.infounlimited = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("info.unlimited", "&AYou can build an unlimited number of greenhouses!"));
        Locale.recipehint = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.hint", "Use /greenhouse list to see a list of recipe numbers!"));
        Locale.recipewrongnumber = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.wrongnumber", "Recipe number must be between 1 and [size]"));
        Locale.recipetitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.title", "[[biome] recipe]"));
        Locale.recipenowater = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.nowater", "No water allowed."));
        Locale.recipenoice = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.noice", "No ice allowed."));
        Locale.recipenolava = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.nolava", "No lava allowed."));
        Locale.recipewatermustbe = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.watermustbe", "Water > [coverage]% of floor area."));
        Locale.recipeicemustbe = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.icemustbe", "Ice blocks > [coverage]% of floor area."));
        Locale.recipelavamustbe = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.lavamustbe", "Lava > [coverage]% of floor area."));
        Locale.recipeminimumblockstitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.minimumblockstitle", "[Minimum blocks required]"));
        Locale.lineColor = ChatColor.translateAlternateColorCodes((char)'&', (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.linecolor", "&f")));
        Locale.recipenootherblocks = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.nootherblocks", "No other blocks required."));
        Locale.recipemissing = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("recipe.missing", "Greenhouse is missing"));
        Locale.eventbroke = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("event.broke", "You broke this greenhouse! Reverting biome to [biome]!"));
        Locale.eventfix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("event.fix", "Fix the greenhouse and then make it again."));
        Locale.eventcannotplace = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("event.cannotplace", "Blocks cannot be placed above a greenhouse!"));
        Locale.eventpistonerror = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("event.pistonerror", "Pistons cannot push blocks over a greenhouse!"));
        Locale.createnoroof = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.noroof", "There seems to be no roof!"));
        Locale.createmissingwall = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.missingwall", "A wall is missing!"));
        Locale.createnothingabove = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.nothingabove", "There can be no blocks above the greenhouse!"));
        Locale.createholeinroof = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.holeinroof", "There is a hole in the roof or it is not flat!"));
        Locale.createholeinwall = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.holeinwall", "There is a hole in the wall or they are not the same height all the way around!"));
        Locale.createhoppererror = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.hoppererror", "Only one hopper is allowed in the walls or roof."));
        Locale.createdoorerror = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.doorerror", "You cannot have more than 4 doors in the greenhouse!"));
        Locale.createsuccess = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("create.success", "You successfully made a [biome] biome greenhouse!"));
        Locale.adminHelpreload = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("adminHelp.reload", "reload configuration from file."));
        Locale.adminHelpinfo = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("adminHelp.info", "provides info on the greenhouse you are in"));
        Locale.reloadconfigReloaded = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("reload.configReloaded", "Configuration reloaded from file."));
        Locale.admininfoerror = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("admininfo.error", "Greenhouse info only available in-game"));
        Locale.admininfoerror2 = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("admininfo.error2", "Put yourself in a greenhouse to see info."));
        Locale.admininfoflags = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("admininfo.flags", "[Greenhouse Flags]"));
        Locale.newsheadline = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("news.headline", "[Greenhouse News]"));
        Locale.controlpaneltitle = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("controlpanel.title", "&AGreenhouses"));
        Locale.limitslimitedto = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("limits.limitedto", "Permissions limit you to [limit] greenhouses so [number] were removed."));
        Locale.limitsnoneallowed = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getLocale().getString("limits.noneallowed", "Permissions do not allow you any greenhouses so [number] were removed."));
        this.debug = this.getConfig().getStringList("greenhouses.debug");
        Settings.allowFlowIn = this.getConfig().getBoolean("greenhouses.allowflowin", false);
        Settings.allowFlowOut = this.getConfig().getBoolean("greenhouses.allowflowout", false);
        Settings.worldName = this.getConfig().getStringList("greenhouses.worldName");
        if (Settings.worldName.isEmpty()) {
            Settings.worldName.add("world");
        }
        this.logger(1, "Greenhouse worlds are: " + Settings.worldName);
        Settings.snowChanceGlobal = this.getConfig().getDouble("greenhouses.snowchance", 0.5);
        Settings.snowDensity = this.getConfig().getDouble("greenhouses.snowdensity", 0.1);
        Settings.snowSpeed = this.getConfig().getLong("greenhouses.snowspeed", 30L);
        Settings.iceInfluence = this.getConfig().getInt("greenhouses.iceinfluence", 125);
        Settings.ecoTick = this.getConfig().getInt("greenhouses.ecotick", 30);
        Settings.mobTick = this.getConfig().getInt("greenhouses.mobtick", 20);
        Settings.plantTick = this.getConfig().getInt("greenhouses.planttick", 5);
        Settings.blockTick = this.getConfig().getInt("greenhouses.blocktick", 10);
        this.logger(3, "Snowchance " + Settings.snowChanceGlobal);
        this.logger(3, "Snowdensity " + Settings.snowDensity);
        this.logger(3, "Snowspeed " + Settings.snowSpeed);
        Settings.maxGreenhouses = this.getConfig().getInt("greenhouses.maxgreenhouses", -1);
        Settings.deleteExtras = this.getConfig().getBoolean("greenhouses.deleteextras", false);
    }

    public void onDisable() {
        this.saveGreenhouses();
        try {
            this.greenhouses.clear();
            this.playerhouses.clear();
            this.players.removeAllPlayers();
            this.saveMessages();
        }
        catch (Exception e) {
            plugin.getLogger().severe("Something went wrong saving files!");
            e.printStackTrace();
        }
    }

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.saveDefaultLocale();
        new MetricsLite(this);
        if (!VaultHelper.setupEconomy()) {
            this.getLogger().severe("Could not set up economy!");
        }
        this.players = new PlayerCache(this);
        this.loadPluginConfig();
        this.loadBiomeRecipes();
        this.biomeInv = new ControlPanel(this);
        this.getCommand("greenhouse").setExecutor((CommandExecutor)new GreenhouseCmd(this, this.players));
        this.getCommand("gadmin").setExecutor((CommandExecutor)new AdminCmd(this, this.players));
        this.registerEvents();
        this.loadMessages();
        this.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                PluginManager manager = Bukkit.getServer().getPluginManager();
                if (manager.isPluginEnabled("Vault")) {
                    Greenhouses.getPlugin().logger(1, "Trying to use Vault for permissions...");
                    if (!VaultHelper.setupPermissions()) {
                        Greenhouses.this.getLogger().severe("Cannot link with Vault for permissions! Disabling plugin!");
                        manager.disablePlugin((Plugin)Greenhouses.getPlugin());
                    } else {
                        Greenhouses.this.logger(1, "Success!");
                    }
                }
                Greenhouses.this.loadGreenhouses();
            }
        });
        this.ecoTick();
    }

    public void ecoTick() {
        long plantTick;
        if (this.plantTask != null) {
            this.plantTask.cancel();
        }
        if (this.blockTask != null) {
            this.blockTask.cancel();
        }
        if (this.mobTask != null) {
            this.mobTask.cancel();
        }
        if (this.ecoTask != null) {
            this.ecoTask.cancel();
        }
        if ((plantTick = (long)(Settings.plantTick * 60 * 20)) > 0L) {
            this.logger(1, "Kicking off flower growing scheduler every " + Settings.plantTick + " minutes");
            this.plantTask = this.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    for (Greenhouse g : Greenhouses.this.getGreenhouses()) {
                        Greenhouses.this.logger(3, "Servicing greenhouse biome : " + g.getBiome().toString());
                        try {
                            g.growFlowers();
                        }
                        catch (Exception e) {
                            Greenhouses.this.getLogger().severe("Problem found with greenhouse during growing flowers. Skipping...");
                            if (!plugin.getDebug().contains("3")) continue;
                            e.printStackTrace();
                        }
                    }
                }
            }, 80L, plantTick);
        } else {
            this.logger(1, "Flower growth disabled.");
        }
        long blockTick = Settings.blockTick * 60 * 20;
        if (blockTick > 0L) {
            this.logger(1, "Kicking off block conversion scheduler every " + Settings.blockTick + " minutes");
            this.blockTask = this.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    for (Greenhouse g : Greenhouses.this.getGreenhouses()) {
                        try {
                            g.convertBlocks();
                        }
                        catch (Exception e) {
                            Greenhouses.this.getLogger().severe("Problem found with greenhouse during block conversion. Skipping...");
                            Greenhouses.this.getLogger().severe("[Greenhouse info]");
                            Greenhouses.this.getLogger().severe("Owner: " + g.getOwner());
                            Greenhouses.this.getLogger().severe("Location " + g.getPos1().toString() + " to " + g.getPos2().toString());
                            e.printStackTrace();
                        }
                        Greenhouses.this.logger(3, "Servicing greenhouse biome : " + g.getBiome().toString());
                    }
                }
            }, 60L, blockTick);
        } else {
            this.logger(1, "Block conversion disabled.");
        }
        long ecoTick = Settings.plantTick * 60 * 20;
        if (ecoTick > 0L) {
            this.logger(1, "Kicking off greenhouse verify scheduler every " + Settings.ecoTick + " minutes");
            this.ecoTask = this.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            Greenhouses.this.checkEco();
                        }
                        catch (Exception e) {
                            Greenhouses.this.getLogger().severe("Problem found with greenhouse during eco check. Skipping...");
                            if (!plugin.getDebug().contains("3")) break block2;
                            e.printStackTrace();
                        }
                    }
                }
            }, ecoTick, ecoTick);
        } else {
            this.logger(1, "Greenhouse verification disabled.");
        }
        long mobTick = Settings.mobTick * 60 * 20;
        if (mobTick > 0L) {
            this.logger(1, "Kicking off mob populator scheduler every " + Settings.plantTick + " minutes");
            this.mobTask = this.getServer().getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    for (Greenhouse g : Greenhouses.this.getGreenhouses()) {
                        g.populateGreenhouse();
                    }
                }
            }, 120L, mobTick);
        } else {
            this.logger(1, "Mob disabled.");
        }
    }

    public static int randInt(int min, int max) {
        Random rand = new Random();
        int randomNum = rand.nextInt(max - min + 1) + min;
        return randomNum;
    }

    protected void loadGreenhouses() {
        ConfigurationSection myHouses;
        this.greenhouses.clear();
        this.greenhouseFile = new File(this.getDataFolder(), "greenhouses.yml");
        this.greenhouseConfig = new YamlConfiguration();
        File playersFolder = new File(this.getDataFolder(), "players");
        if (!this.greenhouseFile.exists() && !playersFolder.exists()) {
            this.logger(1, "Creating new greenhouse.yml file");
            this.greenhouseConfig.createSection("greenhouses");
            try {
                this.greenhouseConfig.save(this.greenhouseFile);
            }
            catch (IOException e) {
                this.logger(1, "Could not save greenhouse.yml file!");
                e.printStackTrace();
            }
        } else if (!this.greenhouseFile.exists() && playersFolder.exists()) {
            this.logger(1, "Converting from old greenhouse storage to new greenhouse storage");
            ConfigurationSection greenhouseSection = this.greenhouseConfig.createSection("greenhouses");
            int greenhouseNum = 0;
            for (File f : playersFolder.listFiles()) {
                String fileName = f.getName();
                if (!fileName.endsWith(".yml")) continue;
                try {
                    this.logger(1, "Converting " + fileName.substring(0, fileName.length() - 4));
                    UUID playerUUID = UUID.fromString(fileName.substring(0, fileName.length() - 4));
                    if (playerUUID == null) {
                        this.getLogger().warning("Player file contains erroneous UUID data.");
                        this.getLogger().warning("Looking at " + fileName.substring(0, fileName.length() - 4));
                    }
                    YamlConfiguration playerInfo = new YamlConfiguration();
                    playerInfo.load(f);
                    ConfigurationSection myHouses2 = playerInfo.getConfigurationSection("greenhouses");
                    if (myHouses2 == null) continue;
                    for (String key : myHouses2.getKeys(false)) {
                        try {
                            greenhouseSection.set(greenhouseNum + ".owner", (Object)playerUUID.toString());
                            greenhouseSection.set(greenhouseNum + ".playerName", (Object)playerInfo.getString("playerName", ""));
                            greenhouseSection.set(greenhouseNum + ".pos-one", (Object)playerInfo.getString("greenhouses." + key + ".pos-one", ""));
                            greenhouseSection.set(greenhouseNum + ".pos-two", (Object)playerInfo.getString("greenhouses." + key + ".pos-two", ""));
                            greenhouseSection.set(greenhouseNum + ".originalBiome", (Object)playerInfo.getString("greenhouses." + key + ".originalBiome", "PLAINS"));
                            greenhouseSection.set(greenhouseNum + ".greenhouseBiome", (Object)playerInfo.getString("greenhouses." + key + ".greenhouseBiome", "PLAINS"));
                            greenhouseSection.set(greenhouseNum + ".roofHopperLocation", (Object)playerInfo.getString("greenhouses." + key + ".roofHopperLocation"));
                            greenhouseSection.set(greenhouseNum + ".farewellMessage", (Object)playerInfo.getString("greenhouses." + key + ".flags.farewellMessage", ""));
                            greenhouseSection.set(greenhouseNum + ".enterMessage", (Object)playerInfo.getString("greenhouses." + key + ".flags.enterMessage", ""));
                        }
                        catch (Exception e) {
                            plugin.getLogger().severe("Problem copying player files");
                            e.printStackTrace();
                        }
                        ++greenhouseNum;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            try {
                this.greenhouseConfig.save(this.greenhouseFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.greenhouseFile.exists()) {
            try {
                this.greenhouseConfig.load(this.greenhouseFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
        if (this.greenhouseConfig.isConfigurationSection("greenhouses") && (myHouses = this.greenhouseConfig.getConfigurationSection("greenhouses")) != null) {
            for (String key : myHouses.getKeys(false)) {
                this.logger(3, "Loading greenhouse #" + key);
                try {
                    String playerName = myHouses.getString(key + ".playerName", "");
                    Location pos1 = Greenhouses.getLocationString(myHouses.getString(key + ".pos-one"));
                    Location pos2 = Greenhouses.getLocationString(myHouses.getString(key + ".pos-two"));
                    UUID owner = UUID.fromString(myHouses.getString(key + ".owner"));
                    this.logger(3, "File pos1: " + pos1.toString());
                    this.logger(3, "File pos1: " + pos2.toString());
                    if (pos1 != null && pos2 != null) {
                        if (this.checkGreenhouseIntersection(pos1, pos2)) continue;
                        Greenhouse g = new Greenhouse(this, pos1, pos2, owner);
                        this.logger(3, "Greenhouse pos1: " + g.getPos1().toString());
                        this.logger(3, "Greenhouse pos2: " + g.getPos2().toString());
                        g.setPlayerName(playerName);
                        this.logger(3, "Owner is " + playerName);
                        String oBiome = myHouses.getString(key + ".originalBiome", "PLAINS");
                        Biome originalBiome = this.convertBiome(oBiome);
                        g.setOriginalBiome(originalBiome);
                        this.logger(3, "original biome = " + oBiome + " converted = " + originalBiome);
                        String gBiome = myHouses.getString(key + ".greenhouseBiome", "PLAINS");
                        Biome greenhouseBiome = this.convertBiome(gBiome);
                        if (greenhouseBiome == null) {
                            greenhouseBiome = Biome.PLAINS;
                        }
                        this.logger(3, "greenhouse biome = " + gBiome + " converted = " + greenhouseBiome);
                        String recipeName = myHouses.getString(key + ".greenhouseRecipe", "");
                        boolean success = false;
                        for (BiomeRecipe br : this.getBiomeRecipes()) {
                            if (!br.getName().equalsIgnoreCase(recipeName)) continue;
                            success = true;
                            g.setBiomeRecipe(br);
                            break;
                        }
                        if (!success) {
                            for (BiomeRecipe br : this.getBiomeRecipes()) {
                                if (!br.getBiome().equals((Object)greenhouseBiome)) continue;
                                success = true;
                                g.setBiomeRecipe(br);
                                break;
                            }
                        }
                        if (!success) {
                            this.getLogger().warning("*****************************************");
                            this.getLogger().warning("WARNING: No known recipe for biome " + greenhouseBiome.toString());
                            this.getLogger().warning("[Greenhouse info]");
                            this.getLogger().warning("Owner: " + playerName + " UUID:" + g.getOwner());
                            this.getLogger().warning("Location :" + g.getPos1().getWorld().getName() + " " + g.getPos1().getBlockX() + "," + g.getPos1().getBlockZ());
                            this.getLogger().warning("Greenhouse will be removed next eco-tick!");
                            this.getLogger().warning("*****************************************");
                        }
                        g.startBiome(false);
                        Location hopperLoc = Greenhouses.getLocationString(myHouses.getString(key + ".roofHopperLocation"));
                        if (hopperLoc != null) {
                            g.setRoofHopperLocation(hopperLoc);
                        }
                        g.setEnterMessage(myHouses.getString(key + ".enterMessage", Locale.messagesenter.replace("[owner]", playerName).replace("[biome]", Util.prettifyText(gBiome))));
                        g.setFarewellMessage(myHouses.getString(key + ".farewellMessage", Locale.messagesleave.replace("[owner]", playerName)));
                        this.addGHToPlayer(owner, g);
                        continue;
                    }
                    this.getLogger().severe("Problem loading greenhouse with locations " + myHouses.getString(key + ".pos-one") + " and " + myHouses.getString(key + ".pos-two") + " skipping.");
                    this.getLogger().severe("Has this world been deleted?");
                }
                catch (Exception e) {
                    this.getLogger().severe("Problem loading greenhouse file");
                    e.printStackTrace();
                }
            }
            this.logger(3, "Loaded " + plugin.getGreenhouses().size() + " greenhouses.");
        }
        this.logger(1, "Loaded " + this.getGreenhouses().size() + " greenhouses.");
    }

    public void addGHToPlayer(UUID owner, Greenhouse g) {
        HashSet<Greenhouse> storedhouses = null;
        if (this.playerhouses.get(owner) != null) {
            storedhouses = this.playerhouses.get(owner);
            this.playerhouses.remove(owner);
        } else {
            storedhouses = new HashSet<Greenhouse>();
        }
        storedhouses.add(g);
        this.greenhouses.add(g);
        this.playerhouses.put(owner, storedhouses);
    }

    public void removeGHFromPlayer(UUID owner, Greenhouse g) {
        HashSet<Object> storedhouses = null;
        if (this.playerhouses.get(owner) != null) {
            storedhouses = this.playerhouses.get(owner);
            this.playerhouses.remove(owner);
        } else {
            storedhouses = new HashSet();
        }
        storedhouses.remove(g);
        this.greenhouses.remove(g);
        this.playerhouses.put(owner, storedhouses);
    }

    private Biome convertBiome(String oBiome) {
        if (plugin.getServer().getVersion().contains("(MC: 1.8") || plugin.getServer().getVersion().contains("(MC: 1.7")) {
            try {
                return Biome.valueOf((String)oBiome);
            }
            catch (Exception e) {
                this.getLogger().severe("Could not identify Biome " + oBiome + " setting to PLAINS - may destroy greenhouse");
                return Biome.PLAINS;
            }
        }
        if (oBiome.equalsIgnoreCase("COLD_TAIGA")) {
            this.getLogger().warning("Converting Cold Taiga biome to 1.9 Taiga Cold");
            return Biome.TAIGA_COLD;
        }
        if (oBiome.equalsIgnoreCase("FLOWER_FOREST")) {
            this.getLogger().warning("Converting Flower Forest biome to 1.9 Forest");
            return Biome.FOREST;
        }
        if (oBiome.equalsIgnoreCase("BEACH")) {
            this.getLogger().warning("Converting Beach biome to 1.9 Beaches");
            return Biome.BEACHES;
        }
        String test = oBiome;
        while (!test.isEmpty()) {
            for (Biome biome : Biome.values()) {
                if (!biome.name().contains(test)) continue;
                if (!biome.name().equals(test)) {
                    this.getLogger().warning("Converting " + oBiome + " biome to 1.9 " + biome.name() + " - may destroy greenhouse.");
                }
                return biome;
            }
            test = test.substring(0, test.length() - 1);
        }
        this.getLogger().severe("Could not identify Biome " + oBiome + " setting to PLAINS - may destroy greenhouse");
        return Biome.PLAINS;
    }

    public void registerEvents() {
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new GreenhouseGuard(this), (Plugin)this);
        manager.registerEvents((Listener)new GreenhouseEvents(this), (Plugin)this);
        manager.registerEvents((Listener)new JoinLeaveEvents(this, this.players), (Plugin)this);
        manager.registerEvents((Listener)this.biomeInv, (Plugin)this);
        manager.registerEvents((Listener)this.eco, (Plugin)this);
    }

    public void saveDefaultLocale() {
        if (this.localeFile == null) {
            this.localeFile = new File(this.getDataFolder(), "locale.yml");
        }
        if (!this.localeFile.exists()) {
            this.saveResource("locale.yml", false);
        }
    }

    public void reloadLocale() {
        if (this.localeFile == null) {
            this.saveDefaultLocale();
        }
        this.locale = YamlConfiguration.loadConfiguration((File)this.localeFile);
    }

    public FileConfiguration getLocale() {
        if (this.locale == null) {
            this.reloadLocale();
        }
        return this.locale;
    }

    public boolean setMessage(UUID playerUUID, String message) {
        this.logger(3, "received message - " + message);
        Player player = this.getServer().getPlayer(playerUUID);
        if (player != null && player.isOnline()) {
            return false;
        }
        List<String> playerMessages = this.messages.get(playerUUID);
        if (playerMessages != null) {
            playerMessages.add(message);
        } else {
            playerMessages = new ArrayList<String>(Arrays.asList(message));
        }
        this.messages.put(playerUUID, playerMessages);
        return true;
    }

    public List<String> getMessages(UUID playerUUID) {
        List<String> playerMessages = this.messages.get(playerUUID);
        if (playerMessages != null) {
            this.messages.remove(playerUUID);
        } else {
            playerMessages = new ArrayList<String>();
        }
        return playerMessages;
    }

    public boolean saveMessages() {
        this.logger(1, "Saving offline messages...");
        try {
            HashMap<String, List<String>> offlineMessages = new HashMap<String, List<String>>();
            for (UUID p : this.messages.keySet()) {
                offlineMessages.put(p.toString(), this.messages.get(p));
            }
            this.messageStore.set("messages", offlineMessages);
            Greenhouses.saveYamlFile(this.messageStore, "messages.yml");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean loadMessages() {
        this.logger(1, "Loading offline messages...");
        try {
            this.messageStore = this.loadYamlFile("messages.yml");
            if (this.messageStore.getConfigurationSection("messages") == null) {
                this.messageStore.createSection("messages");
            }
            HashMap temp = (HashMap)this.messageStore.getConfigurationSection("messages").getValues(true);
            for (String s : temp.keySet()) {
                List messageList = this.messageStore.getStringList("messages." + s);
                if (messageList.isEmpty()) continue;
                this.messages.put(UUID.fromString(s), messageList);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public HashSet<Greenhouse> getGreenhouses() {
        return this.greenhouses;
    }

    public void setGreenhouses(HashSet<Greenhouse> greenhouses) {
        this.greenhouses = greenhouses;
    }

    public HashMap<UUID, HashSet<Greenhouse>> getPlayerhouses() {
        return this.playerhouses;
    }

    public void clearGreenhouses() {
        this.greenhouses.clear();
    }

    public boolean checkGreenhouseIntersection(Location pos1, Location pos2) {
        Rectangle2D.Double rect = new Rectangle2D.Double();
        rect.setFrameFromDiagonal(pos1.getX(), pos1.getZ(), pos2.getX(), pos2.getZ());
        Rectangle2D.Double testRect = new Rectangle2D.Double();
        for (Greenhouse d : this.greenhouses) {
            testRect.setFrameFromDiagonal(d.getPos1().getX(), d.getPos1().getZ(), d.getPos2().getX(), d.getPos2().getZ());
            if (!rect.intersects(testRect)) continue;
            return true;
        }
        return false;
    }

    public Greenhouse getInGreenhouse(Location location) {
        for (Greenhouse g : this.greenhouses) {
            if (!g.insideGreenhouse(location)) continue;
            return g;
        }
        return null;
    }

    public Greenhouse aboveAGreenhouse(Location location) {
        for (Greenhouse g : this.greenhouses) {
            if (!g.aboveGreenhouse(location)) continue;
            return g;
        }
        return null;
    }

    public void removeGreenhouse(Greenhouse g) {
        this.greenhouses.remove(g);
        this.players.decGreenhouseCount(g.getOwner());
        this.eco.remove(g);
        this.logger(3, "Returning biome to original state: " + g.getOriginalBiome().toString());
        if (g.getOriginalBiome().equals((Object)Biome.HELL) || g.getOriginalBiome().equals((Object)Biome.DESERT) || g.getOriginalBiome().equals((Object)Biome.DESERT_HILLS)) {
            for (int y = g.getPos1().getBlockY(); y < g.getPos2().getBlockY(); ++y) {
                for (int x = g.getPos1().getBlockX(); x <= g.getPos2().getBlockX(); ++x) {
                    for (int z = g.getPos1().getBlockZ(); z <= g.getPos2().getBlockZ(); ++z) {
                        Block b = g.getPos1().getWorld().getBlockAt(x, y, z);
                        if (!b.getType().equals((Object)Material.WATER) && !b.getType().equals((Object)Material.STATIONARY_WATER) && !b.getType().equals((Object)Material.ICE) && !b.getType().equals((Object)Material.PACKED_ICE) && !b.getType().equals((Object)Material.SNOW) && !b.getType().equals((Object)Material.SNOW_BLOCK)) continue;
                        b.setType(Material.AIR);
                        b.getWorld().spawnParticle(Particle.SMOKE_LARGE, b.getLocation(), 5);
                    }
                }
            }
        }
        g.endBiome();
        boolean ownerOnline = false;
        if (!ownerOnline) {
            this.setMessage(g.getOwner(), Locale.messagesremovedmessage.replace("[biome]", Util.prettifyText(g.getBiome().toString())) + " [" + g.getPos1().getBlockX() + "," + g.getPos1().getBlockZ() + "]");
        }
    }

    public void checkEco() {
        this.logger(3, "started eco check");
        ArrayList<Greenhouse> onesToRemove = new ArrayList<Greenhouse>();
        for (Greenhouse g : this.getGreenhouses()) {
            this.logger(3, "Testing greenhouse owned by " + g.getOwner().toString());
            if (g.checkEco()) continue;
            onesToRemove.add(g);
        }
        for (Greenhouse gg : onesToRemove) {
            Player owner = plugin.getServer().getPlayer(gg.getOwner());
            if (owner == null) {
                this.setMessage(gg.getOwner(), Locale.messagesecolost.replace("[location]", Greenhouses.getStringLocation(gg.getPos1())));
            } else {
                owner.sendMessage(ChatColor.RED + Locale.messagesecolost.replace("[location]", Greenhouses.getStringLocation(gg.getPos1())));
            }
            this.logger(1, "Greenhouse at " + Greenhouses.getStringLocation(gg.getPos1()) + " lost its eco system and was removed.");
            this.logger(1, "Greenhouse biome was " + Util.prettifyText(gg.getBiome().toString()) + " - reverted to " + Util.prettifyText(gg.getOriginalBiome().toString()));
            this.removeGreenhouse(gg);
            this.removeGHFromPlayer(owner.getUniqueId(), gg);
        }
        this.saveGreenhouses();
    }

    public Inventory getRecipeInv(Player player) {
        return this.biomeInv.getPanel(player);
    }

    public Greenhouse tryToMakeGreenhouse(Player player) {
        return this.tryToMakeGreenhouse(player, null);
    }

    public Greenhouse tryToMakeGreenhouse(final Player player, BiomeRecipe greenhouseRecipe) {
        if (greenhouseRecipe != null) {
            if (!greenhouseRecipe.getPermission().isEmpty() && !VaultHelper.checkPerm(player, greenhouseRecipe.getPermission())) {
                player.sendMessage(ChatColor.RED + Locale.errornoPermission);
                this.logger(2, "no permssions to use this biome");
                return null;
            }
            String name = greenhouseRecipe.getFriendlyName();
            if (name.isEmpty()) {
                name = Util.prettifyText(greenhouseRecipe.getBiome().name()) + " biome";
            }
            player.sendMessage(ChatColor.GOLD + "Trying to make a " + name + " greenhouse...");
        }
        Location location = player.getLocation().add(new Vector(0, 1, 0));
        this.logger(3, "Player location is " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
        Biome originalBiome = location.getBlock().getBiome();
        World world = location.getWorld();
        Roof roof = new Roof(this, location);
        if (!roof.isRoofFound()) {
            player.sendMessage(ChatColor.RED + Locale.createnoroof);
            this.logger(3, "Roof not found with roof check");
            return null;
        }
        if (player.getLocation().getBlockX() <= roof.getMinX() || player.getLocation().getBlockX() > roof.getMaxX() || player.getLocation().getBlockZ() <= roof.getMinZ() || player.getLocation().getBlockZ() > roof.getMaxZ()) {
            this.logger(3, "Player does not appear to be inside the greenhouse");
            this.logger(3, "Player location " + player.getLocation());
            this.logger(3, "Roof minx = " + roof.getMinX() + " maxx = " + roof.getMaxX());
            this.logger(3, "Roof minz = " + roof.getMinZ() + " maxz = " + roof.getMaxZ());
            player.sendMessage(ChatColor.RED + Locale.errornotinside);
            return null;
        }
        Walls walls = new Walls(this, player, roof);
        int maxX = walls.getMaxX();
        int minX = walls.getMinX();
        int maxZ = walls.getMaxZ();
        int minZ = walls.getMinZ();
        this.logger(3, "minx = " + minX);
        this.logger(3, "maxx = " + maxX);
        this.logger(3, "minz = " + minZ);
        this.logger(3, "maxz = " + maxZ);
        int wallDoors = 0;
        int ghHopper = 0;
        boolean airHoles = false;
        boolean otherBlocks = false;
        boolean inCeiling = false;
        boolean blocksAbove = false;
        int otherBlockLayer = -1;
        int wallBlockCount = 0;
        Location roofHopperLoc = null;
        HashSet redGlass = new HashSet();
        int y = 0;
        for (y = world.getMaxHeight(); y >= walls.getFloor(); --y) {
            HashSet<Location> redLayer = new HashSet<Location>();
            int doorCount = 0;
            int hopperCount = 0;
            boolean airHole = false;
            boolean otherBlock = false;
            boolean blockAbove = false;
            wallBlockCount = 0;
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Location thisBlock = new Location(world, (double)x, (double)y, (double)z);
                    Material blockType = world.getBlockAt(x, y, z).getType();
                    if (y > roof.getHeight()) {
                        if (!world.getEnvironment().equals((Object)World.Environment.NORMAL) && !world.getEnvironment().equals((Object)World.Environment.THE_END) || blockType == Material.AIR) continue;
                        blockAbove = true;
                        redLayer.add(thisBlock);
                        continue;
                    }
                    if (y != roof.getHeight() && x != minX && x != maxX && z != minZ && z != maxZ) continue;
                    if (y != roof.getHeight() && !WALLBLOCKS.contains(blockType.name()) && !blockType.toString().contains("DOOR") || y == roof.getHeight() && !roof.isRoofBlock(blockType) && !blockType.toString().contains("DOOR")) {
                        this.logger(2, "DEBUG: bad block found at  " + x + "," + y + "," + z + " " + blockType);
                        if (blockType == Material.AIR) {
                            airHole = true;
                            if (y == roof.getHeight()) {
                                inCeiling = true;
                            }
                        } else {
                            otherBlock = true;
                        }
                        redLayer.add(thisBlock);
                        continue;
                    }
                    ++wallBlockCount;
                    if (blockType.toString().contains("DOOR")) {
                        ++doorCount;
                        if (wallDoors == 8) {
                            redLayer.add(thisBlock);
                        }
                    }
                    if (!blockType.equals((Object)Material.HOPPER)) continue;
                    ++hopperCount;
                    if (ghHopper > 0) {
                        redLayer.add(thisBlock);
                        continue;
                    }
                    roofHopperLoc = thisBlock.clone();
                }
            }
            if (wallBlockCount == 0 && y < roof.getHeight()) break;
            wallBlockCount = 0;
            wallDoors += doorCount;
            ghHopper += hopperCount;
            if (airHole) {
                airHoles = true;
            }
            if (otherBlock) {
                otherBlocks = true;
                if (otherBlockLayer < 0) {
                    otherBlockLayer = y;
                }
            }
            if (blockAbove) {
                blocksAbove = true;
            }
            redGlass.addAll(redLayer);
        }
        this.logger(3, "Floor is at height y = " + y);
        if (player.getLocation().getBlockY() <= y) {
            player.sendMessage(ChatColor.RED + Locale.errornotinside);
            return null;
        }
        if (!redGlass.isEmpty()) {
            if (blocksAbove) {
                player.sendMessage(ChatColor.RED + Locale.createnothingabove);
            }
            if (airHoles & !inCeiling) {
                player.sendMessage(ChatColor.RED + Locale.createholeinwall);
            } else if (airHoles & inCeiling) {
                player.sendMessage(ChatColor.RED + Locale.createholeinroof);
            }
            if (otherBlocks && otherBlockLayer == y + 1) {
                player.sendMessage(ChatColor.RED + "Walls must be even all the way around");
            } else if (otherBlocks && otherBlockLayer == roof.getHeight()) {
                player.sendMessage(ChatColor.RED + "Roof blocks must be glass, glowstone, doors or a hopper.");
            } else if (otherBlocks) {
                player.sendMessage(ChatColor.RED + "Wall blocks must be glass, glowstone, doors or a hopper.");
            }
            if (wallDoors > 8) {
                player.sendMessage(ChatColor.RED + Locale.createdoorerror);
            }
            if (ghHopper > 1) {
                player.sendMessage(ChatColor.RED + Locale.createhoppererror);
            }
            for (Location loc : redGlass) {
                player.sendBlockChange(loc, Material.STAINED_GLASS, (byte)14);
            }
            final HashSet original = redGlass;
            Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

                @Override
                public void run() {
                    for (Location loc : original) {
                        player.sendBlockChange(loc, loc.getBlock().getType(), loc.getBlock().getData());
                    }
                }
            }, 120L);
            return null;
        }
        Location insideOne = new Location(world, (double)minX, (double)walls.getFloor(), (double)minZ);
        Location insideTwo = new Location(world, (double)maxX, (double)roof.getHeight(), (double)maxZ);
        BiomeRecipe winner = null;
        if (greenhouseRecipe != null) {
            if (greenhouseRecipe.checkRecipe(insideOne, insideTwo, player)) {
                winner = greenhouseRecipe;
            } else {
                return null;
            }
        }
        if (winner == null) {
            int priority = 0;
            for (BiomeRecipe r : plugin.getBiomeRecipes()) {
                if (r.getPermission().isEmpty() || !r.getPermission().isEmpty() && VaultHelper.checkPerm(player, r.getPermission())) {
                    if (r.getPriority() <= priority) continue;
                    player.sendMessage(ChatColor.GOLD + "Trying " + Util.prettifyText(r.getBiome().toString()));
                    if (r.checkRecipe(insideOne, insideTwo, null)) {
                        player.sendMessage(ChatColor.GOLD + "Maybe...");
                        winner = r;
                        priority = r.getPriority();
                        continue;
                    }
                    player.sendMessage(ChatColor.GOLD + "No.");
                    continue;
                }
                plugin.logger(2, "No permission for " + player.getName() + " to make " + r.getBiome().toString());
            }
        }
        if (winner != null) {
            this.logger(3, "biome winner is " + winner.getFriendlyName());
            Greenhouse g = new Greenhouse(this, insideOne, insideTwo, player.getUniqueId());
            g.setOriginalBiome(originalBiome);
            g.setBiomeRecipe(winner);
            String friendlyName = Util.prettifyText(winner.getBiome().toString());
            if (!winner.getFriendlyName().isEmpty()) {
                friendlyName = winner.getFriendlyName();
            }
            g.setPlayerName(player.getName());
            g.setEnterMessage(Locale.messagesenter.replace("[owner]", player.getDisplayName()).replace("[biome]", friendlyName));
            g.setFarewellMessage(Locale.messagesleave.replace("[owner]", player.getDisplayName()).replace("[biome]", friendlyName));
            if (ghHopper == 1) {
                g.setRoofHopperLocation(roofHopperLoc);
            }
            g.startBiome(false);
            player.sendMessage(ChatColor.GREEN + Locale.createsuccess.replace("[biome]", friendlyName));
            this.players.incGreenhouseCount(player);
            this.greenhouses.add(g);
            for (Player p : this.getServer().getOnlinePlayers()) {
                if (!g.insideGreenhouse(p.getLocation()) || p.equals(player)) continue;
                p.sendMessage(Locale.messagesyouarein.replace("[owner]", player.getDisplayName()).replace("[biome]", friendlyName));
            }
            return g;
        }
        return null;
    }

    public void saveGreenhouses() {
        this.logger(2, "Saving greenhouses...");
        ConfigurationSection greenhouseSection = this.greenhouseConfig.createSection("greenhouses");
        int greenhouseNum = 0;
        for (Greenhouse g : this.greenhouses) {
            try {
                greenhouseSection.set(greenhouseNum + ".owner", (Object)g.getOwner().toString());
                greenhouseSection.set(greenhouseNum + ".playerName", (Object)g.getPlayerName());
                greenhouseSection.set(greenhouseNum + ".pos-one", (Object)Greenhouses.getStringLocation(g.getPos1()));
                greenhouseSection.set(greenhouseNum + ".pos-two", (Object)Greenhouses.getStringLocation(g.getPos2()));
                greenhouseSection.set(greenhouseNum + ".originalBiome", (Object)g.getOriginalBiome().toString());
                greenhouseSection.set(greenhouseNum + ".greenhouseBiome", (Object)g.getBiome().toString());
                greenhouseSection.set(greenhouseNum + ".greenhouseRecipe", (Object)g.getBiomeRecipe().getName());
                greenhouseSection.set(greenhouseNum + ".roofHopperLocation", (Object)Greenhouses.getStringLocation(g.getRoofHopperLocation()));
                greenhouseSection.set(greenhouseNum + ".farewellMessage", (Object)g.getFarewellMessage());
                greenhouseSection.set(greenhouseNum + ".enterMessage", (Object)g.getEnterMessage());
            }
            catch (Exception e) {
                plugin.getLogger().severe("Problem copying player files");
                e.printStackTrace();
            }
            ++greenhouseNum;
        }
        try {
            this.greenhouseConfig.save(this.greenhouseFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save greenhouse.yml!");
            e.printStackTrace();
        }
    }

    public void logger(int level, String info) {
        if (this.debug.contains("0")) {
            return;
        }
        if (this.debug.contains("1") && level == 1) {
            Bukkit.getLogger().info(info);
        } else if (this.debug.contains(String.valueOf(level))) {
            Bukkit.getLogger().info("DEBUG [" + level + "]:" + info);
        }
    }

    public List<String> getDebug() {
        return this.debug;
    }

    public int getMaxGreenhouses(Player player) {
        int maxGreenhouses = Settings.maxGreenhouses;
        for (PermissionAttachmentInfo perms : player.getEffectivePermissions()) {
            if (perms.getPermission().startsWith("greenhouses.limit")) {
                this.logger(2, "Permission is = " + perms.getPermission());
                try {
                    int max = Integer.valueOf(perms.getPermission().split("greenhouses.limit.")[1]);
                    if (max > maxGreenhouses) {
                        maxGreenhouses = max;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (maxGreenhouses >= 0) continue;
            maxGreenhouses = -1;
        }
        return maxGreenhouses;
    }

    static {
        pluginWorld = null;
    }
}

