/*
 * Decompiled with CFR 0.152.
 */
package me.harrysmc.craftingplus.craftingrecipe;

import java.util.logging.Logger;
import me.harrysmc.craftingplus.CraftingPlus;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Recipe;

public abstract class CraftingRecipe {
    private final CraftingPlus plugin;
    private final FileConfiguration config;
    private final Logger log;
    private final String name;

    public CraftingRecipe(CraftingPlus plugin, String name) {
        this.plugin = plugin;
        this.name = name;
        this.log = plugin.getLogger();
        this.config = plugin.getConfig();
    }

    public void setup() {
        if (!this.config.contains("enabled." + this.name)) {
            this.log.warning("ERROR finding: 'enabled." + this.name + "' in the config.");
            return;
        }
        if (this.config.getBoolean("enabled." + this.name)) {
            this.plugin.getServer().addRecipe(this.getRecipe());
        }
    }

    public abstract Recipe getRecipe();
}

