/*
 * Decompiled with CFR 0.152.
 */
package me.harrysmc.craftingplus;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import me.harrysmc.craftingplus.RecipeManager;
import me.harrysmc.craftingplus.cmd.CmdManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Recipe;
import org.bukkit.plugin.java.JavaPlugin;

public class CraftingPlus
extends JavaPlugin {
    private List<Recipe> vanillaRecipes;
    private final Logger log = this.getLogger();
    private FileConfiguration config = this.getConfig();
    private String permissionMessage;
    private String reloadSuccessMessage;
    private String invalidCommandMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.log.info("Config setup!");
        this.reloadData();
        this.log.info("Data reloaded!");
        this.iterateVanillaRecipes();
        new RecipeManager(this);
        this.log.info("All recipes setup!");
        this.addCommands();
        this.log.info("Commands setup!");
    }

    public void onDisable() {
        Bukkit.getServer().clearRecipes();
        this.log.info("Recipes cleared!");
    }

    private void addCommands() {
        this.getCommand("craftingplus").setExecutor((CommandExecutor)new CmdManager(this));
    }

    private void iterateVanillaRecipes() {
        this.vanillaRecipes = new ArrayList<Recipe>();
        Iterator it = Bukkit.recipeIterator();
        while (it.hasNext()) {
            this.vanillaRecipes.add((Recipe)it.next());
        }
    }

    public void reloadData() {
        this.reloadConfig();
        this.config = this.getConfig();
        this.permissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("permission-message"));
        this.reloadSuccessMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("reload-success-message"));
        this.invalidCommandMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("invalid-command-message"));
    }

    public String getPermissionMessage() {
        return this.permissionMessage;
    }

    public String getReloadSuccessMessage() {
        return this.reloadSuccessMessage;
    }

    public String getInvalidCommandMessage() {
        return this.invalidCommandMessage;
    }

    public List<Recipe> getVanillaRecipes() {
        return this.vanillaRecipes;
    }
}

