/*
 * Decompiled with CFR 0.152.
 */
package com.pinayt.prs.events;

import com.pinayt.playerrankselector.Jugadores;
import com.pinayt.playerrankselector.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class Inventory
implements Listener {
    private Main plugin;
    FileConfiguration ranks;

    public Inventory(Main plugin, FileConfiguration ranks) {
        this.plugin = plugin;
        this.ranks = ranks;
    }

    public void print(String s) {
        Bukkit.getConsoleSender().sendMessage(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)s));
    }

    public void crearInventarioJugadores(Player jugador) {
        FileConfiguration messages = this.plugin.getMessages();
        org.bukkit.inventory.Inventory inv = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)messages.getString("invs.all-players-inv")));
        int i = 0;
        for (Player player : Bukkit.getOnlinePlayers()) {
            ItemStack cabeza = new ItemStack(397, 1, 3);
            SkullMeta meta = (SkullMeta)cabeza.getItemMeta();
            meta.setDisplayName(net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)("&a" + player.getName())));
            meta.setOwner(player.getName());
            cabeza.setItemMeta((ItemMeta)meta);
            inv.setItem(i, cabeza);
            if (++i != 54) continue;
            break;
        }
        jugador.openInventory(inv);
    }

    @EventHandler
    public void clickearInventarioJugadores(InventoryClickEvent event) {
        FileConfiguration messages = this.plugin.getMessages();
        String titulo = ChatColor.translateAlternateColorCodes((char)'&', (String)messages.getString("invs.all-players-inv"));
        String titulom = ChatColor.stripColor((String)titulo);
        if (!ChatColor.stripColor((String)event.getInventory().getName()).equals(titulom)) {
            return;
        }
        if (event.getCurrentItem() == null) {
            event.setCancelled(true);
            return;
        }
        if (event.getCurrentItem().getType() == Material.AIR || event.getSlotType() == null) {
            event.setCancelled(true);
            return;
        }
        Player jugador = (Player)event.getWhoClicked();
        event.setCancelled(true);
        if (event.getInventory().equals(jugador.getOpenInventory().getTopInventory())) {
            SkullMeta meta = (SkullMeta)event.getCurrentItem().getItemMeta();
            String nombre = meta.getOwner();
            this.crearInventario(jugador, nombre);
        }
    }

    public void crearInventario(Player jugador, String jugadorModificado) {
        FileConfiguration messages = this.plugin.getMessages();
        org.bukkit.inventory.Inventory inv = Bukkit.createInventory(null, (int)54, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)messages.getString("invs.change-rank-player").replace("%player%", jugadorModificado)));
        for (String key : this.ranks.getConfigurationSection("ranks").getKeys(false)) {
            ItemStack item = new ItemStack(this.ranks.getInt("ranks." + key + ".item"), 1);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)this.ranks.getString("ranks." + key + ".item_name")));
            item.setItemMeta(meta);
            inv.setItem(this.ranks.getInt("ranks." + key + ".slot"), item);
        }
        jugador.openInventory(inv);
        Jugadores troll = new Jugadores(jugadorModificado, jugador.getName());
        if (!this.plugin.jugadorEstaTrolleando(jugador.getName())) {
            this.plugin.agregarTrolleo(troll);
        }
    }

    @EventHandler
    public void clickearInventarioTrolleos(InventoryClickEvent event) {
        FileConfiguration messages = this.plugin.getMessages();
        Player jugador = (Player)event.getWhoClicked();
        if (this.plugin.jugadorEstaTrolleando(jugador.getName())) {
            if (event.getCurrentItem() == null) {
                event.setCancelled(true);
                return;
            }
            if (event.getCurrentItem().getType() == Material.AIR || event.getSlotType() == null) {
                event.setCancelled(true);
                return;
            }
            event.setCancelled(true);
            Jugadores troll = this.plugin.getTroll(jugador.getName());
            Player jugadorTrolleado = Bukkit.getPlayer((String)troll.getJugadorTrolleado());
            for (String key : this.ranks.getConfigurationSection("ranks").getKeys(false)) {
                String slot = this.ranks.getString("ranks." + key + ".slot");
                if (!Integer.toString(event.getSlot()).equals(slot)) continue;
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getServer().getConsoleSender(), "lp user " + jugadorTrolleado.getName() + " parent set " + this.ranks.getString("ranks." + key + ".rank_name"));
                jugador.closeInventory();
                jugador.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)messages.getString("invs.change-rank-player").replace("%player%", jugadorTrolleado.getName()).replace("%rank%", this.ranks.getString("ranks." + key + ".rank_name"))));
            }
        }
    }

    @EventHandler
    public void cerrarInventario(InventoryCloseEvent event) {
        Player jugador = (Player)event.getPlayer();
        if (this.plugin.jugadorEstaTrolleando(jugador.getName())) {
            this.plugin.removerTrolleo(jugador.getName());
        }
    }
}

