/*
 * Decompiled with CFR 0.152.
 */
package com.anastasia.welcomer.configurations;

import com.anastasia.welcomer.Welcomer;
import com.anastasia.welcomer.utils.SettingsUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    private final Welcomer instance;
    private File file;
    private String fileName;
    protected FileConfiguration fileConfiguration;

    public Configuration(Welcomer instance, String fileName) {
        this.instance = instance;
        this.fileName = fileName;
        this.file = new File(instance.getDataFolder(), fileName);
        this.loadConfig();
    }

    public Configuration(Welcomer instance, String folderName, String fileName) {
        this.instance = instance;
        this.fileName = fileName;
        File folder = new File(instance.getDataFolder(), folderName);
        this.file = folder.isDirectory() ? new File(folder, fileName) : new File(folder.getParentFile(), fileName);
        this.loadConfig();
    }

    public static void createFiles(Welcomer instance, String fileName) {
        File file = new File(instance.getDataFolder(), fileName);
        if (!file.exists()) {
            instance.saveResource(fileName, false);
        }
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(instance.getResource(fileName)));
        for (String path : yamlConfiguration2.getKeys(true)) {
            if (yamlConfiguration2.contains(path) && yamlConfiguration2.get(path).getClass().getName() == yamlConfiguration2.get(path).getClass().getName()) continue;
            instance.getLogger().log(Level.WARNING, path + "added to [" + fileName + "] !");
            yamlConfiguration2.set(path, yamlConfiguration2.get(path));
        }
    }

    public void loadConfig() {
        if (this.instance.getResource(this.fileName) != null && !this.file.exists()) {
            this.instance.saveResource(this.fileName, false);
        }
        if (this.file.exists()) {
            try {
                this.fileConfiguration = Configuration.loadConfiguration(this.file);
            }
            catch (InvalidConfigurationException e) {
                this.instance.getLogger().log(Level.SEVERE, "the file [" + this.fileName + "] can't be loaded, check file syntax first!");
                this.instance.getLogger().log(Level.SEVERE, e.getMessage());
                File renamed = new File(this.file.getParentFile(), this.fileName + ".old");
                this.loadConfig();
            }
            catch (IOException ex) {
                this.instance.getLogger().log(Level.SEVERE, "Can't read file  [" + this.fileName + "] !");
                this.fileConfiguration = new YamlConfiguration();
            }
        } else {
            this.fileConfiguration = new YamlConfiguration();
        }
    }

    private static YamlConfiguration loadConfiguration(File file) throws IOException, InvalidConfigurationException {
        Validate.notNull((Object)file, (String)"File cannot be null !");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        return config;
    }

    public void saveFiles() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfiguration() {
        return this.fileConfiguration;
    }

    public FileConfiguration getConfiguration(String fileName) {
        SettingsUtil settingsUtil = new SettingsUtil(Welcomer.getInstance());
        this.fileName = fileName;
        this.file = new File(this.instance.getDataFolder(), fileName);
        this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        if (fileName.equals("menus/translations_" + settingsUtil.getLang() + ".yml") && !this.file.exists()) {
            this.fileName = fileName;
            this.file = new File(this.instance.getDataFolder(), "menus/translations_en.yml");
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }
        if (fileName.equals("messages/translations_" + settingsUtil.getLang() + ".yml") && !this.file.exists()) {
            this.fileName = fileName;
            this.file = new File(this.instance.getDataFolder(), "messages/translations_en.yml");
            this.fileConfiguration = YamlConfiguration.loadConfiguration((File)this.file);
        }
        return this.fileConfiguration;
    }

    public void set(String path, Object o) {
        this.fileConfiguration.set(path, o);
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getString(String path) {
        return this.fileConfiguration.getString(path);
    }

    public List<String> getStringList(String path) {
        return this.fileConfiguration.getStringList(path);
    }

    public boolean getBoolean(String path) {
        return this.fileConfiguration.getBoolean(path);
    }
}

