/*
 * Decompiled with CFR 0.152.
 */
package com.anastasia.welcomer;

import com.anastasia.welcomer.configurations.Configuration;
import com.anastasia.welcomer.managers.CommandsManager;
import com.anastasia.welcomer.managers.ListenersManager;
import com.anastasia.welcomer.managers.MessagesManager;
import com.anastasia.welcomer.systems.TranslationSystem;
import com.anastasia.welcomer.utils.MessagesUtil;
import com.anastasia.welcomer.utils.SettingsUtil;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public final class Welcomer
extends JavaPlugin {
    private static Welcomer instance;
    private final CommandsManager commandsManager = new CommandsManager();
    private final ListenersManager listenersManager = new ListenersManager();
    private final MessagesUtil messagesUtil = new MessagesUtil();
    private MessagesManager messagesManager;

    public void onEnable() {
        instance = this;
        this.createFiles();
        this.loadFiles();
        this.listenersManager.getListenersManager();
        this.commandsManager.getCommandsManager();
    }

    public void onDisable() {
    }

    public static Welcomer getInstance() {
        return instance;
    }

    public void createFiles() {
        Configuration.createFiles(this, "configurations/settings.yml");
        Configuration.createFiles(this, "messages/translations_en.yml");
        Configuration.createFiles(this, "messages/translations_fr.yml");
        Configuration.createFiles(this, "menus/translations_en.yml");
        Configuration.createFiles(this, "menus/translations_fr.yml");
    }

    public void loadFiles() {
        SettingsUtil settingsUtil = new SettingsUtil(this);
        Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&8&m------------------------------ &e[&9Welcomer&e] &8&m------------------------------"));
        Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&eVersion &8-> &7[&e4.0.3&7]."));
        Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&eConfiguration loaded &8-> &7Configuration successfully loaded."));
        TranslationSystem translationSystem = new TranslationSystem(this, settingsUtil.getLang());
        if (settingsUtil.getLang() == null) {
            Configuration configuration = new Configuration(this, "configurations/settings.yml");
            configuration.getConfiguration().set("Language", (Object)"en");
            configuration.saveFiles();
            Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&e[ERROR] Language loaded &8-> &7Your language cannot be null, we gave you the default!"));
        } else if (Objects.equals(settingsUtil.getLang(), "")) {
            Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&e[ERROR] Language loaded &8-> &7You can't put a language that is empty."));
        } else {
            int n = 0;
            char[] cArray = settingsUtil.getLang().toCharArray();
            int n2 = cArray.length;
            if (n < n2) {
                char c = cArray[n];
                if (Character.isUpperCase(c)) {
                    Configuration configuration = new Configuration(this, "configurations/settings.yml");
                    configuration.getConfiguration().set("Language", (Object)settingsUtil.getLang().toLowerCase());
                    configuration.saveFiles();
                    Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&e[ERROR] Language loaded &8-> &7Your language cannot be capitalized, so we put your current language in lower case!"));
                } else {
                    Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&eLanguage loaded &8-> &7Language successfully loaded."));
                    Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&eLanguage &8-> &7You are currently using the language [&e<language>&7].").replace("<language>", settingsUtil.getLang().toUpperCase()));
                }
            }
        }
        if (this.messagesManager != null) {
            this.messagesManager.setSettings(settingsUtil);
            this.messagesManager.setLang(translationSystem);
        } else {
            this.messagesManager = new MessagesManager(this, settingsUtil, translationSystem);
        }
        Bukkit.getConsoleSender().sendMessage(this.messagesUtil.sendMessageLog(false, "&8&m------------------------------------------------------------------------"));
    }

    public MessagesManager getMessageManager() {
        return this.messagesManager;
    }
}

