/*
 * Decompiled with CFR 0.152.
 */
package net.cozycosmos.serverlevels;

import java.io.File;
import net.cozycosmos.serverlevels.commands.Core;
import net.cozycosmos.serverlevels.events.BlockBreak;
import net.cozycosmos.serverlevels.events.BlockPlace;
import net.cozycosmos.serverlevels.events.EntityDeath;
import net.cozycosmos.serverlevels.events.LevelupLis;
import net.cozycosmos.serverlevels.events.PlayerChat;
import net.cozycosmos.serverlevels.events.PlayerDeath;
import net.cozycosmos.serverlevels.events.PlayerJoin;
import net.cozycosmos.serverlevels.extras.ConfigUpdater;
import net.cozycosmos.serverlevels.extras.Metrics;
import net.cozycosmos.serverlevels.extras.UpdateChecker;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class Main
extends JavaPlugin {
    public PluginManager pm;
    public ConsoleCommandSender cs;
    File milestonesYml = new File(this.getDataFolder() + "/milestones.yml");
    File mobsYml = new File(this.getDataFolder() + "/mobs.yml");
    File systemsYml = new File(this.getDataFolder() + "/levelsystems.yml");

    public void onEnable() {
        this.pm = Bukkit.getServer().getPluginManager();
        this.cs = Bukkit.getServer().getConsoleSender();
        this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Enabling ServerLevels");
        new UpdateChecker(this, 98696).getVersion((Consumer<String>)((Consumer)version -> {
            if (this.getDescription().getVersion().equalsIgnoreCase((String)version)) {
                this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "You're running the latest version!");
            } else {
                this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "There's a new update available!");
                this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "You're running version " + this.getDescription().getVersion() + " While the latest version is " + version + "!");
            }
        }));
        this.registerConfigs();
        this.registerEvents();
        this.registerCommands();
        int pluginId = 13727;
        Metrics metrics = new Metrics(this, pluginId);
        this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "ServerLevels Enabled");
    }

    public void onDisable() {
    }

    public void registerConfigs() {
        this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Registering Configs");
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        ConfigUpdater configUpdater = new ConfigUpdater();
        configUpdater.updateConfig(this.getConfig().getString("config-version"));
        if (!this.milestonesYml.exists()) {
            this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Creating milestones.yml");
            this.saveResource("milestones.yml", false);
        }
        if (!this.mobsYml.exists()) {
            this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Creating mobs.yml");
            this.saveResource("mobs.yml", false);
        }
        if (!this.systemsYml.exists()) {
            this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Creating levelsystems.yml");
            this.saveResource("levelsystems.yml", false);
        }
    }

    public void registerCommands() {
        this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Registering commands");
        this.getCommand("serverlevels").setExecutor((CommandExecutor)new Core());
    }

    public void registerEvents() {
        this.cs.sendMessage(ChatColor.GRAY + "[ServerLevels] " + ChatColor.GREEN + "Registering Events");
        this.pm.registerEvents((Listener)new LevelupLis(), (Plugin)this);
        if (this.getConfig().getDouble("exp-on-blockbreak") != -1.0) {
            this.pm.registerEvents((Listener)new BlockBreak(), (Plugin)this);
        }
        if (this.getConfig().getDouble("exp-on-blockplace") != -1.0) {
            this.pm.registerEvents((Listener)new BlockPlace(), (Plugin)this);
        }
        if (this.getConfig().getDouble("exp-on-mobkill") != -1.0) {
            this.pm.registerEvents((Listener)new EntityDeath(), (Plugin)this);
        }
        this.pm.registerEvents((Listener)new PlayerChat(), (Plugin)this);
        if (this.getConfig().getDouble("exp-on-playerkill") != -1.0) {
            this.pm.registerEvents((Listener)new PlayerDeath(), (Plugin)this);
        }
        this.pm.registerEvents((Listener)new PlayerJoin(), (Plugin)this);
    }

    public void reloadConfigs() {
        this.reloadConfig();
        YamlConfiguration.loadConfiguration((File)this.milestonesYml);
        YamlConfiguration.loadConfiguration((File)this.mobsYml);
        YamlConfiguration.loadConfiguration((File)this.systemsYml);
    }
}

