/*
 * Decompiled with CFR 0.152.
 */
package com.iridium.iridiumcolorapi;

import com.google.common.collect.ImmutableMap;
import com.iridium.iridiumcolorapi.patterns.GradientPattern;
import com.iridium.iridiumcolorapi.patterns.Pattern;
import com.iridium.iridiumcolorapi.patterns.RainbowPattern;
import com.iridium.iridiumcolorapi.patterns.SolidPattern;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.md_5.bungee.api.ChatColor;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;

public class IridiumColorAPI {
    private static final int VERSION = IridiumColorAPI.getVersion();
    private static final boolean SUPPORTS_RGB = VERSION >= 16;
    private static final List<String> SPECIAL_COLORS = Arrays.asList("&l", "&n", "&o", "&k", "&m", "\u00a7l", "\u00a7n", "\u00a7o", "\u00a7k", "\u00a7m");
    private static final Map<Color, ChatColor> COLORS = ImmutableMap.builder().put((Object)new Color(0), (Object)ChatColor.getByChar((char)'0')).put((Object)new Color(170), (Object)ChatColor.getByChar((char)'1')).put((Object)new Color(43520), (Object)ChatColor.getByChar((char)'2')).put((Object)new Color(43690), (Object)ChatColor.getByChar((char)'3')).put((Object)new Color(0xAA0000), (Object)ChatColor.getByChar((char)'4')).put((Object)new Color(0xAA00AA), (Object)ChatColor.getByChar((char)'5')).put((Object)new Color(0xFFAA00), (Object)ChatColor.getByChar((char)'6')).put((Object)new Color(0xAAAAAA), (Object)ChatColor.getByChar((char)'7')).put((Object)new Color(0x555555), (Object)ChatColor.getByChar((char)'8')).put((Object)new Color(0x5555FF), (Object)ChatColor.getByChar((char)'9')).put((Object)new Color(0x55FF55), (Object)ChatColor.getByChar((char)'a')).put((Object)new Color(0x55FFFF), (Object)ChatColor.getByChar((char)'b')).put((Object)new Color(0xFF5555), (Object)ChatColor.getByChar((char)'c')).put((Object)new Color(0xFF55FF), (Object)ChatColor.getByChar((char)'d')).put((Object)new Color(0xFFFF55), (Object)ChatColor.getByChar((char)'e')).put((Object)new Color(0xFFFFFF), (Object)ChatColor.getByChar((char)'f')).build();
    private static final List<Pattern> PATTERNS = Arrays.asList(new GradientPattern(), new SolidPattern(), new RainbowPattern());

    @Nonnull
    public static String process(@Nonnull String string) {
        for (Pattern pattern : PATTERNS) {
            string = pattern.process(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    @Nonnull
    public static List<String> process(@Nonnull List<String> strings) {
        return strings.stream().map(IridiumColorAPI::process).collect(Collectors.toList());
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color color) {
        return (SUPPORTS_RGB ? ChatColor.of((Color)color) : IridiumColorAPI.getClosestColor(color)) + string;
    }

    @Nonnull
    public static String color(@Nonnull String string, @Nonnull Color start, @Nonnull Color end) {
        String originalString = string;
        ChatColor[] colors = IridiumColorAPI.createGradient(start, end, IridiumColorAPI.withoutSpecialChar(string).length());
        return IridiumColorAPI.apply(originalString, colors);
    }

    @Nonnull
    public static String rainbow(@Nonnull String string, float saturation) {
        String originalString = string;
        ChatColor[] colors = IridiumColorAPI.createRainbow(IridiumColorAPI.withoutSpecialChar(string).length(), saturation);
        return IridiumColorAPI.apply(originalString, colors);
    }

    @Nonnull
    public static ChatColor getColor(@Nonnull String string) {
        return SUPPORTS_RGB ? ChatColor.of((Color)new Color(Integer.parseInt(string, 16))) : IridiumColorAPI.getClosestColor(new Color(Integer.parseInt(string, 16)));
    }

    @Nonnull
    public static String stripColorFormatting(@Nonnull String string) {
        return string.replaceAll("<#[0-9A-F]{6}>|[&\u00a7][a-f0-9lnokm]|<[/]?[A-Z]{5,8}(:[0-9A-F]{6})?[0-9]*>", "");
    }

    @Nonnull
    private static String apply(@Nonnull String source, ChatColor[] colors) {
        StringBuilder specialColors = new StringBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        String[] characters = source.split("");
        int outIndex = 0;
        for (int i = 0; i < characters.length; ++i) {
            if (characters[i].equals("&") || characters[i].equals("\u00a7")) {
                if (i + 1 < characters.length) {
                    if (characters[i + 1].equals("r")) {
                        specialColors.setLength(0);
                    } else {
                        specialColors.append(characters[i]);
                        specialColors.append(characters[i + 1]);
                    }
                    ++i;
                    continue;
                }
                stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
                continue;
            }
            stringBuilder.append(colors[outIndex++]).append((CharSequence)specialColors).append(characters[i]);
        }
        return stringBuilder.toString();
    }

    @Nonnull
    private static String withoutSpecialChar(@Nonnull String source) {
        String workingString = source;
        for (String color : SPECIAL_COLORS) {
            if (!workingString.contains(color)) continue;
            workingString = workingString.replace(color, "");
        }
        return workingString;
    }

    @Nonnull
    private static ChatColor[] createRainbow(int step, float saturation) {
        ChatColor[] colors = new ChatColor[step];
        double colorStep = 1.0 / (double)step;
        for (int i = 0; i < step; ++i) {
            Color color = Color.getHSBColor((float)(colorStep * (double)i), saturation, saturation);
            colors[i] = SUPPORTS_RGB ? ChatColor.of((Color)color) : IridiumColorAPI.getClosestColor(color);
        }
        return colors;
    }

    @Nonnull
    private static ChatColor[] createGradient(@Nonnull Color start, @Nonnull Color end, int step) {
        ChatColor[] colors = new ChatColor[step];
        int stepR = Math.abs(start.getRed() - end.getRed()) / (step - 1);
        int stepG = Math.abs(start.getGreen() - end.getGreen()) / (step - 1);
        int stepB = Math.abs(start.getBlue() - end.getBlue()) / (step - 1);
        int[] direction = new int[]{start.getRed() < end.getRed() ? 1 : -1, start.getGreen() < end.getGreen() ? 1 : -1, start.getBlue() < end.getBlue() ? 1 : -1};
        for (int i = 0; i < step; ++i) {
            Color color = new Color(start.getRed() + stepR * i * direction[0], start.getGreen() + stepG * i * direction[1], start.getBlue() + stepB * i * direction[2]);
            colors[i] = SUPPORTS_RGB ? ChatColor.of((Color)color) : IridiumColorAPI.getClosestColor(color);
        }
        return colors;
    }

    @Nonnull
    private static ChatColor getClosestColor(Color color) {
        Color nearestColor = null;
        double nearestDistance = 2.147483647E9;
        for (Color constantColor : COLORS.keySet()) {
            double distance = Math.pow(color.getRed() - constantColor.getRed(), 2.0) + Math.pow(color.getGreen() - constantColor.getGreen(), 2.0) + Math.pow(color.getBlue() - constantColor.getBlue(), 2.0);
            if (!(nearestDistance > distance)) continue;
            nearestColor = constantColor;
            nearestDistance = distance;
        }
        return COLORS.get(nearestColor);
    }

    private static int getVersion() {
        String version = Bukkit.getVersion();
        Validate.notEmpty((String)version, (String)"Cannot get major Minecraft version from null or empty string");
        int index = version.lastIndexOf("MC:");
        if (index != -1) {
            version = version.substring(index + 4, version.length() - 1);
        } else if (version.endsWith("SNAPSHOT")) {
            index = version.indexOf(45);
            version = version.substring(0, index);
        }
        int lastDot = version.lastIndexOf(46);
        if (version.indexOf(46) != lastDot) {
            version = version.substring(0, lastDot);
        }
        return Integer.parseInt(version.substring(2));
    }
}

